;;;
;;; tl-seq.el --- sequence functions
;;;
;;; Copyright (C) 1995 Free Software Foundation, Inc.
;;; Copyright (C) 1995 MORIOKA Tomohiko
;;;
;;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;;; Version:
;;;	$Id: tl-seq.el,v 6.0 1995/10/03 05:23:34 morioka Exp $
;;; Keywords: sequence, list, string, array
;;;
;;; This file is part of tm (Tools for MIME).
;;;


(defun some-element (pred seq)
  "Return the first element of sequence SEQ
whose return value applied function PRED is not nil. [tl-list]"
  (let ((i 0)(len (length seq)) element)
    (catch 'tag
      (while (< i len)
	(if (funcall pred (setq element (elt seq i)))
	    (throw 'tag element)
	  )
	(setq i (+ i 1))
	))
    ))

(defun find (item seq)
  "Return a element which is found in sequence SEQ as item. [tl-list]"
  (some-element (function
		 (lambda (elt)
		   (eq elt item)
		   ))
		seq))

(defun position-mismatched (pred seq)
  "Return first position of element which is in sequence SEQ
and mismatched as predicate function PRED.
If all elements is not mismatched,
return length of the sequence SEQ. [tl-seq]"
  (let ((i 0)(len (length seq)))
    (while (and (< i len)
		(funcall pred (elt seq i))
		)
      (setq i (1+ i))
      )
    i))

(defun foldl (func a seq)
  "Return (... (func (func (func a S0) S1) S2) ...)
when func's argument is 2 and seq is a sequence whose
elements = S0 S1 S2 .... [tl-seq]"
  (let ((len (length seq))
	(i 0))
    (while (< i len)
      (setq a (funcall func a (elt seq i)))
      (setq i (+ i 1))
      )
    a))

(defun pack-sequence (seq size)
  (let ((len (length seq)) (p 0) obj
	unit (i 0)
	dest)
    (while (< p len)
      (setq obj (elt seq p))
      (setq unit (cons obj unit))
      (setq i (1+ i))
      (if (= i size)
	  (progn
	    (setq dest (cons (reverse unit) dest))
	    (setq unit nil)
	    (setq i 0)
	    ))
      (setq p (1+ p))
      )
    (if unit
	(setq dest (cons (reverse unit) dest))
      )
    (reverse dest)
    ))


;;; @ end
;;;

(provide 'tl-seq)
