<?xml version="1.0" ?>
<!--
   Copyright (c) 2000,2001 Dave Carrigan <dave@rudedog.org>
   All rights reserved.
  
   This module is free software; you can redistribute it and/or modify
   it under the same terms as Apache itself. This module is
   distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. The copyright holder of this
   module can not be held liable for any general, special, incidental
   or consequential damages arising out of the use of the module.

   $Id: Changes.xsl,v 1.2 2001/02/16 23:06:20 dave Exp $
-->

<xsl:stylesheet 
  version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:strip-space elements="config"/>

  <xsl:template match="changelog">
    <html>
      <xsl:comment>
	Copyright (C) 2000,2001 Dave Carrigan &lt;dave@rudedog.org&gt;
	Automatically generated from the XML source and XSLT stylesheet
	using Xalan and Xerces.
      </xsl:comment>
      <head>
	<title>auth_ldap Change Log</title>
      </head>
    </html>

    <body bgcolor="white">
      <center><h1>auth_ldap Change Log</h1></center>
      <xsl:apply-templates />
    </body>
  </xsl:template> 

  <xsl:template match="section">
    <h2><xsl:value-of select="@title" /></h2>
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="versionchange">
    <h3>
      Changes from <xsl:value-of select="@from" /> to <xsl:value-of select="@to" />
    </h3>
    <xsl:apply-templates select="note" />
    <ul>
      <xsl:apply-templates select="change" />
    </ul>
  </xsl:template>

  <xsl:template match="change">
    <li>
      <xsl:apply-templates />
    </li>
  </xsl:template>

  <xsl:template match="list">
    <ul>
      <xsl:apply-templates />
    </ul>
  </xsl:template>

  <xsl:template match="item">
    <li>
      <xsl:apply-templates />
    </li>
  </xsl:template>

  <xsl:template match="note">
    <p>
      <b><i>Note:</i></b>
      <xsl:apply-templates />
    </p>
  </xsl:template>

  <xsl:template match="link">
    <a href="{@href}"><xsl:apply-templates /></a>
  </xsl:template>

  <xsl:template match="directive">
    <tt><xsl:apply-templates /></tt>
  </xsl:template>

  <xsl:template match="emph">
    <em><b><xsl:apply-templates /></b></em>
  </xsl:template>

  <xsl:template match="config">
    <pre>
    <xsl:apply-templates /></pre>
  </xsl:template>

  <xsl:template match="code">
    <tt><i><xsl:apply-templates /></i></tt>
  </xsl:template>

  <xsl:template match="vartext">
    <var><xsl:apply-templates /></var>
  </xsl:template>

</xsl:stylesheet>
