/* tracker-bus.c generated by valac 0.41.90.2-8c9f4-dirty, the Vala compiler
 * generated from tracker-bus.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */


#include <glib.h>
#include <glib-object.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-common/tracker-common.h"
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>
#include <unistd.h>
#include <gio/gunixfdlist.h>


#define TRACKER_BUS_TYPE_CONNECTION (tracker_bus_connection_get_type ())
#define TRACKER_BUS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnection))
#define TRACKER_BUS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnectionClass))
#define TRACKER_BUS_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_CONNECTION))
#define TRACKER_BUS_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_BUS_TYPE_CONNECTION))
#define TRACKER_BUS_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnectionClass))

typedef struct _TrackerBusConnection TrackerBusConnection;
typedef struct _TrackerBusConnectionClass TrackerBusConnectionClass;
typedef struct _TrackerBusConnectionPrivate TrackerBusConnectionPrivate;
enum  {
	TRACKER_BUS_CONNECTION_0_PROPERTY,
	TRACKER_BUS_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* tracker_bus_connection_properties[TRACKER_BUS_CONNECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _Block2Data Block2Data;

#define TRACKER_BUS_TYPE_FD_CURSOR (tracker_bus_fd_cursor_get_type ())
#define TRACKER_BUS_FD_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursor))
#define TRACKER_BUS_FD_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursorClass))
#define TRACKER_BUS_IS_FD_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_FD_CURSOR))
#define TRACKER_BUS_IS_FD_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_BUS_TYPE_FD_CURSOR))
#define TRACKER_BUS_FD_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursorClass))

typedef struct _TrackerBusFDCursor TrackerBusFDCursor;
typedef struct _TrackerBusFDCursorClass TrackerBusFDCursorClass;
typedef struct _TrackerBusConnectionQueryAsyncData TrackerBusConnectionQueryAsyncData;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _TrackerBusConnectionUpdateAsyncData TrackerBusConnectionUpdateAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _TrackerBusConnectionUpdateArrayAsyncData TrackerBusConnectionUpdateArrayAsyncData;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _TrackerBusConnectionUpdateBlankAsyncData TrackerBusConnectionUpdateBlankAsyncData;
typedef struct _TrackerBusConnectionLoadAsyncData TrackerBusConnectionLoadAsyncData;

#define TRACKER_BUS_TYPE_ARRAY_CURSOR (tracker_bus_array_cursor_get_type ())
#define TRACKER_BUS_ARRAY_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursor))
#define TRACKER_BUS_ARRAY_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursorClass))
#define TRACKER_BUS_IS_ARRAY_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR))
#define TRACKER_BUS_IS_ARRAY_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_BUS_TYPE_ARRAY_CURSOR))
#define TRACKER_BUS_ARRAY_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursorClass))

typedef struct _TrackerBusArrayCursor TrackerBusArrayCursor;
typedef struct _TrackerBusArrayCursorClass TrackerBusArrayCursorClass;
typedef struct _TrackerBusConnectionStatisticsAsyncData TrackerBusConnectionStatisticsAsyncData;

struct _TrackerBusConnection {
	TrackerSparqlConnection parent_instance;
	TrackerBusConnectionPrivate * priv;
};

struct _TrackerBusConnectionClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerBusConnectionPrivate {
	GDBusConnection* bus;
	gchar* dbus_name;
};

struct _Block1Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GMainLoop* loop;
	GAsyncResult* async_res;
};

struct _Block2Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GAsyncResult* dbus_res;
	gboolean received_result;
	gpointer _async_data_;
};

struct _TrackerBusConnectionQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	Block2Data* _data2_;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	GUnixOutputStream* _tmp2_;
	GMemoryOutputStream* mem_stream;
	GMemoryOutputStream* _tmp3_;
	GMemoryOutputStream* _tmp4_;
	GUnixInputStream* _tmp5_;
	GAsyncResult* _tmp6_;
	GDBusMessage* reply;
	GDBusConnection* _tmp7_;
	GAsyncResult* _tmp8_;
	GDBusMessage* _tmp9_;
	GDBusMessage* _tmp10_;
	gchar** variable_names;
	GDBusMessage* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gint variable_names_length1;
	gint _variable_names_size_;
	GMemoryOutputStream* _tmp20_;
	GMemoryOutputStream* _tmp21_;
	guint8* _tmp22_;
	GMemoryOutputStream* _tmp23_;
	gulong _tmp24_;
	gulong _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	TrackerBusFDCursor* _tmp27_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GMainLoop* loop;
	GAsyncResult* async_res;
};

struct _Block4Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GAsyncResult* dbus_res;
	gboolean sent_update;
	gpointer _async_data_;
};

struct _TrackerBusConnectionUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	Block4Data* _data4_;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	const gchar* _tmp2_;
	GUnixInputStream* _tmp3_;
	GDataOutputStream* data_stream;
	GUnixOutputStream* _tmp4_;
	GDataOutputStream* _tmp5_;
	GDataOutputStream* _tmp6_;
	GDataOutputStream* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GDataOutputStream* _tmp10_;
	GAsyncResult* _tmp11_;
	GDBusMessage* reply;
	GDBusConnection* _tmp12_;
	GAsyncResult* _tmp13_;
	GDBusMessage* _tmp14_;
	GDBusMessage* _tmp15_;
	GError * _inner_error_;
};

struct _Block5Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GAsyncResult* dbus_res;
	gboolean sent_update;
	gpointer _async_data_;
};

struct _TrackerBusConnectionUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
	Block5Data* _data5_;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	GUnixInputStream* _tmp2_;
	GDataOutputStream* data_stream;
	GUnixOutputStream* _tmp3_;
	GDataOutputStream* _tmp4_;
	GDataOutputStream* _tmp5_;
	GDataOutputStream* _tmp6_;
	gint i;
	gboolean _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GDataOutputStream* _tmp10_;
	gint _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GDataOutputStream* _tmp15_;
	gint _tmp16_;
	const gchar* _tmp17_;
	GAsyncResult* _tmp18_;
	GDBusMessage* reply;
	GDBusConnection* _tmp19_;
	GAsyncResult* _tmp20_;
	GDBusMessage* _tmp21_;
	GDBusMessage* _tmp22_;
	GPtrArray* _result_;
	GPtrArray* _tmp23_;
	GVariant* resultv;
	GDBusMessage* _tmp24_;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	GVariantIter* iter;
	GVariant* _tmp27_;
	GVariantIter* _tmp28_;
	gchar* code;
	gchar* message;
	GVariantIter* _tmp29_;
	GVariantIter* _tmp30_;
	gboolean _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GPtrArray* _tmp34_;
	const gchar* _tmp35_;
	GError* _tmp36_;
	GPtrArray* _tmp37_;
	GError * _inner_error_;
};

struct _Block6Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GMainLoop* loop;
	GAsyncResult* async_res;
};

struct _Block7Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GAsyncResult* dbus_res;
	gboolean sent_update;
	gpointer _async_data_;
};

struct _TrackerBusConnectionUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	Block7Data* _data7_;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	GUnixInputStream* _tmp2_;
	GDataOutputStream* data_stream;
	GUnixOutputStream* _tmp3_;
	GDataOutputStream* _tmp4_;
	GDataOutputStream* _tmp5_;
	GDataOutputStream* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GDataOutputStream* _tmp9_;
	GAsyncResult* _tmp10_;
	GDBusMessage* reply;
	GDBusConnection* _tmp11_;
	GAsyncResult* _tmp12_;
	GDBusMessage* _tmp13_;
	GDBusMessage* _tmp14_;
	GDBusMessage* _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	GError * _inner_error_;
};

struct _TrackerBusConnectionLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	GFile* file;
	GCancellable* cancellable;
	GDBusMessage* message;
	const gchar* _tmp0_;
	GDBusMessage* _tmp1_;
	GDBusMessage* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GDBusMessage* reply;
	GDBusConnection* _tmp7_;
	GDBusMessage* _tmp8_;
	GDBusMessage* _tmp9_;
	GDBusMessage* _tmp10_;
	GError * _inner_error_;
};

struct _TrackerBusConnectionStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	GDBusMessage* message;
	const gchar* _tmp0_;
	GDBusMessage* _tmp1_;
	GDBusMessage* reply;
	GDBusConnection* _tmp2_;
	GDBusMessage* _tmp3_;
	GDBusMessage* _tmp4_;
	GDBusMessage* _tmp5_;
	gchar** results;
	GDBusMessage* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gint _tmp16__length2;
	gint results_length1;
	gint results_length2;
	TrackerSparqlValueType* types;
	TrackerSparqlValueType* _tmp17_;
	gint types_length1;
	gint _types_size_;
	gchar** var_names;
	gchar** _tmp18_;
	gint var_names_length1;
	gint _var_names_size_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar* _tmp24_;
	TrackerSparqlValueType* _tmp25_;
	gint _tmp25__length1;
	TrackerSparqlValueType _tmp26_;
	TrackerSparqlValueType* _tmp27_;
	gint _tmp27__length1;
	TrackerSparqlValueType _tmp28_;
	gint rows;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gint _tmp29__length2;
	gint _tmp30_;
	gint cols;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gint _tmp31__length2;
	gint _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gint _tmp33__length2;
	gint _tmp34_;
	gint _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	TrackerSparqlValueType* _tmp37_;
	gint _tmp37__length1;
	TrackerBusArrayCursor* _tmp38_;
	GError * _inner_error_;
};


static gint TrackerBusConnection_private_offset;
static gpointer tracker_bus_connection_parent_class = NULL;

GType tracker_bus_connection_get_type (void) G_GNUC_CONST;
TrackerBusConnection* tracker_bus_connection_new (const gchar* dbus_name,
                                                  GError** error);
TrackerBusConnection* tracker_bus_connection_construct (GType object_type,
                                                        const gchar* dbus_name,
                                                        GError** error);
static void tracker_bus_connection_pipe (TrackerBusConnection* self,
                                  GUnixInputStream* * input,
                                  GUnixOutputStream* * output,
                                  GError** error);
static void tracker_bus_connection_handle_error_reply (TrackerBusConnection* self,
                                                GDBusMessage* message,
                                                GError** error);
static void tracker_bus_connection_send_query (TrackerBusConnection* self,
                                        const gchar* sparql,
                                        GUnixOutputStream* output,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback callback,
                                        gpointer callback_target,
                                        GError** error);
static TrackerSparqlCursor* tracker_bus_connection_real_query (TrackerSparqlConnection* base,
                                                        const gchar* sparql,
                                                        GCancellable* cancellable,
                                                        GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_connection_real_query_async_data_free (gpointer _data);
static void tracker_bus_connection_real_query_async (TrackerSparqlConnection* base,
                                              const gchar* sparql,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean tracker_bus_connection_real_query_async_co (TrackerBusConnectionQueryAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda4_ (Block2Data* _data2_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void* _g_realloc_grealloc_func (void* data,
                                gsize size);
static void _g_free_gdestroy_notify (void* data);
static void tracker_bus_connection_query_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static gchar** _variant_get1 (GVariant* value,
                       int* result_length1);
TrackerBusFDCursor* tracker_bus_fd_cursor_new (gchar* buffer,
                                               gulong buffer_size,
                                               gchar** variable_names,
                                               int variable_names_length1);
TrackerBusFDCursor* tracker_bus_fd_cursor_construct (GType object_type,
                                                     gchar* buffer,
                                                     gulong buffer_size,
                                                     gchar** variable_names,
                                                     int variable_names_length1);
GType tracker_bus_fd_cursor_get_type (void) G_GNUC_CONST;
static void tracker_bus_connection_send_update (TrackerBusConnection* self,
                                         const gchar* method,
                                         GUnixInputStream* input,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback callback,
                                         gpointer callback_target,
                                         GError** error);
static void tracker_bus_connection_real_update (TrackerSparqlConnection* base,
                                         const gchar* sparql,
                                         gint priority,
                                         GCancellable* cancellable,
                                         GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda7_ (Block3Data* _data3_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda7__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_connection_real_update_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_async (TrackerSparqlConnection* base,
                                               const gchar* sparql,
                                               gint priority,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_async_co (TrackerBusConnectionUpdateAsyncData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda6_ (Block4Data* _data4_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_connection_real_update_array_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_array_async (TrackerSparqlConnection* base,
                                                     gchar** sparql,
                                                     int sparql_length1,
                                                     gint priority,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_array_async_co (TrackerBusConnectionUpdateArrayAsyncData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda8_ (Block5Data* _data5_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void _g_error_free0_ (gpointer var);
static GVariant* tracker_bus_connection_real_update_blank (TrackerSparqlConnection* base,
                                                    const gchar* sparql,
                                                    gint priority,
                                                    GCancellable* cancellable,
                                                    GError** error);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda10_ (Block6Data* _data6_,
                  GObject* o,
                  GAsyncResult* res);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void tracker_bus_connection_real_update_blank_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_blank_async (TrackerSparqlConnection* base,
                                                     const gchar* sparql,
                                                     gint priority,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_blank_async_co (TrackerBusConnectionUpdateBlankAsyncData* _data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda9_ (Block7Data* _data7_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda9__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_connection_real_load (TrackerSparqlConnection* base,
                                       GFile* file,
                                       GCancellable* cancellable,
                                       GError** error);
static void tracker_bus_connection_real_load_async_data_free (gpointer _data);
static void tracker_bus_connection_real_load_async (TrackerSparqlConnection* base,
                                             GFile* file,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean tracker_bus_connection_real_load_async_co (TrackerBusConnectionLoadAsyncData* _data_);
static void tracker_bus_connection_load_async_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static TrackerSparqlCursor* tracker_bus_connection_real_statistics (TrackerSparqlConnection* base,
                                                             GCancellable* cancellable,
                                                             GError** error);
static gchar** _variant_get2 (GVariant* value,
                       int* result_length1,
                       int* result_length2);
TrackerBusArrayCursor* tracker_bus_array_cursor_new (gchar** results,
                                                     int results_length1,
                                                     int results_length2,
                                                     gint rows,
                                                     gint cols,
                                                     gchar** var_names,
                                                     int var_names_length1,
                                                     TrackerSparqlValueType* types,
                                                     int types_length1);
TrackerBusArrayCursor* tracker_bus_array_cursor_construct (GType object_type,
                                                           gchar** results,
                                                           int results_length1,
                                                           int results_length2,
                                                           gint rows,
                                                           gint cols,
                                                           gchar** var_names,
                                                           int var_names_length1,
                                                           TrackerSparqlValueType* types,
                                                           int types_length1);
GType tracker_bus_array_cursor_get_type (void) G_GNUC_CONST;
static void tracker_bus_connection_real_statistics_async_data_free (gpointer _data);
static void tracker_bus_connection_real_statistics_async (TrackerSparqlConnection* base,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean tracker_bus_connection_real_statistics_async_co (TrackerBusConnectionStatisticsAsyncData* _data_);
static void tracker_bus_connection_statistics_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static gchar** _variant_get3 (GVariant* value,
                       int* result_length1,
                       int* result_length2);
static void tracker_bus_connection_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static inline gpointer
tracker_bus_connection_get_instance_private (TrackerBusConnection* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerBusConnection_private_offset);
}


TrackerBusConnection*
tracker_bus_connection_construct (GType object_type,
                                  const gchar* dbus_name,
                                  GError** error)
{
	TrackerBusConnection * self = NULL;
	gchar* _tmp0_;
	GDBusConnection* _tmp1_ = NULL;
	GDBusConnection* _tmp2_;
	GDBusConnection* _tmp3_;
	GDBusMessage* msg = NULL;
	GDBusMessage* _tmp4_;
	GDBusMessage* _tmp5_ = NULL;
	GDBusConnection* _tmp6_;
	GDBusMessage* _tmp7_;
	GDBusMessage* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError * _inner_error_ = NULL;
#line 24 "tracker-bus.vala"
	g_return_val_if_fail (dbus_name != NULL, NULL);
#line 24 "tracker-bus.vala"
	self = (TrackerBusConnection*) tracker_sparql_connection_construct (object_type);
#line 25 "tracker-bus.vala"
	_tmp0_ = g_strdup (dbus_name);
#line 25 "tracker-bus.vala"
	_g_free0 (self->priv->dbus_name);
#line 25 "tracker-bus.vala"
	self->priv->dbus_name = _tmp0_;
#line 26 "tracker-bus.vala"
	_tmp2_ = g_bus_get_sync (tracker_ipc_bus (), NULL, &_inner_error_);
#line 26 "tracker-bus.vala"
	_tmp1_ = _tmp2_;
#line 26 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 26 "tracker-bus.vala"
		g_propagate_error (error, _inner_error_);
#line 26 "tracker-bus.vala"
		_g_object_unref0 (self);
#line 26 "tracker-bus.vala"
		return NULL;
#line 701 "tracker-bus.c"
	}
#line 26 "tracker-bus.vala"
	_tmp3_ = _tmp1_;
#line 26 "tracker-bus.vala"
	_tmp1_ = NULL;
#line 26 "tracker-bus.vala"
	_g_object_unref0 (self->priv->bus);
#line 26 "tracker-bus.vala"
	self->priv->bus = _tmp3_;
#line 28 "tracker-bus.vala"
	g_debug ("Waiting for service to become available...");
#line 32 "tracker-bus.vala"
	_tmp4_ = g_dbus_message_new_method_call (dbus_name, TRACKER_DBUS_OBJECT_STATUS, TRACKER_DBUS_INTERFACE_STATUS, "Wait");
#line 32 "tracker-bus.vala"
	msg = _tmp4_;
#line 33 "tracker-bus.vala"
	_tmp6_ = self->priv->bus;
#line 33 "tracker-bus.vala"
	_tmp7_ = msg;
#line 33 "tracker-bus.vala"
	_tmp8_ = g_dbus_connection_send_message_with_reply_sync (_tmp6_, _tmp7_, 0, G_MAXINT, NULL, NULL, &_inner_error_);
#line 33 "tracker-bus.vala"
	_tmp5_ = _tmp8_;
#line 33 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 33 "tracker-bus.vala"
		g_propagate_error (error, _inner_error_);
#line 33 "tracker-bus.vala"
		_g_object_unref0 (msg);
#line 33 "tracker-bus.vala"
		_g_object_unref0 (_tmp1_);
#line 33 "tracker-bus.vala"
		_g_object_unref0 (self);
#line 33 "tracker-bus.vala"
		return NULL;
#line 737 "tracker-bus.c"
	}
#line 33 "tracker-bus.vala"
	g_dbus_message_to_gerror (_tmp5_, &_inner_error_);
#line 33 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 33 "tracker-bus.vala"
		g_propagate_error (error, _inner_error_);
#line 33 "tracker-bus.vala"
		_g_object_unref0 (_tmp5_);
#line 33 "tracker-bus.vala"
		_g_object_unref0 (msg);
#line 33 "tracker-bus.vala"
		_g_object_unref0 (_tmp1_);
#line 33 "tracker-bus.vala"
		_g_object_unref0 (self);
#line 33 "tracker-bus.vala"
		return NULL;
#line 755 "tracker-bus.c"
	}
#line 35 "tracker-bus.vala"
	g_debug ("Service is ready");
#line 38 "tracker-bus.vala"
	_tmp9_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, "");
#line 38 "tracker-bus.vala"
	_tmp10_ = _tmp9_;
#line 38 "tracker-bus.vala"
	_g_error_free0 (_tmp10_);
#line 24 "tracker-bus.vala"
	_g_object_unref0 (_tmp5_);
#line 24 "tracker-bus.vala"
	_g_object_unref0 (msg);
#line 24 "tracker-bus.vala"
	_g_object_unref0 (_tmp1_);
#line 24 "tracker-bus.vala"
	return self;
#line 773 "tracker-bus.c"
}


TrackerBusConnection*
tracker_bus_connection_new (const gchar* dbus_name,
                            GError** error)
{
#line 24 "tracker-bus.vala"
	return tracker_bus_connection_construct (TRACKER_BUS_TYPE_CONNECTION, dbus_name, error);
#line 783 "tracker-bus.c"
}


static void
tracker_bus_connection_pipe (TrackerBusConnection* self,
                             GUnixInputStream* * input,
                             GUnixOutputStream* * output,
                             GError** error)
{
	GUnixInputStream* _vala_input = NULL;
	GUnixOutputStream* _vala_output = NULL;
	gint pipefd[2] = {0};
	gint _tmp1_;
	GUnixInputStream* _tmp2_;
	gint _tmp3_;
	GUnixOutputStream* _tmp4_;
	GError * _inner_error_ = NULL;
#line 41 "tracker-bus.vala"
	g_return_if_fail (self != NULL);
#line 43 "tracker-bus.vala"
	if (pipe (pipefd) < 0) {
#line 805 "tracker-bus.c"
		GError* _tmp0_;
#line 44 "tracker-bus.vala"
		_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Pipe creation failed");
#line 44 "tracker-bus.vala"
		_inner_error_ = _tmp0_;
#line 44 "tracker-bus.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 44 "tracker-bus.vala"
			g_propagate_error (error, _inner_error_);
#line 44 "tracker-bus.vala"
			return;
#line 817 "tracker-bus.c"
		} else {
#line 44 "tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 44 "tracker-bus.vala"
			g_clear_error (&_inner_error_);
#line 44 "tracker-bus.vala"
			return;
#line 825 "tracker-bus.c"
		}
	}
#line 46 "tracker-bus.vala"
	_tmp1_ = pipefd[0];
#line 46 "tracker-bus.vala"
	_tmp2_ = (GUnixInputStream*) g_unix_input_stream_new (_tmp1_, TRUE);
#line 46 "tracker-bus.vala"
	_g_object_unref0 (_vala_input);
#line 46 "tracker-bus.vala"
	_vala_input = _tmp2_;
#line 47 "tracker-bus.vala"
	_tmp3_ = pipefd[1];
#line 47 "tracker-bus.vala"
	_tmp4_ = (GUnixOutputStream*) g_unix_output_stream_new (_tmp3_, TRUE);
#line 47 "tracker-bus.vala"
	_g_object_unref0 (_vala_output);
#line 47 "tracker-bus.vala"
	_vala_output = _tmp4_;
#line 41 "tracker-bus.vala"
	if (input) {
#line 41 "tracker-bus.vala"
		*input = _vala_input;
#line 848 "tracker-bus.c"
	} else {
#line 41 "tracker-bus.vala"
		_g_object_unref0 (_vala_input);
#line 852 "tracker-bus.c"
	}
#line 41 "tracker-bus.vala"
	if (output) {
#line 41 "tracker-bus.vala"
		*output = _vala_output;
#line 858 "tracker-bus.c"
	} else {
#line 41 "tracker-bus.vala"
		_g_object_unref0 (_vala_output);
#line 862 "tracker-bus.c"
	}
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 54 "tracker-bus.vala"
	return self ? g_error_copy (self) : NULL;
#line 872 "tracker-bus.c"
}


static void
tracker_bus_connection_handle_error_reply (TrackerBusConnection* self,
                                           GDBusMessage* message,
                                           GError** error)
{
	GError * _inner_error_ = NULL;
#line 50 "tracker-bus.vala"
	g_return_if_fail (self != NULL);
#line 50 "tracker-bus.vala"
	g_return_if_fail (message != NULL);
#line 886 "tracker-bus.c"
	{
#line 52 "tracker-bus.vala"
		g_dbus_message_to_gerror (message, &_inner_error_);
#line 52 "tracker-bus.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 52 "tracker-bus.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 894 "tracker-bus.c"
				goto __catch0_g_io_error;
			}
#line 52 "tracker-bus.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 899 "tracker-bus.c"
				goto __catch0_tracker_sparql_error;
			}
#line 52 "tracker-bus.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 904 "tracker-bus.c"
				goto __catch0_g_dbus_error;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e_io = NULL;
		GError* _tmp0_;
		GError* _tmp1_;
#line 51 "tracker-bus.vala"
		e_io = _inner_error_;
#line 51 "tracker-bus.vala"
		_inner_error_ = NULL;
#line 54 "tracker-bus.vala"
		_tmp0_ = e_io;
#line 54 "tracker-bus.vala"
		_tmp1_ = _g_error_copy0 (_tmp0_);
#line 54 "tracker-bus.vala"
		_inner_error_ = _tmp1_;
#line 54 "tracker-bus.vala"
		_g_error_free0 (e_io);
#line 928 "tracker-bus.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_tracker_sparql_error:
	{
		GError* e_sparql = NULL;
		GError* _tmp2_;
		GError* _tmp3_;
#line 51 "tracker-bus.vala"
		e_sparql = _inner_error_;
#line 51 "tracker-bus.vala"
		_inner_error_ = NULL;
#line 56 "tracker-bus.vala"
		_tmp2_ = e_sparql;
#line 56 "tracker-bus.vala"
		_tmp3_ = _g_error_copy0 (_tmp2_);
#line 56 "tracker-bus.vala"
		_inner_error_ = _tmp3_;
#line 56 "tracker-bus.vala"
		_g_error_free0 (e_sparql);
#line 949 "tracker-bus.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e_dbus = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
#line 51 "tracker-bus.vala"
		e_dbus = _inner_error_;
#line 51 "tracker-bus.vala"
		_inner_error_ = NULL;
#line 58 "tracker-bus.vala"
		_tmp4_ = e_dbus;
#line 58 "tracker-bus.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 58 "tracker-bus.vala"
		_inner_error_ = _tmp5_;
#line 58 "tracker-bus.vala"
		_g_error_free0 (e_dbus);
#line 970 "tracker-bus.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
#line 51 "tracker-bus.vala"
		e = _inner_error_;
#line 51 "tracker-bus.vala"
		_inner_error_ = NULL;
#line 60 "tracker-bus.vala"
		_tmp6_ = e;
#line 60 "tracker-bus.vala"
		_tmp7_ = _tmp6_->message;
#line 60 "tracker-bus.vala"
		_tmp8_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp7_);
#line 60 "tracker-bus.vala"
		_inner_error_ = _tmp8_;
#line 60 "tracker-bus.vala"
		_g_error_free0 (e);
#line 994 "tracker-bus.c"
		goto __finally0;
	}
	__finally0:
#line 51 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 51 "tracker-bus.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 51 "tracker-bus.vala"
			g_propagate_error (error, _inner_error_);
#line 51 "tracker-bus.vala"
			return;
#line 1006 "tracker-bus.c"
		} else {
#line 51 "tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 51 "tracker-bus.vala"
			g_clear_error (&_inner_error_);
#line 51 "tracker-bus.vala"
			return;
#line 1014 "tracker-bus.c"
		}
	}
}


static void
tracker_bus_connection_send_query (TrackerBusConnection* self,
                                   const gchar* sparql,
                                   GUnixOutputStream* output,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback callback,
                                   gpointer callback_target,
                                   GError** error)
{
	GDBusMessage* message = NULL;
	const gchar* _tmp0_;
	GDBusMessage* _tmp1_;
	GUnixFDList* fd_list = NULL;
	GUnixFDList* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GDBusConnection* _tmp8_;
	GError * _inner_error_ = NULL;
#line 64 "tracker-bus.vala"
	g_return_if_fail (self != NULL);
#line 64 "tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 64 "tracker-bus.vala"
	g_return_if_fail (output != NULL);
#line 65 "tracker-bus.vala"
	_tmp0_ = self->priv->dbus_name;
#line 65 "tracker-bus.vala"
	_tmp1_ = g_dbus_message_new_method_call (_tmp0_, TRACKER_DBUS_OBJECT_STEROIDS, TRACKER_DBUS_INTERFACE_STEROIDS, "Query");
#line 65 "tracker-bus.vala"
	message = _tmp1_;
#line 66 "tracker-bus.vala"
	_tmp2_ = g_unix_fd_list_new ();
#line 66 "tracker-bus.vala"
	fd_list = _tmp2_;
#line 67 "tracker-bus.vala"
	_tmp4_ = g_unix_output_stream_get_fd (output);
#line 67 "tracker-bus.vala"
	_tmp5_ = _tmp4_;
#line 67 "tracker-bus.vala"
	_tmp3_ = g_unix_fd_list_append (fd_list, _tmp5_, &_inner_error_);
#line 67 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 67 "tracker-bus.vala"
		g_propagate_error (error, _inner_error_);
#line 67 "tracker-bus.vala"
		_g_object_unref0 (fd_list);
#line 67 "tracker-bus.vala"
		_g_object_unref0 (message);
#line 67 "tracker-bus.vala"
		return;
#line 1073 "tracker-bus.c"
	}
#line 67 "tracker-bus.vala"
	_tmp6_ = g_variant_new ("(sh)", sparql, _tmp3_, NULL);
#line 67 "tracker-bus.vala"
	g_variant_ref_sink (_tmp6_);
#line 67 "tracker-bus.vala"
	_tmp7_ = _tmp6_;
#line 67 "tracker-bus.vala"
	g_dbus_message_set_body (message, _tmp7_);
#line 67 "tracker-bus.vala"
	_g_variant_unref0 (_tmp7_);
#line 68 "tracker-bus.vala"
	g_dbus_message_set_unix_fd_list (message, fd_list);
#line 70 "tracker-bus.vala"
	_tmp8_ = self->priv->bus;
#line 70 "tracker-bus.vala"
	g_dbus_connection_send_message_with_reply (_tmp8_, message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, cancellable, callback, callback_target);
#line 64 "tracker-bus.vala"
	_g_object_unref0 (fd_list);
#line 64 "tracker-bus.vala"
	_g_object_unref0 (message);
#line 1095 "tracker-bus.c"
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 73 "tracker-bus.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 73 "tracker-bus.vala"
	return _data1_;
#line 1106 "tracker-bus.c"
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 73 "tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1117 "tracker-bus.c"
		TrackerBusConnection* self;
#line 73 "tracker-bus.vala"
		self = _data1_->self;
#line 73 "tracker-bus.vala"
		_g_object_unref0 (_data1_->async_res);
#line 73 "tracker-bus.vala"
		_g_main_loop_unref0 (_data1_->loop);
#line 73 "tracker-bus.vala"
		_g_object_unref0 (self);
#line 73 "tracker-bus.vala"
		g_slice_free (Block1Data, _data1_);
#line 1129 "tracker-bus.c"
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 80 "tracker-bus.vala"
	return self ? g_object_ref (self) : NULL;
#line 1139 "tracker-bus.c"
}


static void
__lambda5_ (Block1Data* _data1_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 79 "tracker-bus.vala"
	self = _data1_->self;
#line 79 "tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 80 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 80 "tracker-bus.vala"
	_g_object_unref0 (_data1_->async_res);
#line 80 "tracker-bus.vala"
	_data1_->async_res = _tmp0_;
#line 81 "tracker-bus.vala"
	g_main_loop_quit (_data1_->loop);
#line 1162 "tracker-bus.c"
}


static void
___lambda5__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 79 "tracker-bus.vala"
	__lambda5_ (self, source_object, res);
#line 79 "tracker-bus.vala"
	block1_data_unref (self);
#line 1175 "tracker-bus.c"
}


static TrackerSparqlCursor*
tracker_bus_connection_real_query (TrackerSparqlConnection* base,
                                   const gchar* sparql,
                                   GCancellable* cancellable,
                                   GError** error)
{
	TrackerBusConnection * self;
	TrackerSparqlCursor* result = NULL;
	Block1Data* _data1_;
	GMainContext* context = NULL;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	TrackerSparqlCursor* _tmp2_ = NULL;
	TrackerSparqlCursor* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	GError * _inner_error_ = NULL;
#line 73 "tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 73 "tracker-bus.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 73 "tracker-bus.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 73 "tracker-bus.vala"
	_data1_->_ref_count_ = 1;
#line 73 "tracker-bus.vala"
	_data1_->self = g_object_ref (self);
#line 75 "tracker-bus.vala"
	_tmp0_ = g_main_context_new ();
#line 75 "tracker-bus.vala"
	context = _tmp0_;
#line 76 "tracker-bus.vala"
	_tmp1_ = g_main_loop_new (context, FALSE);
#line 76 "tracker-bus.vala"
	_data1_->loop = _tmp1_;
#line 77 "tracker-bus.vala"
	g_main_context_push_thread_default (context);
#line 78 "tracker-bus.vala"
	_data1_->async_res = NULL;
#line 79 "tracker-bus.vala"
	tracker_sparql_connection_query_async ((TrackerSparqlConnection*) self, sparql, cancellable, ___lambda5__gasync_ready_callback, block1_data_ref (_data1_));
#line 83 "tracker-bus.vala"
	g_main_loop_run (_data1_->loop);
#line 84 "tracker-bus.vala"
	g_main_context_pop_thread_default (context);
#line 85 "tracker-bus.vala"
	_tmp3_ = tracker_sparql_connection_query_finish ((TrackerSparqlConnection*) self, _data1_->async_res, &_inner_error_);
#line 85 "tracker-bus.vala"
	_tmp2_ = _tmp3_;
#line 85 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 85 "tracker-bus.vala"
		g_propagate_error (error, _inner_error_);
#line 85 "tracker-bus.vala"
		_g_main_context_unref0 (context);
#line 85 "tracker-bus.vala"
		block1_data_unref (_data1_);
#line 85 "tracker-bus.vala"
		_data1_ = NULL;
#line 85 "tracker-bus.vala"
		return NULL;
#line 1239 "tracker-bus.c"
	}
#line 85 "tracker-bus.vala"
	_tmp4_ = _tmp2_;
#line 85 "tracker-bus.vala"
	_tmp2_ = NULL;
#line 85 "tracker-bus.vala"
	result = _tmp4_;
#line 85 "tracker-bus.vala"
	_g_object_unref0 (_tmp2_);
#line 85 "tracker-bus.vala"
	_g_main_context_unref0 (context);
#line 85 "tracker-bus.vala"
	block1_data_unref (_data1_);
#line 85 "tracker-bus.vala"
	_data1_ = NULL;
#line 85 "tracker-bus.vala"
	return result;
#line 1257 "tracker-bus.c"
}


static void
tracker_bus_connection_real_query_async_data_free (gpointer _data)
{
	TrackerBusConnectionQueryAsyncData* _data_;
	_data_ = _data;
#line 20 "tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->result);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "tracker-bus.vala"
	g_slice_free (TrackerBusConnectionQueryAsyncData, _data_);
#line 1276 "tracker-bus.c"
}


static void
tracker_bus_connection_real_query_async (TrackerSparqlConnection* base,
                                         const gchar* sparql,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionQueryAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 20 "tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionQueryAsyncData);
#line 20 "tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_query_async_data_free);
#line 20 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "tracker-bus.vala"
	_tmp1_ = g_strdup (sparql);
#line 20 "tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "tracker-bus.vala"
	_data_->sparql = _tmp1_;
#line 20 "tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "tracker-bus.vala"
	_data_->cancellable = _tmp2_;
#line 20 "tracker-bus.vala"
	tracker_bus_connection_real_query_async_co (_data_);
#line 1318 "tracker-bus.c"
}


static TrackerSparqlCursor*
tracker_bus_connection_real_query_finish (TrackerSparqlConnection* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	TrackerSparqlCursor* result;
	TrackerBusConnectionQueryAsyncData* _data_;
#line 20 "tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "tracker-bus.vala"
		return NULL;
#line 1335 "tracker-bus.c"
	}
#line 20 "tracker-bus.vala"
	result = _data_->result;
#line 20 "tracker-bus.vala"
	_data_->result = NULL;
#line 20 "tracker-bus.vala"
	return result;
#line 1343 "tracker-bus.c"
}


static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 88 "tracker-bus.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 88 "tracker-bus.vala"
	return _data2_;
#line 1354 "tracker-bus.c"
}


static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 88 "tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1365 "tracker-bus.c"
		TrackerBusConnection* self;
#line 88 "tracker-bus.vala"
		self = _data2_->self;
#line 88 "tracker-bus.vala"
		_g_object_unref0 (_data2_->dbus_res);
#line 88 "tracker-bus.vala"
		_g_object_unref0 (self);
#line 88 "tracker-bus.vala"
		g_slice_free (Block2Data, _data2_);
#line 1375 "tracker-bus.c"
	}
}


static void
__lambda4_ (Block2Data* _data2_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
	gboolean _tmp1_;
#line 96 "tracker-bus.vala"
	self = _data2_->self;
#line 96 "tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 97 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 97 "tracker-bus.vala"
	_g_object_unref0 (_data2_->dbus_res);
#line 97 "tracker-bus.vala"
	_data2_->dbus_res = _tmp0_;
#line 98 "tracker-bus.vala"
	_tmp1_ = _data2_->received_result;
#line 98 "tracker-bus.vala"
	if (_tmp1_) {
#line 99 "tracker-bus.vala"
		tracker_bus_connection_real_query_async_co (_data2_->_async_data_);
#line 1404 "tracker-bus.c"
	}
}


static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 96 "tracker-bus.vala"
	__lambda4_ (self, source_object, res);
#line 1416 "tracker-bus.c"
}


static void*
_g_realloc_grealloc_func (void* data,
                          gsize size)
{
	void* result;
	result = g_realloc (data, size);
#line 106 "tracker-bus.vala"
	return result;
#line 1428 "tracker-bus.c"
}


static void
_g_free_gdestroy_notify (void* data)
{
#line 106 "tracker-bus.vala"
	g_free (data);
#line 1437 "tracker-bus.c"
}


static void
tracker_bus_connection_query_async_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	TrackerBusConnectionQueryAsyncData* _data_;
#line 109 "tracker-bus.vala"
	_data_ = _user_data_;
#line 109 "tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 109 "tracker-bus.vala"
	_data_->_res_ = _res_;
#line 109 "tracker-bus.vala"
	tracker_bus_connection_real_query_async_co (_data_);
#line 1455 "tracker-bus.c"
}


static gchar**
_variant_get1 (GVariant* value,
               int* result_length1)
{
	gchar** _tmp16_;
	int _tmp16__length;
	int _tmp16__size;
	int _tmp16__length1;
	GVariantIter _tmp17_;
	GVariant* _tmp18_;
	_tmp16_ = g_new (gchar*, 5);
	_tmp16__length = 0;
	_tmp16__size = 4;
	_tmp16__length1 = 0;
#line 121 "tracker-bus.vala"
	g_variant_iter_init (&_tmp17_, value);
#line 121 "tracker-bus.vala"
	for (; (_tmp18_ = g_variant_iter_next_value (&_tmp17_)) != NULL; _tmp16__length1++) {
#line 121 "tracker-bus.vala"
		if (_tmp16__size == _tmp16__length) {
#line 121 "tracker-bus.vala"
			_tmp16__size = 2 * _tmp16__size;
#line 121 "tracker-bus.vala"
			_tmp16_ = g_renew (gchar*, _tmp16_, _tmp16__size + 1);
#line 1483 "tracker-bus.c"
		}
#line 121 "tracker-bus.vala"
		_tmp16_[_tmp16__length++] = g_variant_dup_string (_tmp18_, NULL);
#line 121 "tracker-bus.vala"
		g_variant_unref (_tmp18_);
#line 1489 "tracker-bus.c"
	}
#line 121 "tracker-bus.vala"
	*result_length1 = _tmp16__length1;
#line 121 "tracker-bus.vala"
	_tmp16_[_tmp16__length] = NULL;
#line 121 "tracker-bus.vala"
	return _tmp16_;
#line 1497 "tracker-bus.c"
}


static gboolean
tracker_bus_connection_real_query_async_co (TrackerBusConnectionQueryAsyncData* _data_)
{
#line 88 "tracker-bus.vala"
	switch (_data_->_state_) {
#line 88 "tracker-bus.vala"
		case 0:
#line 1508 "tracker-bus.c"
		goto _state_0;
#line 88 "tracker-bus.vala"
		case 1:
#line 1512 "tracker-bus.c"
		goto _state_1;
#line 88 "tracker-bus.vala"
		case 2:
#line 1516 "tracker-bus.c"
		goto _state_2;
		default:
#line 88 "tracker-bus.vala"
		g_assert_not_reached ();
#line 1521 "tracker-bus.c"
	}
	_state_0:
#line 88 "tracker-bus.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 88 "tracker-bus.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 88 "tracker-bus.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 88 "tracker-bus.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 91 "tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 91 "tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 91 "tracker-bus.vala"
	tracker_bus_connection_pipe (_data_->self, &_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error_);
#line 91 "tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 91 "tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 91 "tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 91 "tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 91 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 91 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 91 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 91 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 91 "tracker-bus.vala"
		block2_data_unref (_data_->_data2_);
#line 91 "tracker-bus.vala"
		_data_->_data2_ = NULL;
#line 91 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 91 "tracker-bus.vala"
		return FALSE;
#line 1562 "tracker-bus.c"
	}
#line 94 "tracker-bus.vala"
	_data_->_data2_->dbus_res = NULL;
#line 95 "tracker-bus.vala"
	_data_->_data2_->received_result = FALSE;
#line 96 "tracker-bus.vala"
	_data_->_tmp2_ = _data_->output;
#line 96 "tracker-bus.vala"
	tracker_bus_connection_send_query (_data_->self, _data_->sparql, _data_->_tmp2_, _data_->cancellable, ___lambda4__gasync_ready_callback, _data_->_data2_, &_data_->_inner_error_);
#line 96 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 96 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 96 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 96 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 96 "tracker-bus.vala"
		block2_data_unref (_data_->_data2_);
#line 96 "tracker-bus.vala"
		_data_->_data2_ = NULL;
#line 96 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 96 "tracker-bus.vala"
		return FALSE;
#line 1588 "tracker-bus.c"
	}
#line 103 "tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 103 "tracker-bus.vala"
	_data_->output = NULL;
#line 106 "tracker-bus.vala"
	_data_->_tmp3_ = (GMemoryOutputStream*) g_memory_output_stream_new (NULL, 0, _g_realloc_grealloc_func, _g_free_gdestroy_notify);
#line 106 "tracker-bus.vala"
	_data_->mem_stream = _data_->_tmp3_;
#line 1598 "tracker-bus.c"
	{
#line 109 "tracker-bus.vala"
		_data_->_tmp4_ = _data_->mem_stream;
#line 109 "tracker-bus.vala"
		_data_->_tmp5_ = _data_->input;
#line 109 "tracker-bus.vala"
		_data_->_state_ = 1;
#line 109 "tracker-bus.vala"
		g_output_stream_splice_async ((GOutputStream*) _data_->_tmp4_, (GInputStream*) _data_->_tmp5_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, G_PRIORITY_DEFAULT, _data_->cancellable, tracker_bus_connection_query_async_ready, _data_);
#line 109 "tracker-bus.vala"
		return FALSE;
#line 1610 "tracker-bus.c"
		_state_1:
#line 109 "tracker-bus.vala"
		g_output_stream_splice_finish ((GOutputStream*) _data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 109 "tracker-bus.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1616 "tracker-bus.c"
			goto __finally1;
		}
	}
	__finally1:
	{
#line 112 "tracker-bus.vala"
		_data_->_data2_->received_result = TRUE;
#line 113 "tracker-bus.vala"
		_data_->_tmp6_ = _data_->_data2_->dbus_res;
#line 113 "tracker-bus.vala"
		if (_data_->_tmp6_ == NULL) {
#line 114 "tracker-bus.vala"
			_data_->_state_ = 2;
#line 114 "tracker-bus.vala"
			return FALSE;
#line 1632 "tracker-bus.c"
			_state_2:
			;
		}
	}
#line 108 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 108 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 108 "tracker-bus.vala"
		_g_object_unref0 (_data_->mem_stream);
#line 108 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 108 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 108 "tracker-bus.vala"
		block2_data_unref (_data_->_data2_);
#line 108 "tracker-bus.vala"
		_data_->_data2_ = NULL;
#line 108 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 108 "tracker-bus.vala"
		return FALSE;
#line 1655 "tracker-bus.c"
	}
#line 118 "tracker-bus.vala"
	_data_->_tmp7_ = _data_->self->priv->bus;
#line 118 "tracker-bus.vala"
	_data_->_tmp8_ = _data_->_data2_->dbus_res;
#line 118 "tracker-bus.vala"
	_data_->_tmp9_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp7_, _data_->_tmp8_, &_data_->_inner_error_);
#line 118 "tracker-bus.vala"
	_data_->reply = _data_->_tmp9_;
#line 118 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 118 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 118 "tracker-bus.vala"
		_g_object_unref0 (_data_->mem_stream);
#line 118 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 118 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 118 "tracker-bus.vala"
		block2_data_unref (_data_->_data2_);
#line 118 "tracker-bus.vala"
		_data_->_data2_ = NULL;
#line 118 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 118 "tracker-bus.vala"
		return FALSE;
#line 1683 "tracker-bus.c"
	}
#line 119 "tracker-bus.vala"
	_data_->_tmp10_ = _data_->reply;
#line 119 "tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->self, _data_->_tmp10_, &_data_->_inner_error_);
#line 119 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 119 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 119 "tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 119 "tracker-bus.vala"
		_g_object_unref0 (_data_->mem_stream);
#line 119 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 119 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 119 "tracker-bus.vala"
		block2_data_unref (_data_->_data2_);
#line 119 "tracker-bus.vala"
		_data_->_data2_ = NULL;
#line 119 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 119 "tracker-bus.vala"
		return FALSE;
#line 1709 "tracker-bus.c"
	}
#line 121 "tracker-bus.vala"
	_data_->_tmp11_ = _data_->reply;
#line 121 "tracker-bus.vala"
	_data_->_tmp12_ = g_dbus_message_get_body (_data_->_tmp11_);
#line 121 "tracker-bus.vala"
	_data_->_tmp13_ = g_variant_get_child_value (_data_->_tmp12_, (gsize) 0);
#line 121 "tracker-bus.vala"
	_data_->_tmp14_ = _data_->_tmp13_;
#line 121 "tracker-bus.vala"
	_data_->_tmp15_ = _variant_get1 (_data_->_tmp14_, &_data_->_tmp15__length1);
#line 121 "tracker-bus.vala"
	_data_->_tmp19_ = _data_->_tmp15_;
#line 121 "tracker-bus.vala"
	_data_->_tmp19__length1 = _data_->_tmp15__length1;
#line 121 "tracker-bus.vala"
	_g_variant_unref0 (_data_->_tmp14_);
#line 121 "tracker-bus.vala"
	_data_->variable_names = _data_->_tmp19_;
#line 121 "tracker-bus.vala"
	_data_->variable_names_length1 = _data_->_tmp19__length1;
#line 121 "tracker-bus.vala"
	_data_->_variable_names_size_ = _data_->variable_names_length1;
#line 122 "tracker-bus.vala"
	_data_->_tmp20_ = _data_->mem_stream;
#line 122 "tracker-bus.vala"
	g_output_stream_close ((GOutputStream*) _data_->_tmp20_, NULL, &_data_->_inner_error_);
#line 122 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 122 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 122 "tracker-bus.vala"
		_data_->variable_names = (_vala_array_free (_data_->variable_names, _data_->variable_names_length1, (GDestroyNotify) g_free), NULL);
#line 122 "tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 122 "tracker-bus.vala"
		_g_object_unref0 (_data_->mem_stream);
#line 122 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 122 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 122 "tracker-bus.vala"
		block2_data_unref (_data_->_data2_);
#line 122 "tracker-bus.vala"
		_data_->_data2_ = NULL;
#line 122 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 122 "tracker-bus.vala"
		return FALSE;
#line 1759 "tracker-bus.c"
	}
#line 123 "tracker-bus.vala"
	_data_->_tmp21_ = _data_->mem_stream;
#line 123 "tracker-bus.vala"
	_data_->_tmp22_ = g_memory_output_stream_steal_data (_data_->_tmp21_);
#line 123 "tracker-bus.vala"
	_data_->_tmp23_ = _data_->mem_stream;
#line 123 "tracker-bus.vala"
	_data_->_tmp24_ = g_memory_output_stream_get_data_size (_data_->_tmp23_);
#line 123 "tracker-bus.vala"
	_data_->_tmp25_ = _data_->_tmp24_;
#line 123 "tracker-bus.vala"
	_data_->_tmp26_ = _data_->variable_names;
#line 123 "tracker-bus.vala"
	_data_->_tmp26__length1 = _data_->variable_names_length1;
#line 123 "tracker-bus.vala"
	_data_->_tmp27_ = tracker_bus_fd_cursor_new (_data_->_tmp22_, _data_->_tmp25_, _data_->_tmp26_, _data_->_tmp26__length1);
#line 123 "tracker-bus.vala"
	_data_->result = (TrackerSparqlCursor*) _data_->_tmp27_;
#line 123 "tracker-bus.vala"
	_data_->variable_names = (_vala_array_free (_data_->variable_names, _data_->variable_names_length1, (GDestroyNotify) g_free), NULL);
#line 123 "tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 123 "tracker-bus.vala"
	_g_object_unref0 (_data_->mem_stream);
#line 123 "tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 123 "tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 123 "tracker-bus.vala"
	block2_data_unref (_data_->_data2_);
#line 123 "tracker-bus.vala"
	_data_->_data2_ = NULL;
#line 123 "tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 123 "tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 123 "tracker-bus.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 123 "tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1801 "tracker-bus.c"
		}
	}
#line 123 "tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 123 "tracker-bus.vala"
	return FALSE;
#line 1808 "tracker-bus.c"
}


static void
tracker_bus_connection_send_update (TrackerBusConnection* self,
                                    const gchar* method,
                                    GUnixInputStream* input,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback callback,
                                    gpointer callback_target,
                                    GError** error)
{
	GDBusMessage* message = NULL;
	const gchar* _tmp0_;
	GDBusMessage* _tmp1_;
	GUnixFDList* fd_list = NULL;
	GUnixFDList* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GDBusConnection* _tmp8_;
	GError * _inner_error_ = NULL;
#line 126 "tracker-bus.vala"
	g_return_if_fail (self != NULL);
#line 126 "tracker-bus.vala"
	g_return_if_fail (method != NULL);
#line 126 "tracker-bus.vala"
	g_return_if_fail (input != NULL);
#line 127 "tracker-bus.vala"
	_tmp0_ = self->priv->dbus_name;
#line 127 "tracker-bus.vala"
	_tmp1_ = g_dbus_message_new_method_call (_tmp0_, TRACKER_DBUS_OBJECT_STEROIDS, TRACKER_DBUS_INTERFACE_STEROIDS, method);
#line 127 "tracker-bus.vala"
	message = _tmp1_;
#line 128 "tracker-bus.vala"
	_tmp2_ = g_unix_fd_list_new ();
#line 128 "tracker-bus.vala"
	fd_list = _tmp2_;
#line 129 "tracker-bus.vala"
	_tmp4_ = g_unix_input_stream_get_fd (input);
#line 129 "tracker-bus.vala"
	_tmp5_ = _tmp4_;
#line 129 "tracker-bus.vala"
	_tmp3_ = g_unix_fd_list_append (fd_list, _tmp5_, &_inner_error_);
#line 129 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 129 "tracker-bus.vala"
		g_propagate_error (error, _inner_error_);
#line 129 "tracker-bus.vala"
		_g_object_unref0 (fd_list);
#line 129 "tracker-bus.vala"
		_g_object_unref0 (message);
#line 129 "tracker-bus.vala"
		return;
#line 1865 "tracker-bus.c"
	}
#line 129 "tracker-bus.vala"
	_tmp6_ = g_variant_new ("(h)", _tmp3_, NULL);
#line 129 "tracker-bus.vala"
	g_variant_ref_sink (_tmp6_);
#line 129 "tracker-bus.vala"
	_tmp7_ = _tmp6_;
#line 129 "tracker-bus.vala"
	g_dbus_message_set_body (message, _tmp7_);
#line 129 "tracker-bus.vala"
	_g_variant_unref0 (_tmp7_);
#line 130 "tracker-bus.vala"
	g_dbus_message_set_unix_fd_list (message, fd_list);
#line 132 "tracker-bus.vala"
	_tmp8_ = self->priv->bus;
#line 132 "tracker-bus.vala"
	g_dbus_connection_send_message_with_reply (_tmp8_, message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, cancellable, callback, callback_target);
#line 126 "tracker-bus.vala"
	_g_object_unref0 (fd_list);
#line 126 "tracker-bus.vala"
	_g_object_unref0 (message);
#line 1887 "tracker-bus.c"
}


static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 135 "tracker-bus.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 135 "tracker-bus.vala"
	return _data3_;
#line 1898 "tracker-bus.c"
}


static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 135 "tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1909 "tracker-bus.c"
		TrackerBusConnection* self;
#line 135 "tracker-bus.vala"
		self = _data3_->self;
#line 135 "tracker-bus.vala"
		_g_object_unref0 (_data3_->async_res);
#line 135 "tracker-bus.vala"
		_g_main_loop_unref0 (_data3_->loop);
#line 135 "tracker-bus.vala"
		_g_object_unref0 (self);
#line 135 "tracker-bus.vala"
		g_slice_free (Block3Data, _data3_);
#line 1921 "tracker-bus.c"
	}
}


static void
__lambda7_ (Block3Data* _data3_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 141 "tracker-bus.vala"
	self = _data3_->self;
#line 141 "tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 142 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 142 "tracker-bus.vala"
	_g_object_unref0 (_data3_->async_res);
#line 142 "tracker-bus.vala"
	_data3_->async_res = _tmp0_;
#line 143 "tracker-bus.vala"
	g_main_loop_quit (_data3_->loop);
#line 1945 "tracker-bus.c"
}


static void
___lambda7__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 141 "tracker-bus.vala"
	__lambda7_ (self, source_object, res);
#line 141 "tracker-bus.vala"
	block3_data_unref (self);
#line 1958 "tracker-bus.c"
}


static void
tracker_bus_connection_real_update (TrackerSparqlConnection* base,
                                    const gchar* sparql,
                                    gint priority,
                                    GCancellable* cancellable,
                                    GError** error)
{
	TrackerBusConnection * self;
	Block3Data* _data3_;
	GMainContext* context = NULL;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	GError * _inner_error_ = NULL;
#line 135 "tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 135 "tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 135 "tracker-bus.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 135 "tracker-bus.vala"
	_data3_->_ref_count_ = 1;
#line 135 "tracker-bus.vala"
	_data3_->self = g_object_ref (self);
#line 137 "tracker-bus.vala"
	_tmp0_ = g_main_context_new ();
#line 137 "tracker-bus.vala"
	context = _tmp0_;
#line 138 "tracker-bus.vala"
	_tmp1_ = g_main_loop_new (context, FALSE);
#line 138 "tracker-bus.vala"
	_data3_->loop = _tmp1_;
#line 139 "tracker-bus.vala"
	g_main_context_push_thread_default (context);
#line 140 "tracker-bus.vala"
	_data3_->async_res = NULL;
#line 141 "tracker-bus.vala"
	tracker_sparql_connection_update_async ((TrackerSparqlConnection*) self, sparql, priority, cancellable, ___lambda7__gasync_ready_callback, block3_data_ref (_data3_));
#line 145 "tracker-bus.vala"
	g_main_loop_run (_data3_->loop);
#line 146 "tracker-bus.vala"
	g_main_context_pop_thread_default (context);
#line 147 "tracker-bus.vala"
	tracker_sparql_connection_update_finish ((TrackerSparqlConnection*) self, _data3_->async_res, &_inner_error_);
#line 147 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 147 "tracker-bus.vala"
		g_propagate_error (error, _inner_error_);
#line 147 "tracker-bus.vala"
		_g_main_context_unref0 (context);
#line 147 "tracker-bus.vala"
		block3_data_unref (_data3_);
#line 147 "tracker-bus.vala"
		_data3_ = NULL;
#line 147 "tracker-bus.vala"
		return;
#line 2017 "tracker-bus.c"
	}
#line 135 "tracker-bus.vala"
	_g_main_context_unref0 (context);
#line 135 "tracker-bus.vala"
	block3_data_unref (_data3_);
#line 135 "tracker-bus.vala"
	_data3_ = NULL;
#line 2025 "tracker-bus.c"
}


static void
tracker_bus_connection_real_update_async_data_free (gpointer _data)
{
	TrackerBusConnectionUpdateAsyncData* _data_;
	_data_ = _data;
#line 20 "tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "tracker-bus.vala"
	g_slice_free (TrackerBusConnectionUpdateAsyncData, _data_);
#line 2042 "tracker-bus.c"
}


static void
tracker_bus_connection_real_update_async (TrackerSparqlConnection* base,
                                          const gchar* sparql,
                                          gint priority,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 20 "tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateAsyncData);
#line 20 "tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_update_async_data_free);
#line 20 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "tracker-bus.vala"
	_tmp1_ = g_strdup (sparql);
#line 20 "tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "tracker-bus.vala"
	_data_->sparql = _tmp1_;
#line 20 "tracker-bus.vala"
	_data_->priority = priority;
#line 20 "tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "tracker-bus.vala"
	_data_->cancellable = _tmp2_;
#line 20 "tracker-bus.vala"
	tracker_bus_connection_real_update_async_co (_data_);
#line 2087 "tracker-bus.c"
}


static void
tracker_bus_connection_real_update_finish (TrackerSparqlConnection* base,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	TrackerBusConnectionUpdateAsyncData* _data_;
#line 20 "tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "tracker-bus.vala"
		return;
#line 2103 "tracker-bus.c"
	}
}


static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 150 "tracker-bus.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 150 "tracker-bus.vala"
	return _data4_;
#line 2115 "tracker-bus.c"
}


static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 150 "tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 2126 "tracker-bus.c"
		TrackerBusConnection* self;
#line 150 "tracker-bus.vala"
		self = _data4_->self;
#line 150 "tracker-bus.vala"
		_g_object_unref0 (_data4_->dbus_res);
#line 150 "tracker-bus.vala"
		_g_object_unref0 (self);
#line 150 "tracker-bus.vala"
		g_slice_free (Block4Data, _data4_);
#line 2136 "tracker-bus.c"
	}
}


static void
__lambda6_ (Block4Data* _data4_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
	gboolean _tmp1_;
#line 158 "tracker-bus.vala"
	self = _data4_->self;
#line 158 "tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 159 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 159 "tracker-bus.vala"
	_g_object_unref0 (_data4_->dbus_res);
#line 159 "tracker-bus.vala"
	_data4_->dbus_res = _tmp0_;
#line 160 "tracker-bus.vala"
	_tmp1_ = _data4_->sent_update;
#line 160 "tracker-bus.vala"
	if (_tmp1_) {
#line 161 "tracker-bus.vala"
		tracker_bus_connection_real_update_async_co (_data4_->_async_data_);
#line 2165 "tracker-bus.c"
	}
}


static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 158 "tracker-bus.vala"
	__lambda6_ (self, source_object, res);
#line 2177 "tracker-bus.c"
}


static gboolean
tracker_bus_connection_real_update_async_co (TrackerBusConnectionUpdateAsyncData* _data_)
{
#line 150 "tracker-bus.vala"
	switch (_data_->_state_) {
#line 150 "tracker-bus.vala"
		case 0:
#line 2188 "tracker-bus.c"
		goto _state_0;
#line 150 "tracker-bus.vala"
		case 1:
#line 2192 "tracker-bus.c"
		goto _state_1;
		default:
#line 150 "tracker-bus.vala"
		g_assert_not_reached ();
#line 2197 "tracker-bus.c"
	}
	_state_0:
#line 150 "tracker-bus.vala"
	_data_->_data4_ = g_slice_new0 (Block4Data);
#line 150 "tracker-bus.vala"
	_data_->_data4_->_ref_count_ = 1;
#line 150 "tracker-bus.vala"
	_data_->_data4_->self = g_object_ref (_data_->self);
#line 150 "tracker-bus.vala"
	_data_->_data4_->_async_data_ = _data_;
#line 153 "tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 153 "tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 153 "tracker-bus.vala"
	tracker_bus_connection_pipe (_data_->self, &_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error_);
#line 153 "tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 153 "tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 153 "tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 153 "tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 153 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 153 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 153 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 153 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 153 "tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 153 "tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 153 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 153 "tracker-bus.vala"
		return FALSE;
#line 2238 "tracker-bus.c"
	}
#line 156 "tracker-bus.vala"
	_data_->_data4_->dbus_res = NULL;
#line 157 "tracker-bus.vala"
	_data_->_data4_->sent_update = FALSE;
#line 158 "tracker-bus.vala"
	if (_data_->priority <= G_PRIORITY_DEFAULT) {
#line 158 "tracker-bus.vala"
		_data_->_tmp2_ = "Update";
#line 2248 "tracker-bus.c"
	} else {
#line 158 "tracker-bus.vala"
		_data_->_tmp2_ = "BatchUpdate";
#line 2252 "tracker-bus.c"
	}
#line 158 "tracker-bus.vala"
	_data_->_tmp3_ = _data_->input;
#line 158 "tracker-bus.vala"
	tracker_bus_connection_send_update (_data_->self, _data_->_tmp2_, _data_->_tmp3_, _data_->cancellable, ___lambda6__gasync_ready_callback, _data_->_data4_, &_data_->_inner_error_);
#line 158 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 158 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 158 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 158 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 158 "tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 158 "tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 158 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 158 "tracker-bus.vala"
		return FALSE;
#line 2274 "tracker-bus.c"
	}
#line 166 "tracker-bus.vala"
	_data_->_tmp4_ = _data_->output;
#line 166 "tracker-bus.vala"
	_data_->_tmp5_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp4_);
#line 166 "tracker-bus.vala"
	_data_->data_stream = _data_->_tmp5_;
#line 167 "tracker-bus.vala"
	_data_->_tmp6_ = _data_->data_stream;
#line 167 "tracker-bus.vala"
	g_data_output_stream_set_byte_order (_data_->_tmp6_, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
#line 168 "tracker-bus.vala"
	_data_->_tmp7_ = _data_->data_stream;
#line 168 "tracker-bus.vala"
	_data_->_tmp8_ = strlen (_data_->sparql);
#line 168 "tracker-bus.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 168 "tracker-bus.vala"
	g_data_output_stream_put_int32 (_data_->_tmp7_, (gint32) _data_->_tmp9_, NULL, &_data_->_inner_error_);
#line 168 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 168 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 168 "tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 168 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 168 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 168 "tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 168 "tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 168 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 168 "tracker-bus.vala"
		return FALSE;
#line 2312 "tracker-bus.c"
	}
#line 169 "tracker-bus.vala"
	_data_->_tmp10_ = _data_->data_stream;
#line 169 "tracker-bus.vala"
	g_data_output_stream_put_string (_data_->_tmp10_, _data_->sparql, NULL, &_data_->_inner_error_);
#line 169 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 169 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 169 "tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 169 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 169 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 169 "tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 169 "tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 169 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 169 "tracker-bus.vala"
		return FALSE;
#line 2336 "tracker-bus.c"
	}
#line 170 "tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 170 "tracker-bus.vala"
	_data_->data_stream = NULL;
#line 173 "tracker-bus.vala"
	_data_->_data4_->sent_update = TRUE;
#line 174 "tracker-bus.vala"
	_data_->_tmp11_ = _data_->_data4_->dbus_res;
#line 174 "tracker-bus.vala"
	if (_data_->_tmp11_ == NULL) {
#line 175 "tracker-bus.vala"
		_data_->_state_ = 1;
#line 175 "tracker-bus.vala"
		return FALSE;
#line 2352 "tracker-bus.c"
		_state_1:
		;
	}
#line 178 "tracker-bus.vala"
	_data_->_tmp12_ = _data_->self->priv->bus;
#line 178 "tracker-bus.vala"
	_data_->_tmp13_ = _data_->_data4_->dbus_res;
#line 178 "tracker-bus.vala"
	_data_->_tmp14_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp12_, _data_->_tmp13_, &_data_->_inner_error_);
#line 178 "tracker-bus.vala"
	_data_->reply = _data_->_tmp14_;
#line 178 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 178 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 178 "tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 178 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 178 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 178 "tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 178 "tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 178 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 178 "tracker-bus.vala"
		return FALSE;
#line 2382 "tracker-bus.c"
	}
#line 179 "tracker-bus.vala"
	_data_->_tmp15_ = _data_->reply;
#line 179 "tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->self, _data_->_tmp15_, &_data_->_inner_error_);
#line 179 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 179 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 179 "tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 179 "tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 179 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 179 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 179 "tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 179 "tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 179 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 179 "tracker-bus.vala"
		return FALSE;
#line 2408 "tracker-bus.c"
	}
#line 150 "tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 150 "tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 150 "tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 150 "tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 150 "tracker-bus.vala"
	block4_data_unref (_data_->_data4_);
#line 150 "tracker-bus.vala"
	_data_->_data4_ = NULL;
#line 150 "tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 150 "tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 150 "tracker-bus.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 150 "tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2430 "tracker-bus.c"
		}
	}
#line 150 "tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 150 "tracker-bus.vala"
	return FALSE;
#line 2437 "tracker-bus.c"
}


static void
tracker_bus_connection_real_update_array_async_data_free (gpointer _data)
{
	TrackerBusConnectionUpdateArrayAsyncData* _data_;
	_data_ = _data;
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "tracker-bus.vala"
	_g_ptr_array_unref0 (_data_->result);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "tracker-bus.vala"
	g_slice_free (TrackerBusConnectionUpdateArrayAsyncData, _data_);
#line 2454 "tracker-bus.c"
}


static void
tracker_bus_connection_real_update_array_async (TrackerSparqlConnection* base,
                                                gchar** sparql,
                                                int sparql_length1,
                                                gint priority,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateArrayAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	GCancellable* _tmp1_;
#line 20 "tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateArrayAsyncData);
#line 20 "tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_update_array_async_data_free);
#line 20 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "tracker-bus.vala"
	_data_->sparql = sparql;
#line 20 "tracker-bus.vala"
	_data_->sparql_length1 = sparql_length1;
#line 20 "tracker-bus.vala"
	_data_->priority = priority;
#line 20 "tracker-bus.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "tracker-bus.vala"
	_data_->cancellable = _tmp1_;
#line 20 "tracker-bus.vala"
	tracker_bus_connection_real_update_array_async_co (_data_);
#line 2497 "tracker-bus.c"
}


static GPtrArray*
tracker_bus_connection_real_update_array_finish (TrackerSparqlConnection* base,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GPtrArray* result;
	TrackerBusConnectionUpdateArrayAsyncData* _data_;
#line 20 "tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "tracker-bus.vala"
		return NULL;
#line 2514 "tracker-bus.c"
	}
#line 20 "tracker-bus.vala"
	result = _data_->result;
#line 20 "tracker-bus.vala"
	_data_->result = NULL;
#line 20 "tracker-bus.vala"
	return result;
#line 2522 "tracker-bus.c"
}


static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
#line 182 "tracker-bus.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 182 "tracker-bus.vala"
	return _data5_;
#line 2533 "tracker-bus.c"
}


static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 182 "tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 2544 "tracker-bus.c"
		TrackerBusConnection* self;
#line 182 "tracker-bus.vala"
		self = _data5_->self;
#line 182 "tracker-bus.vala"
		_g_object_unref0 (_data5_->dbus_res);
#line 182 "tracker-bus.vala"
		_g_object_unref0 (self);
#line 182 "tracker-bus.vala"
		g_slice_free (Block5Data, _data5_);
#line 2554 "tracker-bus.c"
	}
}


static void
__lambda8_ (Block5Data* _data5_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
	gboolean _tmp1_;
#line 190 "tracker-bus.vala"
	self = _data5_->self;
#line 190 "tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 191 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 191 "tracker-bus.vala"
	_g_object_unref0 (_data5_->dbus_res);
#line 191 "tracker-bus.vala"
	_data5_->dbus_res = _tmp0_;
#line 192 "tracker-bus.vala"
	_tmp1_ = _data5_->sent_update;
#line 192 "tracker-bus.vala"
	if (_tmp1_) {
#line 193 "tracker-bus.vala"
		tracker_bus_connection_real_update_array_async_co (_data5_->_async_data_);
#line 2583 "tracker-bus.c"
	}
}


static void
___lambda8__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 190 "tracker-bus.vala"
	__lambda8_ (self, source_object, res);
#line 2595 "tracker-bus.c"
}


static void
_g_error_free0_ (gpointer var)
{
#line 217 "tracker-bus.vala"
	(var == NULL) ? NULL : (var = (g_error_free (var), NULL));
#line 2604 "tracker-bus.c"
}


static gboolean
tracker_bus_connection_real_update_array_async_co (TrackerBusConnectionUpdateArrayAsyncData* _data_)
{
#line 182 "tracker-bus.vala"
	switch (_data_->_state_) {
#line 182 "tracker-bus.vala"
		case 0:
#line 2615 "tracker-bus.c"
		goto _state_0;
#line 182 "tracker-bus.vala"
		case 1:
#line 2619 "tracker-bus.c"
		goto _state_1;
		default:
#line 182 "tracker-bus.vala"
		g_assert_not_reached ();
#line 2624 "tracker-bus.c"
	}
	_state_0:
#line 182 "tracker-bus.vala"
	_data_->_data5_ = g_slice_new0 (Block5Data);
#line 182 "tracker-bus.vala"
	_data_->_data5_->_ref_count_ = 1;
#line 182 "tracker-bus.vala"
	_data_->_data5_->self = g_object_ref (_data_->self);
#line 182 "tracker-bus.vala"
	_data_->_data5_->_async_data_ = _data_;
#line 185 "tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 185 "tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 185 "tracker-bus.vala"
	tracker_bus_connection_pipe (_data_->self, &_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error_);
#line 185 "tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 185 "tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 185 "tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 185 "tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 185 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 185 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 185 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 185 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 185 "tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 185 "tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 185 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 185 "tracker-bus.vala"
		return FALSE;
#line 2665 "tracker-bus.c"
	}
#line 188 "tracker-bus.vala"
	_data_->_data5_->dbus_res = NULL;
#line 189 "tracker-bus.vala"
	_data_->_data5_->sent_update = FALSE;
#line 190 "tracker-bus.vala"
	_data_->_tmp2_ = _data_->input;
#line 190 "tracker-bus.vala"
	tracker_bus_connection_send_update (_data_->self, "UpdateArray", _data_->_tmp2_, _data_->cancellable, ___lambda8__gasync_ready_callback, _data_->_data5_, &_data_->_inner_error_);
#line 190 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 190 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 190 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 190 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 190 "tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 190 "tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 190 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 190 "tracker-bus.vala"
		return FALSE;
#line 2691 "tracker-bus.c"
	}
#line 198 "tracker-bus.vala"
	_data_->_tmp3_ = _data_->output;
#line 198 "tracker-bus.vala"
	_data_->_tmp4_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp3_);
#line 198 "tracker-bus.vala"
	_data_->data_stream = _data_->_tmp4_;
#line 199 "tracker-bus.vala"
	_data_->_tmp5_ = _data_->data_stream;
#line 199 "tracker-bus.vala"
	g_data_output_stream_set_byte_order (_data_->_tmp5_, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
#line 200 "tracker-bus.vala"
	_data_->_tmp6_ = _data_->data_stream;
#line 200 "tracker-bus.vala"
	g_data_output_stream_put_int32 (_data_->_tmp6_, (gint32) _data_->sparql_length1, NULL, &_data_->_inner_error_);
#line 200 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 200 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 200 "tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 200 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 200 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 200 "tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 200 "tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 200 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 200 "tracker-bus.vala"
		return FALSE;
#line 2725 "tracker-bus.c"
	}
	{
#line 201 "tracker-bus.vala"
		_data_->i = 0;
#line 2730 "tracker-bus.c"
		{
#line 201 "tracker-bus.vala"
			_data_->_tmp7_ = TRUE;
#line 201 "tracker-bus.vala"
			while (TRUE) {
#line 201 "tracker-bus.vala"
				if (!_data_->_tmp7_) {
#line 201 "tracker-bus.vala"
					_data_->_tmp8_ = _data_->i;
#line 201 "tracker-bus.vala"
					_data_->i = _data_->_tmp8_ + 1;
#line 2742 "tracker-bus.c"
				}
#line 201 "tracker-bus.vala"
				_data_->_tmp7_ = FALSE;
#line 201 "tracker-bus.vala"
				_data_->_tmp9_ = _data_->i;
#line 201 "tracker-bus.vala"
				if (!(_data_->_tmp9_ < _data_->sparql_length1)) {
#line 201 "tracker-bus.vala"
					break;
#line 2752 "tracker-bus.c"
				}
#line 202 "tracker-bus.vala"
				_data_->_tmp10_ = _data_->data_stream;
#line 202 "tracker-bus.vala"
				_data_->_tmp11_ = _data_->i;
#line 202 "tracker-bus.vala"
				_data_->_tmp12_ = _data_->sparql[_data_->_tmp11_];
#line 202 "tracker-bus.vala"
				_data_->_tmp13_ = strlen (_data_->_tmp12_);
#line 202 "tracker-bus.vala"
				_data_->_tmp14_ = _data_->_tmp13_;
#line 202 "tracker-bus.vala"
				g_data_output_stream_put_int32 (_data_->_tmp10_, (gint32) _data_->_tmp14_, NULL, &_data_->_inner_error_);
#line 202 "tracker-bus.vala"
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 202 "tracker-bus.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 202 "tracker-bus.vala"
					_g_object_unref0 (_data_->data_stream);
#line 202 "tracker-bus.vala"
					_g_object_unref0 (_data_->output);
#line 202 "tracker-bus.vala"
					_g_object_unref0 (_data_->input);
#line 202 "tracker-bus.vala"
					block5_data_unref (_data_->_data5_);
#line 202 "tracker-bus.vala"
					_data_->_data5_ = NULL;
#line 202 "tracker-bus.vala"
					g_object_unref (_data_->_async_result);
#line 202 "tracker-bus.vala"
					return FALSE;
#line 2784 "tracker-bus.c"
				}
#line 203 "tracker-bus.vala"
				_data_->_tmp15_ = _data_->data_stream;
#line 203 "tracker-bus.vala"
				_data_->_tmp16_ = _data_->i;
#line 203 "tracker-bus.vala"
				_data_->_tmp17_ = _data_->sparql[_data_->_tmp16_];
#line 203 "tracker-bus.vala"
				g_data_output_stream_put_string (_data_->_tmp15_, _data_->_tmp17_, NULL, &_data_->_inner_error_);
#line 203 "tracker-bus.vala"
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 203 "tracker-bus.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 203 "tracker-bus.vala"
					_g_object_unref0 (_data_->data_stream);
#line 203 "tracker-bus.vala"
					_g_object_unref0 (_data_->output);
#line 203 "tracker-bus.vala"
					_g_object_unref0 (_data_->input);
#line 203 "tracker-bus.vala"
					block5_data_unref (_data_->_data5_);
#line 203 "tracker-bus.vala"
					_data_->_data5_ = NULL;
#line 203 "tracker-bus.vala"
					g_object_unref (_data_->_async_result);
#line 203 "tracker-bus.vala"
					return FALSE;
#line 2812 "tracker-bus.c"
				}
			}
		}
	}
#line 205 "tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 205 "tracker-bus.vala"
	_data_->data_stream = NULL;
#line 208 "tracker-bus.vala"
	_data_->_data5_->sent_update = TRUE;
#line 209 "tracker-bus.vala"
	_data_->_tmp18_ = _data_->_data5_->dbus_res;
#line 209 "tracker-bus.vala"
	if (_data_->_tmp18_ == NULL) {
#line 210 "tracker-bus.vala"
		_data_->_state_ = 1;
#line 210 "tracker-bus.vala"
		return FALSE;
#line 2831 "tracker-bus.c"
		_state_1:
		;
	}
#line 213 "tracker-bus.vala"
	_data_->_tmp19_ = _data_->self->priv->bus;
#line 213 "tracker-bus.vala"
	_data_->_tmp20_ = _data_->_data5_->dbus_res;
#line 213 "tracker-bus.vala"
	_data_->_tmp21_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp19_, _data_->_tmp20_, &_data_->_inner_error_);
#line 213 "tracker-bus.vala"
	_data_->reply = _data_->_tmp21_;
#line 213 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 213 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 213 "tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 213 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 213 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 213 "tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 213 "tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 213 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 213 "tracker-bus.vala"
		return FALSE;
#line 2861 "tracker-bus.c"
	}
#line 214 "tracker-bus.vala"
	_data_->_tmp22_ = _data_->reply;
#line 214 "tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->self, _data_->_tmp22_, &_data_->_inner_error_);
#line 214 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 214 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 214 "tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 214 "tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 214 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 214 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 214 "tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 214 "tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 214 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 214 "tracker-bus.vala"
		return FALSE;
#line 2887 "tracker-bus.c"
	}
#line 217 "tracker-bus.vala"
	_data_->_tmp23_ = g_ptr_array_new_full ((guint) 0, _g_error_free0_);
#line 217 "tracker-bus.vala"
	_data_->_result_ = _data_->_tmp23_;
#line 219 "tracker-bus.vala"
	_data_->_tmp24_ = _data_->reply;
#line 219 "tracker-bus.vala"
	_data_->_tmp25_ = g_dbus_message_get_body (_data_->_tmp24_);
#line 219 "tracker-bus.vala"
	_data_->_tmp26_ = g_variant_get_child_value (_data_->_tmp25_, (gsize) 0);
#line 219 "tracker-bus.vala"
	_g_variant_unref0 (_data_->resultv);
#line 219 "tracker-bus.vala"
	_data_->resultv = _data_->_tmp26_;
#line 220 "tracker-bus.vala"
	_data_->_tmp27_ = _data_->resultv;
#line 220 "tracker-bus.vala"
	_data_->_tmp28_ = g_variant_iter_new (_data_->_tmp27_);
#line 220 "tracker-bus.vala"
	_data_->iter = _data_->_tmp28_;
#line 222 "tracker-bus.vala"
	while (TRUE) {
#line 222 "tracker-bus.vala"
		_data_->_tmp29_ = _data_->iter;
#line 222 "tracker-bus.vala"
		if (!g_variant_iter_next (_data_->_tmp29_, "s", &_data_->code, NULL)) {
#line 222 "tracker-bus.vala"
			break;
#line 2917 "tracker-bus.c"
		}
#line 223 "tracker-bus.vala"
		_data_->_tmp30_ = _data_->iter;
#line 223 "tracker-bus.vala"
		if (g_variant_iter_next (_data_->_tmp30_, "s", &_data_->message, NULL)) {
#line 224 "tracker-bus.vala"
			_data_->_tmp32_ = _data_->code;
#line 224 "tracker-bus.vala"
			if (g_strcmp0 (_data_->_tmp32_, "") != 0) {
#line 224 "tracker-bus.vala"
				_data_->_tmp33_ = _data_->message;
#line 224 "tracker-bus.vala"
				_data_->_tmp31_ = g_strcmp0 (_data_->_tmp33_, "") != 0;
#line 2931 "tracker-bus.c"
			} else {
#line 224 "tracker-bus.vala"
				_data_->_tmp31_ = FALSE;
#line 2935 "tracker-bus.c"
			}
#line 224 "tracker-bus.vala"
			if (_data_->_tmp31_) {
#line 225 "tracker-bus.vala"
				_data_->_tmp34_ = _data_->_result_;
#line 225 "tracker-bus.vala"
				_data_->_tmp35_ = _data_->message;
#line 225 "tracker-bus.vala"
				_data_->_tmp36_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp35_);
#line 225 "tracker-bus.vala"
				g_ptr_array_add (_data_->_tmp34_, _data_->_tmp36_);
#line 2947 "tracker-bus.c"
			} else {
#line 227 "tracker-bus.vala"
				_data_->_tmp37_ = _data_->_result_;
#line 227 "tracker-bus.vala"
				g_ptr_array_add (_data_->_tmp37_, NULL);
#line 2953 "tracker-bus.c"
			}
#line 230 "tracker-bus.vala"
			_g_free0 (_data_->message);
#line 230 "tracker-bus.vala"
			_data_->message = NULL;
#line 2959 "tracker-bus.c"
		}
#line 233 "tracker-bus.vala"
		_g_free0 (_data_->code);
#line 233 "tracker-bus.vala"
		_data_->code = NULL;
#line 2965 "tracker-bus.c"
	}
#line 235 "tracker-bus.vala"
	_data_->result = _data_->_result_;
#line 235 "tracker-bus.vala"
	_g_free0 (_data_->message);
#line 235 "tracker-bus.vala"
	_g_free0 (_data_->code);
#line 235 "tracker-bus.vala"
	_g_variant_iter_free0 (_data_->iter);
#line 235 "tracker-bus.vala"
	_g_variant_unref0 (_data_->resultv);
#line 235 "tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 235 "tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 235 "tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 235 "tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 235 "tracker-bus.vala"
	block5_data_unref (_data_->_data5_);
#line 235 "tracker-bus.vala"
	_data_->_data5_ = NULL;
#line 235 "tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 235 "tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 235 "tracker-bus.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 235 "tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2997 "tracker-bus.c"
		}
	}
#line 235 "tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 235 "tracker-bus.vala"
	return FALSE;
#line 3004 "tracker-bus.c"
}


static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
#line 238 "tracker-bus.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 238 "tracker-bus.vala"
	return _data6_;
#line 3015 "tracker-bus.c"
}


static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 238 "tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 3026 "tracker-bus.c"
		TrackerBusConnection* self;
#line 238 "tracker-bus.vala"
		self = _data6_->self;
#line 238 "tracker-bus.vala"
		_g_object_unref0 (_data6_->async_res);
#line 238 "tracker-bus.vala"
		_g_main_loop_unref0 (_data6_->loop);
#line 238 "tracker-bus.vala"
		_g_object_unref0 (self);
#line 238 "tracker-bus.vala"
		g_slice_free (Block6Data, _data6_);
#line 3038 "tracker-bus.c"
	}
}


static void
__lambda10_ (Block6Data* _data6_,
             GObject* o,
             GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 244 "tracker-bus.vala"
	self = _data6_->self;
#line 244 "tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 245 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 245 "tracker-bus.vala"
	_g_object_unref0 (_data6_->async_res);
#line 245 "tracker-bus.vala"
	_data6_->async_res = _tmp0_;
#line 246 "tracker-bus.vala"
	g_main_loop_quit (_data6_->loop);
#line 3062 "tracker-bus.c"
}


static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 244 "tracker-bus.vala"
	__lambda10_ (self, source_object, res);
#line 244 "tracker-bus.vala"
	block6_data_unref (self);
#line 3075 "tracker-bus.c"
}


static GVariant*
tracker_bus_connection_real_update_blank (TrackerSparqlConnection* base,
                                          const gchar* sparql,
                                          gint priority,
                                          GCancellable* cancellable,
                                          GError** error)
{
	TrackerBusConnection * self;
	GVariant* result = NULL;
	Block6Data* _data6_;
	GMainContext* context = NULL;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GError * _inner_error_ = NULL;
#line 238 "tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 238 "tracker-bus.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 238 "tracker-bus.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 238 "tracker-bus.vala"
	_data6_->_ref_count_ = 1;
#line 238 "tracker-bus.vala"
	_data6_->self = g_object_ref (self);
#line 240 "tracker-bus.vala"
	_tmp0_ = g_main_context_new ();
#line 240 "tracker-bus.vala"
	context = _tmp0_;
#line 241 "tracker-bus.vala"
	_tmp1_ = g_main_loop_new (context, FALSE);
#line 241 "tracker-bus.vala"
	_data6_->loop = _tmp1_;
#line 242 "tracker-bus.vala"
	g_main_context_push_thread_default (context);
#line 243 "tracker-bus.vala"
	_data6_->async_res = NULL;
#line 244 "tracker-bus.vala"
	tracker_sparql_connection_update_blank_async ((TrackerSparqlConnection*) self, sparql, priority, cancellable, ___lambda10__gasync_ready_callback, block6_data_ref (_data6_));
#line 248 "tracker-bus.vala"
	g_main_loop_run (_data6_->loop);
#line 249 "tracker-bus.vala"
	g_main_context_pop_thread_default (context);
#line 250 "tracker-bus.vala"
	_tmp3_ = tracker_sparql_connection_update_blank_finish ((TrackerSparqlConnection*) self, _data6_->async_res, &_inner_error_);
#line 250 "tracker-bus.vala"
	_tmp2_ = _tmp3_;
#line 250 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 250 "tracker-bus.vala"
		g_propagate_error (error, _inner_error_);
#line 250 "tracker-bus.vala"
		_g_main_context_unref0 (context);
#line 250 "tracker-bus.vala"
		block6_data_unref (_data6_);
#line 250 "tracker-bus.vala"
		_data6_ = NULL;
#line 250 "tracker-bus.vala"
		return NULL;
#line 3140 "tracker-bus.c"
	}
#line 250 "tracker-bus.vala"
	_tmp4_ = _tmp2_;
#line 250 "tracker-bus.vala"
	_tmp2_ = NULL;
#line 250 "tracker-bus.vala"
	result = _tmp4_;
#line 250 "tracker-bus.vala"
	_g_variant_unref0 (_tmp2_);
#line 250 "tracker-bus.vala"
	_g_main_context_unref0 (context);
#line 250 "tracker-bus.vala"
	block6_data_unref (_data6_);
#line 250 "tracker-bus.vala"
	_data6_ = NULL;
#line 250 "tracker-bus.vala"
	return result;
#line 3158 "tracker-bus.c"
}


static void
tracker_bus_connection_real_update_blank_async_data_free (gpointer _data)
{
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
	_data_ = _data;
#line 20 "tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "tracker-bus.vala"
	_g_variant_unref0 (_data_->result);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "tracker-bus.vala"
	g_slice_free (TrackerBusConnectionUpdateBlankAsyncData, _data_);
#line 3177 "tracker-bus.c"
}


static void
tracker_bus_connection_real_update_blank_async (TrackerSparqlConnection* base,
                                                const gchar* sparql,
                                                gint priority,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 20 "tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateBlankAsyncData);
#line 20 "tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_update_blank_async_data_free);
#line 20 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "tracker-bus.vala"
	_tmp1_ = g_strdup (sparql);
#line 20 "tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "tracker-bus.vala"
	_data_->sparql = _tmp1_;
#line 20 "tracker-bus.vala"
	_data_->priority = priority;
#line 20 "tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "tracker-bus.vala"
	_data_->cancellable = _tmp2_;
#line 20 "tracker-bus.vala"
	tracker_bus_connection_real_update_blank_async_co (_data_);
#line 3222 "tracker-bus.c"
}


static GVariant*
tracker_bus_connection_real_update_blank_finish (TrackerSparqlConnection* base,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GVariant* result;
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
#line 20 "tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "tracker-bus.vala"
		return NULL;
#line 3239 "tracker-bus.c"
	}
#line 20 "tracker-bus.vala"
	result = _data_->result;
#line 20 "tracker-bus.vala"
	_data_->result = NULL;
#line 20 "tracker-bus.vala"
	return result;
#line 3247 "tracker-bus.c"
}


static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
#line 253 "tracker-bus.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 253 "tracker-bus.vala"
	return _data7_;
#line 3258 "tracker-bus.c"
}


static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 253 "tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 3269 "tracker-bus.c"
		TrackerBusConnection* self;
#line 253 "tracker-bus.vala"
		self = _data7_->self;
#line 253 "tracker-bus.vala"
		_g_object_unref0 (_data7_->dbus_res);
#line 253 "tracker-bus.vala"
		_g_object_unref0 (self);
#line 253 "tracker-bus.vala"
		g_slice_free (Block7Data, _data7_);
#line 3279 "tracker-bus.c"
	}
}


static void
__lambda9_ (Block7Data* _data7_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
	gboolean _tmp1_;
#line 261 "tracker-bus.vala"
	self = _data7_->self;
#line 261 "tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 262 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 262 "tracker-bus.vala"
	_g_object_unref0 (_data7_->dbus_res);
#line 262 "tracker-bus.vala"
	_data7_->dbus_res = _tmp0_;
#line 263 "tracker-bus.vala"
	_tmp1_ = _data7_->sent_update;
#line 263 "tracker-bus.vala"
	if (_tmp1_) {
#line 264 "tracker-bus.vala"
		tracker_bus_connection_real_update_blank_async_co (_data7_->_async_data_);
#line 3308 "tracker-bus.c"
	}
}


static void
___lambda9__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 261 "tracker-bus.vala"
	__lambda9_ (self, source_object, res);
#line 3320 "tracker-bus.c"
}


static gboolean
tracker_bus_connection_real_update_blank_async_co (TrackerBusConnectionUpdateBlankAsyncData* _data_)
{
#line 253 "tracker-bus.vala"
	switch (_data_->_state_) {
#line 253 "tracker-bus.vala"
		case 0:
#line 3331 "tracker-bus.c"
		goto _state_0;
#line 253 "tracker-bus.vala"
		case 1:
#line 3335 "tracker-bus.c"
		goto _state_1;
		default:
#line 253 "tracker-bus.vala"
		g_assert_not_reached ();
#line 3340 "tracker-bus.c"
	}
	_state_0:
#line 253 "tracker-bus.vala"
	_data_->_data7_ = g_slice_new0 (Block7Data);
#line 253 "tracker-bus.vala"
	_data_->_data7_->_ref_count_ = 1;
#line 253 "tracker-bus.vala"
	_data_->_data7_->self = g_object_ref (_data_->self);
#line 253 "tracker-bus.vala"
	_data_->_data7_->_async_data_ = _data_;
#line 256 "tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 256 "tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 256 "tracker-bus.vala"
	tracker_bus_connection_pipe (_data_->self, &_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error_);
#line 256 "tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 256 "tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 256 "tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 256 "tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 256 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 256 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 256 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 256 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 256 "tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 256 "tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 256 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 256 "tracker-bus.vala"
		return FALSE;
#line 3381 "tracker-bus.c"
	}
#line 259 "tracker-bus.vala"
	_data_->_data7_->dbus_res = NULL;
#line 260 "tracker-bus.vala"
	_data_->_data7_->sent_update = FALSE;
#line 261 "tracker-bus.vala"
	_data_->_tmp2_ = _data_->input;
#line 261 "tracker-bus.vala"
	tracker_bus_connection_send_update (_data_->self, "UpdateBlank", _data_->_tmp2_, _data_->cancellable, ___lambda9__gasync_ready_callback, _data_->_data7_, &_data_->_inner_error_);
#line 261 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 261 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 261 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 261 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 261 "tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 261 "tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 261 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 261 "tracker-bus.vala"
		return FALSE;
#line 3407 "tracker-bus.c"
	}
#line 269 "tracker-bus.vala"
	_data_->_tmp3_ = _data_->output;
#line 269 "tracker-bus.vala"
	_data_->_tmp4_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp3_);
#line 269 "tracker-bus.vala"
	_data_->data_stream = _data_->_tmp4_;
#line 270 "tracker-bus.vala"
	_data_->_tmp5_ = _data_->data_stream;
#line 270 "tracker-bus.vala"
	g_data_output_stream_set_byte_order (_data_->_tmp5_, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
#line 271 "tracker-bus.vala"
	_data_->_tmp6_ = _data_->data_stream;
#line 271 "tracker-bus.vala"
	_data_->_tmp7_ = strlen (_data_->sparql);
#line 271 "tracker-bus.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 271 "tracker-bus.vala"
	g_data_output_stream_put_int32 (_data_->_tmp6_, (gint32) _data_->_tmp8_, NULL, &_data_->_inner_error_);
#line 271 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 271 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 271 "tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 271 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 271 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 271 "tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 271 "tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 271 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 271 "tracker-bus.vala"
		return FALSE;
#line 3445 "tracker-bus.c"
	}
#line 272 "tracker-bus.vala"
	_data_->_tmp9_ = _data_->data_stream;
#line 272 "tracker-bus.vala"
	g_data_output_stream_put_string (_data_->_tmp9_, _data_->sparql, NULL, &_data_->_inner_error_);
#line 272 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 272 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 272 "tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 272 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 272 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 272 "tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 272 "tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 272 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 272 "tracker-bus.vala"
		return FALSE;
#line 3469 "tracker-bus.c"
	}
#line 273 "tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 273 "tracker-bus.vala"
	_data_->data_stream = NULL;
#line 276 "tracker-bus.vala"
	_data_->_data7_->sent_update = TRUE;
#line 277 "tracker-bus.vala"
	_data_->_tmp10_ = _data_->_data7_->dbus_res;
#line 277 "tracker-bus.vala"
	if (_data_->_tmp10_ == NULL) {
#line 278 "tracker-bus.vala"
		_data_->_state_ = 1;
#line 278 "tracker-bus.vala"
		return FALSE;
#line 3485 "tracker-bus.c"
		_state_1:
		;
	}
#line 281 "tracker-bus.vala"
	_data_->_tmp11_ = _data_->self->priv->bus;
#line 281 "tracker-bus.vala"
	_data_->_tmp12_ = _data_->_data7_->dbus_res;
#line 281 "tracker-bus.vala"
	_data_->_tmp13_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp11_, _data_->_tmp12_, &_data_->_inner_error_);
#line 281 "tracker-bus.vala"
	_data_->reply = _data_->_tmp13_;
#line 281 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 281 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 281 "tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 281 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 281 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 281 "tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 281 "tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 281 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 281 "tracker-bus.vala"
		return FALSE;
#line 3515 "tracker-bus.c"
	}
#line 282 "tracker-bus.vala"
	_data_->_tmp14_ = _data_->reply;
#line 282 "tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->self, _data_->_tmp14_, &_data_->_inner_error_);
#line 282 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 282 "tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 282 "tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 282 "tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 282 "tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 282 "tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 282 "tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 282 "tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 282 "tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 282 "tracker-bus.vala"
		return FALSE;
#line 3541 "tracker-bus.c"
	}
#line 283 "tracker-bus.vala"
	_data_->_tmp15_ = _data_->reply;
#line 283 "tracker-bus.vala"
	_data_->_tmp16_ = g_dbus_message_get_body (_data_->_tmp15_);
#line 283 "tracker-bus.vala"
	_data_->_tmp17_ = g_variant_get_child_value (_data_->_tmp16_, (gsize) 0);
#line 283 "tracker-bus.vala"
	_data_->result = _data_->_tmp17_;
#line 283 "tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 283 "tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 283 "tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 283 "tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 283 "tracker-bus.vala"
	block7_data_unref (_data_->_data7_);
#line 283 "tracker-bus.vala"
	_data_->_data7_ = NULL;
#line 283 "tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 283 "tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 283 "tracker-bus.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 283 "tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3571 "tracker-bus.c"
		}
	}
#line 283 "tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 283 "tracker-bus.vala"
	return FALSE;
#line 3578 "tracker-bus.c"
}


static void
tracker_bus_connection_real_load (TrackerSparqlConnection* base,
                                  GFile* file,
                                  GCancellable* cancellable,
                                  GError** error)
{
	TrackerBusConnection * self;
	GDBusMessage* message = NULL;
	const gchar* _tmp0_;
	GDBusMessage* _tmp1_;
	GDBusMessage* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GDBusMessage* reply = NULL;
	GDBusConnection* _tmp7_;
	GDBusMessage* _tmp8_;
	GDBusMessage* _tmp9_;
	GDBusMessage* _tmp10_;
	GError * _inner_error_ = NULL;
#line 286 "tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 286 "tracker-bus.vala"
	g_return_if_fail (file != NULL);
#line 287 "tracker-bus.vala"
	_tmp0_ = self->priv->dbus_name;
#line 287 "tracker-bus.vala"
	_tmp1_ = g_dbus_message_new_method_call (_tmp0_, TRACKER_DBUS_OBJECT_RESOURCES, TRACKER_DBUS_INTERFACE_RESOURCES, "Load");
#line 287 "tracker-bus.vala"
	message = _tmp1_;
#line 288 "tracker-bus.vala"
	_tmp2_ = message;
#line 288 "tracker-bus.vala"
	_tmp3_ = g_file_get_uri (file);
#line 288 "tracker-bus.vala"
	_tmp4_ = _tmp3_;
#line 288 "tracker-bus.vala"
	_tmp5_ = g_variant_new ("(s)", _tmp4_, NULL);
#line 288 "tracker-bus.vala"
	g_variant_ref_sink (_tmp5_);
#line 288 "tracker-bus.vala"
	_tmp6_ = _tmp5_;
#line 288 "tracker-bus.vala"
	g_dbus_message_set_body (_tmp2_, _tmp6_);
#line 288 "tracker-bus.vala"
	_g_variant_unref0 (_tmp6_);
#line 288 "tracker-bus.vala"
	_g_free0 (_tmp4_);
#line 290 "tracker-bus.vala"
	_tmp7_ = self->priv->bus;
#line 290 "tracker-bus.vala"
	_tmp8_ = message;
#line 290 "tracker-bus.vala"
	_tmp9_ = g_dbus_connection_send_message_with_reply_sync (_tmp7_, _tmp8_, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, cancellable, &_inner_error_);
#line 290 "tracker-bus.vala"
	reply = _tmp9_;
#line 290 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 290 "tracker-bus.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 290 "tracker-bus.vala"
			g_propagate_error (error, _inner_error_);
#line 290 "tracker-bus.vala"
			_g_object_unref0 (message);
#line 290 "tracker-bus.vala"
			return;
#line 3649 "tracker-bus.c"
		} else {
#line 290 "tracker-bus.vala"
			_g_object_unref0 (message);
#line 290 "tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 290 "tracker-bus.vala"
			g_clear_error (&_inner_error_);
#line 290 "tracker-bus.vala"
			return;
#line 3659 "tracker-bus.c"
		}
	}
#line 291 "tracker-bus.vala"
	_tmp10_ = reply;
#line 291 "tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (self, _tmp10_, &_inner_error_);
#line 291 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 291 "tracker-bus.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 291 "tracker-bus.vala"
			g_propagate_error (error, _inner_error_);
#line 291 "tracker-bus.vala"
			_g_object_unref0 (reply);
#line 291 "tracker-bus.vala"
			_g_object_unref0 (message);
#line 291 "tracker-bus.vala"
			return;
#line 3678 "tracker-bus.c"
		} else {
#line 291 "tracker-bus.vala"
			_g_object_unref0 (reply);
#line 291 "tracker-bus.vala"
			_g_object_unref0 (message);
#line 291 "tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 291 "tracker-bus.vala"
			g_clear_error (&_inner_error_);
#line 291 "tracker-bus.vala"
			return;
#line 3690 "tracker-bus.c"
		}
	}
#line 286 "tracker-bus.vala"
	_g_object_unref0 (reply);
#line 286 "tracker-bus.vala"
	_g_object_unref0 (message);
#line 3697 "tracker-bus.c"
}


static void
tracker_bus_connection_real_load_async_data_free (gpointer _data)
{
	TrackerBusConnectionLoadAsyncData* _data_;
	_data_ = _data;
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->file);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "tracker-bus.vala"
	g_slice_free (TrackerBusConnectionLoadAsyncData, _data_);
#line 3714 "tracker-bus.c"
}


static void
tracker_bus_connection_real_load_async (TrackerSparqlConnection* base,
                                        GFile* file,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionLoadAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
#line 20 "tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionLoadAsyncData);
#line 20 "tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_load_async_data_free);
#line 20 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "tracker-bus.vala"
	_tmp1_ = _g_object_ref0 (file);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->file);
#line 20 "tracker-bus.vala"
	_data_->file = _tmp1_;
#line 20 "tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "tracker-bus.vala"
	_data_->cancellable = _tmp2_;
#line 20 "tracker-bus.vala"
	tracker_bus_connection_real_load_async_co (_data_);
#line 3756 "tracker-bus.c"
}


static void
tracker_bus_connection_real_load_finish (TrackerSparqlConnection* base,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	TrackerBusConnectionLoadAsyncData* _data_;
#line 20 "tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "tracker-bus.vala"
		return;
#line 3772 "tracker-bus.c"
	}
}


static void
tracker_bus_connection_load_async_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	TrackerBusConnectionLoadAsyncData* _data_;
#line 298 "tracker-bus.vala"
	_data_ = _user_data_;
#line 298 "tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 298 "tracker-bus.vala"
	_data_->_res_ = _res_;
#line 298 "tracker-bus.vala"
	tracker_bus_connection_real_load_async_co (_data_);
#line 3791 "tracker-bus.c"
}


static gboolean
tracker_bus_connection_real_load_async_co (TrackerBusConnectionLoadAsyncData* _data_)
{
#line 294 "tracker-bus.vala"
	switch (_data_->_state_) {
#line 294 "tracker-bus.vala"
		case 0:
#line 3802 "tracker-bus.c"
		goto _state_0;
#line 294 "tracker-bus.vala"
		case 1:
#line 3806 "tracker-bus.c"
		goto _state_1;
		default:
#line 294 "tracker-bus.vala"
		g_assert_not_reached ();
#line 3811 "tracker-bus.c"
	}
	_state_0:
#line 295 "tracker-bus.vala"
	_data_->_tmp0_ = _data_->self->priv->dbus_name;
#line 295 "tracker-bus.vala"
	_data_->_tmp1_ = g_dbus_message_new_method_call (_data_->_tmp0_, TRACKER_DBUS_OBJECT_RESOURCES, TRACKER_DBUS_INTERFACE_RESOURCES, "Load");
#line 295 "tracker-bus.vala"
	_data_->message = _data_->_tmp1_;
#line 296 "tracker-bus.vala"
	_data_->_tmp2_ = _data_->message;
#line 296 "tracker-bus.vala"
	_data_->_tmp3_ = g_file_get_uri (_data_->file);
#line 296 "tracker-bus.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 296 "tracker-bus.vala"
	_data_->_tmp5_ = g_variant_new ("(s)", _data_->_tmp4_, NULL);
#line 296 "tracker-bus.vala"
	g_variant_ref_sink (_data_->_tmp5_);
#line 296 "tracker-bus.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 296 "tracker-bus.vala"
	g_dbus_message_set_body (_data_->_tmp2_, _data_->_tmp6_);
#line 296 "tracker-bus.vala"
	_g_variant_unref0 (_data_->_tmp6_);
#line 296 "tracker-bus.vala"
	_g_free0 (_data_->_tmp4_);
#line 298 "tracker-bus.vala"
	_data_->_tmp7_ = _data_->self->priv->bus;
#line 298 "tracker-bus.vala"
	_data_->_tmp8_ = _data_->message;
#line 298 "tracker-bus.vala"
	_data_->_state_ = 1;
#line 298 "tracker-bus.vala"
	g_dbus_connection_send_message_with_reply (_data_->_tmp7_, _data_->_tmp8_, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, _data_->cancellable, tracker_bus_connection_load_async_ready, _data_);
#line 298 "tracker-bus.vala"
	return FALSE;
#line 3848 "tracker-bus.c"
	_state_1:
#line 298 "tracker-bus.vala"
	_data_->_tmp9_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 298 "tracker-bus.vala"
	_data_->reply = _data_->_tmp9_;
#line 298 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 298 "tracker-bus.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 298 "tracker-bus.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 298 "tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 298 "tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 298 "tracker-bus.vala"
			return FALSE;
#line 3866 "tracker-bus.c"
		} else {
#line 298 "tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 298 "tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 298 "tracker-bus.vala"
			g_clear_error (&_data_->_inner_error_);
#line 298 "tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 298 "tracker-bus.vala"
			return FALSE;
#line 3878 "tracker-bus.c"
		}
	}
#line 299 "tracker-bus.vala"
	_data_->_tmp10_ = _data_->reply;
#line 299 "tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->self, _data_->_tmp10_, &_data_->_inner_error_);
#line 299 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 299 "tracker-bus.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 299 "tracker-bus.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 299 "tracker-bus.vala"
			_g_object_unref0 (_data_->reply);
#line 299 "tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 299 "tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 299 "tracker-bus.vala"
			return FALSE;
#line 3899 "tracker-bus.c"
		} else {
#line 299 "tracker-bus.vala"
			_g_object_unref0 (_data_->reply);
#line 299 "tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 299 "tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 299 "tracker-bus.vala"
			g_clear_error (&_data_->_inner_error_);
#line 299 "tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 299 "tracker-bus.vala"
			return FALSE;
#line 3913 "tracker-bus.c"
		}
	}
#line 294 "tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 294 "tracker-bus.vala"
	_g_object_unref0 (_data_->message);
#line 294 "tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 294 "tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 294 "tracker-bus.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 294 "tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3928 "tracker-bus.c"
		}
	}
#line 294 "tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 294 "tracker-bus.vala"
	return FALSE;
#line 3935 "tracker-bus.c"
}


static gchar**
_variant_get2 (GVariant* value,
               int* result_length1,
               int* result_length2)
{
	gchar** _tmp11_;
	int _tmp11__length;
	int _tmp11__size;
	int _tmp11__length1;
	GVariantIter _tmp12_;
	GVariant* _tmp13_;
	_tmp11_ = g_new (gchar*, 5);
	_tmp11__length = 0;
	_tmp11__size = 4;
	_tmp11__length1 = 0;
#line 308 "tracker-bus.vala"
	g_variant_iter_init (&_tmp12_, value);
#line 308 "tracker-bus.vala"
	for (; (_tmp13_ = g_variant_iter_next_value (&_tmp12_)) != NULL; _tmp11__length1++) {
#line 3958 "tracker-bus.c"
		int _tmp11__length2;
		GVariantIter _tmp14_;
		GVariant* _tmp15_;
		_tmp11__length2 = 0;
#line 308 "tracker-bus.vala"
		g_variant_iter_init (&_tmp14_, _tmp13_);
#line 308 "tracker-bus.vala"
		for (; (_tmp15_ = g_variant_iter_next_value (&_tmp14_)) != NULL; _tmp11__length2++) {
#line 308 "tracker-bus.vala"
			if (_tmp11__size == _tmp11__length) {
#line 308 "tracker-bus.vala"
				_tmp11__size = 2 * _tmp11__size;
#line 308 "tracker-bus.vala"
				_tmp11_ = g_renew (gchar*, _tmp11_, _tmp11__size + 1);
#line 3973 "tracker-bus.c"
			}
#line 308 "tracker-bus.vala"
			_tmp11_[_tmp11__length++] = g_variant_dup_string (_tmp15_, NULL);
#line 308 "tracker-bus.vala"
			g_variant_unref (_tmp15_);
#line 3979 "tracker-bus.c"
		}
#line 308 "tracker-bus.vala"
		*result_length2 = _tmp11__length2;
#line 308 "tracker-bus.vala"
		g_variant_unref (_tmp13_);
#line 3985 "tracker-bus.c"
	}
#line 308 "tracker-bus.vala"
	*result_length1 = _tmp11__length1;
#line 308 "tracker-bus.vala"
	_tmp11_[_tmp11__length] = NULL;
#line 308 "tracker-bus.vala"
	return _tmp11_;
#line 3993 "tracker-bus.c"
}


static TrackerSparqlCursor*
tracker_bus_connection_real_statistics (TrackerSparqlConnection* base,
                                        GCancellable* cancellable,
                                        GError** error)
{
	TrackerBusConnection * self;
	TrackerSparqlCursor* result = NULL;
	GDBusMessage* message = NULL;
	const gchar* _tmp0_;
	GDBusMessage* _tmp1_;
	GDBusMessage* reply = NULL;
	GDBusConnection* _tmp2_;
	GDBusMessage* _tmp3_;
	GDBusMessage* _tmp4_;
	GDBusMessage* _tmp5_;
	gchar** results = NULL;
	GDBusMessage* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gint _tmp16__length2;
	gint results_length1;
	gint results_length2;
	TrackerSparqlValueType* types = NULL;
	TrackerSparqlValueType* _tmp17_;
	gint types_length1;
	gint _types_size_;
	gchar** var_names = NULL;
	gchar** _tmp18_;
	gint var_names_length1;
	gint _var_names_size_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar* _tmp24_;
	TrackerSparqlValueType* _tmp25_;
	gint _tmp25__length1;
	TrackerSparqlValueType _tmp26_;
	TrackerSparqlValueType* _tmp27_;
	gint _tmp27__length1;
	TrackerSparqlValueType _tmp28_;
	gint rows = 0;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gint _tmp29__length2;
	gint _tmp30_;
	gint cols = 0;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gint _tmp31__length2;
	gint _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gint _tmp33__length2;
	gint _tmp34_;
	gint _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	TrackerSparqlValueType* _tmp37_;
	gint _tmp37__length1;
	TrackerBusArrayCursor* _tmp38_;
	GError * _inner_error_ = NULL;
#line 302 "tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 303 "tracker-bus.vala"
	_tmp0_ = self->priv->dbus_name;
#line 303 "tracker-bus.vala"
	_tmp1_ = g_dbus_message_new_method_call (_tmp0_, TRACKER_DBUS_OBJECT_STATISTICS, TRACKER_DBUS_INTERFACE_STATISTICS, "Get");
#line 303 "tracker-bus.vala"
	message = _tmp1_;
#line 305 "tracker-bus.vala"
	_tmp2_ = self->priv->bus;
#line 305 "tracker-bus.vala"
	_tmp3_ = message;
#line 305 "tracker-bus.vala"
	_tmp4_ = g_dbus_connection_send_message_with_reply_sync (_tmp2_, _tmp3_, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, cancellable, &_inner_error_);
#line 305 "tracker-bus.vala"
	reply = _tmp4_;
#line 305 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 305 "tracker-bus.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 305 "tracker-bus.vala"
			g_propagate_error (error, _inner_error_);
#line 305 "tracker-bus.vala"
			_g_object_unref0 (message);
#line 305 "tracker-bus.vala"
			return NULL;
#line 4094 "tracker-bus.c"
		} else {
#line 305 "tracker-bus.vala"
			_g_object_unref0 (message);
#line 305 "tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 305 "tracker-bus.vala"
			g_clear_error (&_inner_error_);
#line 305 "tracker-bus.vala"
			return NULL;
#line 4104 "tracker-bus.c"
		}
	}
#line 306 "tracker-bus.vala"
	_tmp5_ = reply;
#line 306 "tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (self, _tmp5_, &_inner_error_);
#line 306 "tracker-bus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 306 "tracker-bus.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 306 "tracker-bus.vala"
			g_propagate_error (error, _inner_error_);
#line 306 "tracker-bus.vala"
			_g_object_unref0 (reply);
#line 306 "tracker-bus.vala"
			_g_object_unref0 (message);
#line 306 "tracker-bus.vala"
			return NULL;
#line 4123 "tracker-bus.c"
		} else {
#line 306 "tracker-bus.vala"
			_g_object_unref0 (reply);
#line 306 "tracker-bus.vala"
			_g_object_unref0 (message);
#line 306 "tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 306 "tracker-bus.vala"
			g_clear_error (&_inner_error_);
#line 306 "tracker-bus.vala"
			return NULL;
#line 4135 "tracker-bus.c"
		}
	}
#line 308 "tracker-bus.vala"
	_tmp6_ = reply;
#line 308 "tracker-bus.vala"
	_tmp7_ = g_dbus_message_get_body (_tmp6_);
#line 308 "tracker-bus.vala"
	_tmp8_ = g_variant_get_child_value (_tmp7_, (gsize) 0);
#line 308 "tracker-bus.vala"
	_tmp9_ = _tmp8_;
#line 308 "tracker-bus.vala"
	_tmp10_ = _variant_get2 (_tmp9_, &_tmp10__length1, &_tmp10__length2);
#line 308 "tracker-bus.vala"
	_tmp16_ = _tmp10_;
#line 308 "tracker-bus.vala"
	_tmp16__length1 = _tmp10__length1;
#line 308 "tracker-bus.vala"
	_tmp16__length2 = _tmp10__length2;
#line 308 "tracker-bus.vala"
	_g_variant_unref0 (_tmp9_);
#line 308 "tracker-bus.vala"
	results = _tmp16_;
#line 308 "tracker-bus.vala"
	results_length1 = _tmp16__length1;
#line 308 "tracker-bus.vala"
	results_length2 = _tmp16__length2;
#line 309 "tracker-bus.vala"
	_tmp17_ = g_new0 (TrackerSparqlValueType, 2);
#line 309 "tracker-bus.vala"
	types = _tmp17_;
#line 309 "tracker-bus.vala"
	types_length1 = 2;
#line 309 "tracker-bus.vala"
	_types_size_ = types_length1;
#line 310 "tracker-bus.vala"
	_tmp18_ = g_new0 (gchar*, 2 + 1);
#line 310 "tracker-bus.vala"
	var_names = _tmp18_;
#line 310 "tracker-bus.vala"
	var_names_length1 = 2;
#line 310 "tracker-bus.vala"
	_var_names_size_ = var_names_length1;
#line 312 "tracker-bus.vala"
	_tmp19_ = var_names;
#line 312 "tracker-bus.vala"
	_tmp19__length1 = var_names_length1;
#line 312 "tracker-bus.vala"
	_tmp20_ = g_strdup ("class");
#line 312 "tracker-bus.vala"
	_g_free0 (_tmp19_[0]);
#line 312 "tracker-bus.vala"
	_tmp19_[0] = _tmp20_;
#line 312 "tracker-bus.vala"
	_tmp21_ = _tmp19_[0];
#line 313 "tracker-bus.vala"
	_tmp22_ = var_names;
#line 313 "tracker-bus.vala"
	_tmp22__length1 = var_names_length1;
#line 313 "tracker-bus.vala"
	_tmp23_ = g_strdup ("count");
#line 313 "tracker-bus.vala"
	_g_free0 (_tmp22_[1]);
#line 313 "tracker-bus.vala"
	_tmp22_[1] = _tmp23_;
#line 313 "tracker-bus.vala"
	_tmp24_ = _tmp22_[1];
#line 314 "tracker-bus.vala"
	_tmp25_ = types;
#line 314 "tracker-bus.vala"
	_tmp25__length1 = types_length1;
#line 314 "tracker-bus.vala"
	_tmp25_[0] = TRACKER_SPARQL_VALUE_TYPE_STRING;
#line 314 "tracker-bus.vala"
	_tmp26_ = _tmp25_[0];
#line 315 "tracker-bus.vala"
	_tmp27_ = types;
#line 315 "tracker-bus.vala"
	_tmp27__length1 = types_length1;
#line 315 "tracker-bus.vala"
	_tmp27_[1] = TRACKER_SPARQL_VALUE_TYPE_INTEGER;
#line 315 "tracker-bus.vala"
	_tmp28_ = _tmp27_[1];
#line 317 "tracker-bus.vala"
	_tmp29_ = results;
#line 317 "tracker-bus.vala"
	_tmp29__length1 = results_length1;
#line 317 "tracker-bus.vala"
	_tmp29__length2 = results_length2;
#line 317 "tracker-bus.vala"
	_tmp30_ = _tmp29__length1;
#line 317 "tracker-bus.vala"
	rows = _tmp30_;
#line 318 "tracker-bus.vala"
	_tmp31_ = results;
#line 318 "tracker-bus.vala"
	_tmp31__length1 = results_length1;
#line 318 "tracker-bus.vala"
	_tmp31__length2 = results_length2;
#line 318 "tracker-bus.vala"
	_tmp32_ = _tmp31__length2;
#line 318 "tracker-bus.vala"
	cols = _tmp32_;
#line 319 "tracker-bus.vala"
	_tmp33_ = results;
#line 319 "tracker-bus.vala"
	_tmp33__length1 = results_length1;
#line 319 "tracker-bus.vala"
	_tmp33__length2 = results_length2;
#line 319 "tracker-bus.vala"
	results = NULL;
#line 319 "tracker-bus.vala"
	results_length1 = 0;
#line 319 "tracker-bus.vala"
	results_length2 = 0;
#line 319 "tracker-bus.vala"
	_tmp34_ = rows;
#line 319 "tracker-bus.vala"
	_tmp35_ = cols;
#line 319 "tracker-bus.vala"
	_tmp36_ = var_names;
#line 319 "tracker-bus.vala"
	_tmp36__length1 = var_names_length1;
#line 319 "tracker-bus.vala"
	_tmp37_ = types;
#line 319 "tracker-bus.vala"
	_tmp37__length1 = types_length1;
#line 319 "tracker-bus.vala"
	_tmp38_ = tracker_bus_array_cursor_new (_tmp33_, _tmp33__length1, _tmp33__length2, _tmp34_, _tmp35_, _tmp36_, _tmp36__length1, _tmp37_, _tmp37__length1);
#line 319 "tracker-bus.vala"
	result = (TrackerSparqlCursor*) _tmp38_;
#line 319 "tracker-bus.vala"
	var_names = (_vala_array_free (var_names, var_names_length1, (GDestroyNotify) g_free), NULL);
#line 319 "tracker-bus.vala"
	types = (g_free (types), NULL);
#line 319 "tracker-bus.vala"
	results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
#line 319 "tracker-bus.vala"
	_g_object_unref0 (reply);
#line 319 "tracker-bus.vala"
	_g_object_unref0 (message);
#line 319 "tracker-bus.vala"
	return result;
#line 4278 "tracker-bus.c"
}


static void
tracker_bus_connection_real_statistics_async_data_free (gpointer _data)
{
	TrackerBusConnectionStatisticsAsyncData* _data_;
	_data_ = _data;
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->result);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "tracker-bus.vala"
	g_slice_free (TrackerBusConnectionStatisticsAsyncData, _data_);
#line 4295 "tracker-bus.c"
}


static void
tracker_bus_connection_real_statistics_async (TrackerSparqlConnection* base,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionStatisticsAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	GCancellable* _tmp1_;
#line 20 "tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionStatisticsAsyncData);
#line 20 "tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_statistics_async_data_free);
#line 20 "tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "tracker-bus.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 20 "tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "tracker-bus.vala"
	_data_->cancellable = _tmp1_;
#line 20 "tracker-bus.vala"
	tracker_bus_connection_real_statistics_async_co (_data_);
#line 4329 "tracker-bus.c"
}


static TrackerSparqlCursor*
tracker_bus_connection_real_statistics_finish (TrackerSparqlConnection* base,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	TrackerSparqlCursor* result;
	TrackerBusConnectionStatisticsAsyncData* _data_;
#line 20 "tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "tracker-bus.vala"
		return NULL;
#line 4346 "tracker-bus.c"
	}
#line 20 "tracker-bus.vala"
	result = _data_->result;
#line 20 "tracker-bus.vala"
	_data_->result = NULL;
#line 20 "tracker-bus.vala"
	return result;
#line 4354 "tracker-bus.c"
}


static void
tracker_bus_connection_statistics_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	TrackerBusConnectionStatisticsAsyncData* _data_;
#line 329 "tracker-bus.vala"
	_data_ = _user_data_;
#line 329 "tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 329 "tracker-bus.vala"
	_data_->_res_ = _res_;
#line 329 "tracker-bus.vala"
	tracker_bus_connection_real_statistics_async_co (_data_);
#line 4372 "tracker-bus.c"
}


static gchar**
_variant_get3 (GVariant* value,
               int* result_length1,
               int* result_length2)
{
	gchar** _tmp11_;
	int _tmp11__length;
	int _tmp11__size;
	int _tmp11__length1;
	GVariantIter _tmp12_;
	GVariant* _tmp13_;
	_tmp11_ = g_new (gchar*, 5);
	_tmp11__length = 0;
	_tmp11__size = 4;
	_tmp11__length1 = 0;
#line 332 "tracker-bus.vala"
	g_variant_iter_init (&_tmp12_, value);
#line 332 "tracker-bus.vala"
	for (; (_tmp13_ = g_variant_iter_next_value (&_tmp12_)) != NULL; _tmp11__length1++) {
#line 4395 "tracker-bus.c"
		int _tmp11__length2;
		GVariantIter _tmp14_;
		GVariant* _tmp15_;
		_tmp11__length2 = 0;
#line 332 "tracker-bus.vala"
		g_variant_iter_init (&_tmp14_, _tmp13_);
#line 332 "tracker-bus.vala"
		for (; (_tmp15_ = g_variant_iter_next_value (&_tmp14_)) != NULL; _tmp11__length2++) {
#line 332 "tracker-bus.vala"
			if (_tmp11__size == _tmp11__length) {
#line 332 "tracker-bus.vala"
				_tmp11__size = 2 * _tmp11__size;
#line 332 "tracker-bus.vala"
				_tmp11_ = g_renew (gchar*, _tmp11_, _tmp11__size + 1);
#line 4410 "tracker-bus.c"
			}
#line 332 "tracker-bus.vala"
			_tmp11_[_tmp11__length++] = g_variant_dup_string (_tmp15_, NULL);
#line 332 "tracker-bus.vala"
			g_variant_unref (_tmp15_);
#line 4416 "tracker-bus.c"
		}
#line 332 "tracker-bus.vala"
		*result_length2 = _tmp11__length2;
#line 332 "tracker-bus.vala"
		g_variant_unref (_tmp13_);
#line 4422 "tracker-bus.c"
	}
#line 332 "tracker-bus.vala"
	*result_length1 = _tmp11__length1;
#line 332 "tracker-bus.vala"
	_tmp11_[_tmp11__length] = NULL;
#line 332 "tracker-bus.vala"
	return _tmp11_;
#line 4430 "tracker-bus.c"
}


static gboolean
tracker_bus_connection_real_statistics_async_co (TrackerBusConnectionStatisticsAsyncData* _data_)
{
#line 326 "tracker-bus.vala"
	switch (_data_->_state_) {
#line 326 "tracker-bus.vala"
		case 0:
#line 4441 "tracker-bus.c"
		goto _state_0;
#line 326 "tracker-bus.vala"
		case 1:
#line 4445 "tracker-bus.c"
		goto _state_1;
		default:
#line 326 "tracker-bus.vala"
		g_assert_not_reached ();
#line 4450 "tracker-bus.c"
	}
	_state_0:
#line 327 "tracker-bus.vala"
	_data_->_tmp0_ = _data_->self->priv->dbus_name;
#line 327 "tracker-bus.vala"
	_data_->_tmp1_ = g_dbus_message_new_method_call (_data_->_tmp0_, TRACKER_DBUS_OBJECT_STATISTICS, TRACKER_DBUS_INTERFACE_STATISTICS, "Get");
#line 327 "tracker-bus.vala"
	_data_->message = _data_->_tmp1_;
#line 329 "tracker-bus.vala"
	_data_->_tmp2_ = _data_->self->priv->bus;
#line 329 "tracker-bus.vala"
	_data_->_tmp3_ = _data_->message;
#line 329 "tracker-bus.vala"
	_data_->_state_ = 1;
#line 329 "tracker-bus.vala"
	g_dbus_connection_send_message_with_reply (_data_->_tmp2_, _data_->_tmp3_, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, _data_->cancellable, tracker_bus_connection_statistics_async_ready, _data_);
#line 329 "tracker-bus.vala"
	return FALSE;
#line 4469 "tracker-bus.c"
	_state_1:
#line 329 "tracker-bus.vala"
	_data_->_tmp4_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
#line 329 "tracker-bus.vala"
	_data_->reply = _data_->_tmp4_;
#line 329 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 329 "tracker-bus.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 329 "tracker-bus.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 329 "tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 329 "tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 329 "tracker-bus.vala"
			return FALSE;
#line 4487 "tracker-bus.c"
		} else {
#line 329 "tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 329 "tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 329 "tracker-bus.vala"
			g_clear_error (&_data_->_inner_error_);
#line 329 "tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 329 "tracker-bus.vala"
			return FALSE;
#line 4499 "tracker-bus.c"
		}
	}
#line 330 "tracker-bus.vala"
	_data_->_tmp5_ = _data_->reply;
#line 330 "tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->self, _data_->_tmp5_, &_data_->_inner_error_);
#line 330 "tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 330 "tracker-bus.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 330 "tracker-bus.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 330 "tracker-bus.vala"
			_g_object_unref0 (_data_->reply);
#line 330 "tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 330 "tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 330 "tracker-bus.vala"
			return FALSE;
#line 4520 "tracker-bus.c"
		} else {
#line 330 "tracker-bus.vala"
			_g_object_unref0 (_data_->reply);
#line 330 "tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 330 "tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 330 "tracker-bus.vala"
			g_clear_error (&_data_->_inner_error_);
#line 330 "tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 330 "tracker-bus.vala"
			return FALSE;
#line 4534 "tracker-bus.c"
		}
	}
#line 332 "tracker-bus.vala"
	_data_->_tmp6_ = _data_->reply;
#line 332 "tracker-bus.vala"
	_data_->_tmp7_ = g_dbus_message_get_body (_data_->_tmp6_);
#line 332 "tracker-bus.vala"
	_data_->_tmp8_ = g_variant_get_child_value (_data_->_tmp7_, (gsize) 0);
#line 332 "tracker-bus.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 332 "tracker-bus.vala"
	_data_->_tmp10_ = _variant_get3 (_data_->_tmp9_, &_data_->_tmp10__length1, &_data_->_tmp10__length2);
#line 332 "tracker-bus.vala"
	_data_->_tmp16_ = _data_->_tmp10_;
#line 332 "tracker-bus.vala"
	_data_->_tmp16__length1 = _data_->_tmp10__length1;
#line 332 "tracker-bus.vala"
	_data_->_tmp16__length2 = _data_->_tmp10__length2;
#line 332 "tracker-bus.vala"
	_g_variant_unref0 (_data_->_tmp9_);
#line 332 "tracker-bus.vala"
	_data_->results = _data_->_tmp16_;
#line 332 "tracker-bus.vala"
	_data_->results_length1 = _data_->_tmp16__length1;
#line 332 "tracker-bus.vala"
	_data_->results_length2 = _data_->_tmp16__length2;
#line 333 "tracker-bus.vala"
	_data_->_tmp17_ = g_new0 (TrackerSparqlValueType, 2);
#line 333 "tracker-bus.vala"
	_data_->types = _data_->_tmp17_;
#line 333 "tracker-bus.vala"
	_data_->types_length1 = 2;
#line 333 "tracker-bus.vala"
	_data_->_types_size_ = _data_->types_length1;
#line 334 "tracker-bus.vala"
	_data_->_tmp18_ = g_new0 (gchar*, 2 + 1);
#line 334 "tracker-bus.vala"
	_data_->var_names = _data_->_tmp18_;
#line 334 "tracker-bus.vala"
	_data_->var_names_length1 = 2;
#line 334 "tracker-bus.vala"
	_data_->_var_names_size_ = _data_->var_names_length1;
#line 336 "tracker-bus.vala"
	_data_->_tmp19_ = _data_->var_names;
#line 336 "tracker-bus.vala"
	_data_->_tmp19__length1 = _data_->var_names_length1;
#line 336 "tracker-bus.vala"
	_data_->_tmp20_ = g_strdup ("class");
#line 336 "tracker-bus.vala"
	_g_free0 (_data_->_tmp19_[0]);
#line 336 "tracker-bus.vala"
	_data_->_tmp19_[0] = _data_->_tmp20_;
#line 336 "tracker-bus.vala"
	_data_->_tmp21_ = _data_->_tmp19_[0];
#line 337 "tracker-bus.vala"
	_data_->_tmp22_ = _data_->var_names;
#line 337 "tracker-bus.vala"
	_data_->_tmp22__length1 = _data_->var_names_length1;
#line 337 "tracker-bus.vala"
	_data_->_tmp23_ = g_strdup ("count");
#line 337 "tracker-bus.vala"
	_g_free0 (_data_->_tmp22_[1]);
#line 337 "tracker-bus.vala"
	_data_->_tmp22_[1] = _data_->_tmp23_;
#line 337 "tracker-bus.vala"
	_data_->_tmp24_ = _data_->_tmp22_[1];
#line 338 "tracker-bus.vala"
	_data_->_tmp25_ = _data_->types;
#line 338 "tracker-bus.vala"
	_data_->_tmp25__length1 = _data_->types_length1;
#line 338 "tracker-bus.vala"
	_data_->_tmp25_[0] = TRACKER_SPARQL_VALUE_TYPE_STRING;
#line 338 "tracker-bus.vala"
	_data_->_tmp26_ = _data_->_tmp25_[0];
#line 339 "tracker-bus.vala"
	_data_->_tmp27_ = _data_->types;
#line 339 "tracker-bus.vala"
	_data_->_tmp27__length1 = _data_->types_length1;
#line 339 "tracker-bus.vala"
	_data_->_tmp27_[1] = TRACKER_SPARQL_VALUE_TYPE_INTEGER;
#line 339 "tracker-bus.vala"
	_data_->_tmp28_ = _data_->_tmp27_[1];
#line 341 "tracker-bus.vala"
	_data_->_tmp29_ = _data_->results;
#line 341 "tracker-bus.vala"
	_data_->_tmp29__length1 = _data_->results_length1;
#line 341 "tracker-bus.vala"
	_data_->_tmp29__length2 = _data_->results_length2;
#line 341 "tracker-bus.vala"
	_data_->_tmp30_ = _data_->_tmp29__length1;
#line 341 "tracker-bus.vala"
	_data_->rows = _data_->_tmp30_;
#line 342 "tracker-bus.vala"
	_data_->_tmp31_ = _data_->results;
#line 342 "tracker-bus.vala"
	_data_->_tmp31__length1 = _data_->results_length1;
#line 342 "tracker-bus.vala"
	_data_->_tmp31__length2 = _data_->results_length2;
#line 342 "tracker-bus.vala"
	_data_->_tmp32_ = _data_->_tmp31__length2;
#line 342 "tracker-bus.vala"
	_data_->cols = _data_->_tmp32_;
#line 343 "tracker-bus.vala"
	_data_->_tmp33_ = _data_->results;
#line 343 "tracker-bus.vala"
	_data_->_tmp33__length1 = _data_->results_length1;
#line 343 "tracker-bus.vala"
	_data_->_tmp33__length2 = _data_->results_length2;
#line 343 "tracker-bus.vala"
	_data_->results = NULL;
#line 343 "tracker-bus.vala"
	_data_->results_length1 = 0;
#line 343 "tracker-bus.vala"
	_data_->results_length2 = 0;
#line 343 "tracker-bus.vala"
	_data_->_tmp34_ = _data_->rows;
#line 343 "tracker-bus.vala"
	_data_->_tmp35_ = _data_->cols;
#line 343 "tracker-bus.vala"
	_data_->_tmp36_ = _data_->var_names;
#line 343 "tracker-bus.vala"
	_data_->_tmp36__length1 = _data_->var_names_length1;
#line 343 "tracker-bus.vala"
	_data_->_tmp37_ = _data_->types;
#line 343 "tracker-bus.vala"
	_data_->_tmp37__length1 = _data_->types_length1;
#line 343 "tracker-bus.vala"
	_data_->_tmp38_ = tracker_bus_array_cursor_new (_data_->_tmp33_, _data_->_tmp33__length1, _data_->_tmp33__length2, _data_->_tmp34_, _data_->_tmp35_, _data_->_tmp36_, _data_->_tmp36__length1, _data_->_tmp37_, _data_->_tmp37__length1);
#line 343 "tracker-bus.vala"
	_data_->result = (TrackerSparqlCursor*) _data_->_tmp38_;
#line 343 "tracker-bus.vala"
	_data_->var_names = (_vala_array_free (_data_->var_names, _data_->var_names_length1, (GDestroyNotify) g_free), NULL);
#line 343 "tracker-bus.vala"
	_data_->types = (g_free (_data_->types), NULL);
#line 343 "tracker-bus.vala"
	_data_->results = (_vala_array_free (_data_->results, _data_->results_length1 * _data_->results_length2, (GDestroyNotify) g_free), NULL);
#line 343 "tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 343 "tracker-bus.vala"
	_g_object_unref0 (_data_->message);
#line 343 "tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 343 "tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 343 "tracker-bus.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 343 "tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4683 "tracker-bus.c"
		}
	}
#line 343 "tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 343 "tracker-bus.vala"
	return FALSE;
#line 4690 "tracker-bus.c"
}


static void
tracker_bus_connection_class_init (TrackerBusConnectionClass * klass)
{
#line 20 "tracker-bus.vala"
	tracker_bus_connection_parent_class = g_type_class_peek_parent (klass);
#line 20 "tracker-bus.vala"
	g_type_class_adjust_private_offset (klass, &TrackerBusConnection_private_offset);
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GError**)) tracker_bus_connection_real_query;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->query_async = (void (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_query_async;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->query_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_bus_connection_real_query_finish;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GError**)) tracker_bus_connection_real_update;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_async = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_update_async;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_finish = (void (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_bus_connection_real_update_finish;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_async = (void (*) (TrackerSparqlConnection *, gchar**, int, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_update_array_async;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_finish = (GPtrArray* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_bus_connection_real_update_array_finish;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank = (GVariant* (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GError**)) tracker_bus_connection_real_update_blank;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_async = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_update_blank_async;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_finish = (GVariant* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_bus_connection_real_update_blank_finish;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->load = (void (*) (TrackerSparqlConnection *, GFile*, GCancellable*, GError**)) tracker_bus_connection_real_load;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->load_async = (void (*) (TrackerSparqlConnection *, GFile*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_load_async;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->load_finish = (void (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_bus_connection_real_load_finish;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GCancellable*, GError**)) tracker_bus_connection_real_statistics;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_async = (void (*) (TrackerSparqlConnection *, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_statistics_async;
#line 20 "tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_bus_connection_real_statistics_finish;
#line 20 "tracker-bus.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_bus_connection_finalize;
#line 4737 "tracker-bus.c"
}


static void
tracker_bus_connection_instance_init (TrackerBusConnection * self)
{
#line 20 "tracker-bus.vala"
	self->priv = tracker_bus_connection_get_instance_private (self);
#line 4746 "tracker-bus.c"
}


static void
tracker_bus_connection_finalize (GObject * obj)
{
	TrackerBusConnection * self;
#line 20 "tracker-bus.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnection);
#line 21 "tracker-bus.vala"
	_g_object_unref0 (self->priv->bus);
#line 22 "tracker-bus.vala"
	_g_free0 (self->priv->dbus_name);
#line 20 "tracker-bus.vala"
	G_OBJECT_CLASS (tracker_bus_connection_parent_class)->finalize (obj);
#line 4762 "tracker-bus.c"
}


GType
tracker_bus_connection_get_type (void)
{
	static volatile gsize tracker_bus_connection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_bus_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerBusConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_bus_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerBusConnection), 0, (GInstanceInitFunc) tracker_bus_connection_instance_init, NULL };
		GType tracker_bus_connection_type_id;
		tracker_bus_connection_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerBusConnection", &g_define_type_info, 0);
		TrackerBusConnection_private_offset = g_type_add_instance_private (tracker_bus_connection_type_id, sizeof (TrackerBusConnectionPrivate));
		g_once_init_leave (&tracker_bus_connection_type_id__volatile, tracker_bus_connection_type_id);
	}
	return tracker_bus_connection_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



