\name{hbk}
\alias{hbk}
\docType{data}
\title{Hawkins, Bradu, Kass's Artificial Data}
\description{
  Artificial Data Set generated by Hawkins, Bradu, and Kass (1984).  The
  data set consists of 75 observations in four dimensions (one response
  and three explanatory variables).  It provides a good example of the
  masking effect.  The first 14 observations are outliers, created in
  two groups: 1--10 and 11--14.
  Only observations 12, 13 and 14 appear as outliers when using
  classical methods, but can be easily unmasked using robust
  distances computed by, e.g., MCD - covMcd().
}
\usage{data(hbk, package="robustbase")}
\format{
  A data frame with 75 observations on 4 variables, where the last
  variable is the dependent one.
  \describe{
    \item{X1}{x[,1]}
    \item{X2}{x[,2]}
    \item{X3}{x[,3]}
    \item{Y}{y}
  }
}
\note{
  This data set is also available in package \pkg{wle} as
  \code{artificial}.
}
\source{
  Hawkins, D.M., Bradu, D., and Kass, G.V. (1984)
  Location of several outliers in multiple regression data using
  elemental sets.
  \emph{Technometrics} \bold{26}, 197--208.

  P. J. Rousseeuw and A. M. Leroy (1987)
  \emph{Robust Regression and Outlier Detection};
  Wiley, p.94.
}
\examples{
data(hbk)
plot(hbk)
summary(lm.hbk <- lm(Y ~ ., data = hbk))

hbk.x <- data.matrix(hbk[, 1:3])
(cHBK <- covMcd(hbk.x))
}
\keyword{datasets}
