/** @file
	Parser: sql driver manager decl.

	Copyright (c) 2001-2015 Art. Lebedev Studio (http://www.artlebedev.com)
	Author: Alexandr Petrosian <paf@design.ru> (http://paf.design.ru)


	global sql driver manager, must be thread-safe
*/

#ifndef PA_CHARSETS_H
#define PA_CHARSETS_H

#define IDENT_PA_CHARSETS_H "$Id: pa_charsets.h,v 1.17 2015/10/26 01:21:55 moko Exp $"

#include "pa_hash.h"
#include "pa_charset.h"

/// convention: use UPPERCASE keys
class Charsets: public HashString<Charset*> {
public:

	Charsets();

	Charset& get(const String::Body ANAME);

	void load_charset(Request_charsets& charsets, const String::Body ANAME, const String& afile_spec);

	// detects charset if it's not enforced, skips BOM signature if it complies charset
	static Charset* checkBOM(char *&body,size_t &body_size, Charset* enforced_charset);
};

//@{ globals
extern Charset UTF8_charset;
extern Charsets charsets;
//@}

#endif
