/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include "../nb_global.h"
#include "nb_ui_interface_callbacks.h"
#include "nb_ui_treeview.h"

void
nb_ui_cb_on_new_clicked (GtkWidget * widget, gpointer user_data)
{
	 extern Global * g;
	 nb_global_new_note (g);
}

void
nb_ui_cb_on_save_clicked (GtkWidget * widget, gpointer user_data)
{
	 extern Global * g;
	 nb_global_update_note (g);
}

void
nb_ui_cb_on_attach_clicked (GtkWidget * widget, gpointer user_data)
{
	extern Global * g;
	nb_ui_attachment_view_select_files ();
}

void
nb_ui_cb_on_delete_clicked (GtkWidget * widget, gpointer user_data)
{
	 extern Global * g;
	 nb_global_delete_note (g);
}

void
nb_ui_cb_on_import_clicked (GtkWidget * widget, gpointer user_data)
{
	nb_ui_dialog_import ();
}

void
nb_ui_cb_on_export_clicked (GtkWidget * widget, gpointer user_data)
{
	nb_ui_dialog_export ();
}

void
nb_ui_cb_on_about_clicked (GtkWidget * widget, gpointer user_data)
{
	nb_ui_about_dialog_create ();
}

gboolean
nb_ui_cb_on_quit_clicked (GtkWidget * widget, gpointer user_data)
{
	extern Global * g;

	if ( !nb_global_quit (g) )
		return;

	/* FIXME: resize is buggy
	 * nb_ui_store_interface_positions (); */

	gtk_main_quit ();

	return TRUE;
}

void
nb_ui_cb_on_option_menu_type_note_clicked (GtkWidget * widget, gpointer user_data)
{
	extern Global * g;
	nb_note_set_type (g->current_note, NOTE);
	g->modified_note = EDITED;
}

void
nb_ui_cb_on_option_menu_type_personal_clicked (GtkWidget * widget, gpointer user_data)
{
	extern Global * g;
	nb_note_set_type (g->current_note, PERSONAL);
	g->modified_note = EDITED;
}

void
nb_ui_cb_on_option_menu_type_problem_clicked (GtkWidget * widget, gpointer user_data)
{
	extern Global * g;
	nb_note_set_type (g->current_note, PROBLEM);
	g->modified_note = EDITED;
}

void
nb_ui_cb_on_option_menu_type_tipntrick_clicked (GtkWidget * widget, gpointer user_data)
{
	extern Global * g;
	nb_note_set_type (g->current_note, TIPNTRICK);
	g->modified_note = EDITED;
}

void
nb_ui_cb_on_option_menu_type_bookmark_clicked (GtkWidget * widget, gpointer user_data)
{
	extern Global * g;
	nb_note_set_type (g->current_note, BOOKMARK);
	g->modified_note = EDITED;
}

void
nb_ui_cb_on_option_menu_status_none_clicked (GtkWidget * widget, gpointer user_data)
{
	extern Global * g;
	nb_note_set_status (g->current_note, NONE);
	g->modified_note = EDITED;
}

void
nb_ui_cb_on_option_menu_status_open_clicked (GtkWidget * widget, gpointer user_data)
{
	extern Global * g;
	nb_note_set_status (g->current_note, OPEN);
	g->modified_note = EDITED;
}

void
nb_ui_cb_on_option_menu_status_solved_clicked (GtkWidget * widget, gpointer user_data)
{
	extern Global * g;
	nb_note_set_status (g->current_note, SOLVED);
	g->modified_note = EDITED;
}

void
nb_ui_cb_on_show_hide_attachment_clicked (GtkWidget * widget, gpointer user_data)
{
	nb_ui_attachment_view_icon_list_show_hide ();
}

void
nb_ui_cb_on_note_edited (GtkWidget * widget, gpointer user_data)
{
	extern Global * g;
	g->modified_note = EDITED;
}

void
nb_ui_cb_on_search_edited (GtkWidget * widget, gpointer user_data)
{
	nb_ui_treeview_update ((gchar *) gtk_entry_get_text ( GTK_ENTRY (widget)));
}

void
nb_ui_cb_on_clear_search_clicked (GtkWidget * widget, gpointer user_data)
{
	extern GladeXML * xml;
	GtkWidget * entryfind = glade_xml_get_widget (xml, "entryfind");

	gtk_entry_set_text ( GTK_ENTRY (entryfind), "");
}

void
nb_ui_cb_on_export_validate (GtkWidget * widget, gpointer user_data)
{
	extern GladeXML * xmlexport;
	extern Global * g;
	GtkWidget * exportdialog, * filechooser;
	GtkWidget * check_export_note, * check_export_personal, * check_export_problem, * check_export_trick, * check_export_bookmark;
	ExportType etype;

	exportdialog = glade_xml_get_widget (xmlexport, "exportdialog");
	filechooser = glade_xml_get_widget (xmlexport, "filechooser");
	check_export_note = glade_xml_get_widget (xmlexport, "check_export_note");
	check_export_personal = glade_xml_get_widget (xmlexport, "check_export_personal");
	check_export_problem = glade_xml_get_widget (xmlexport, "check_export_problem");
	check_export_trick = glade_xml_get_widget (xmlexport, "check_export_trick");
	check_export_bookmark = glade_xml_get_widget (xmlexport, "check_export_bookmark");

	/* get the toggle buttons status */
	etype.note = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (check_export_note));
	etype.personal = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (check_export_personal));
	etype.problem = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (check_export_problem));
	etype.trick = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (check_export_trick));
	etype.bookmark = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (check_export_bookmark));

	nb_global_export_note_list (g, &etype, gtk_file_chooser_get_filename ( GTK_FILE_CHOOSER (filechooser)));

	gtk_widget_destroy (exportdialog);
}
