/*
 * Validity VFS0050 driver for libfprint
 * Copyright (C) 2015-2016 Konstantin Semenov <zemen17@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* Timeout for all send/recv operations, except interrupt waiting and abort */
#define VFS_USB_TIMEOUT 100
/* Timeout for usb abort */
#define VFS_USB_ABORT_TIMEOUT 20
/* Default timeout for SSM timers */
#define VFS_SSM_TIMEOUT 100
/* Timeout for orange light */
#define VFS_SSM_ORANGE_TIMEOUT 400
/* Buffer size for abort and fprint receiving */
#define VFS_USB_BUFFER_SIZE 65536

/* Line size from scanner including metainformation: line number, narrow stripe from the center, etc */
#define VFS_LINE_SIZE 148
/* Width of narrow stripe from the center */
#define VFS_NEXT_LINE_WIDTH 32
/* Image width from scanner */
#define VFS_IMAGE_WIDTH 100
/* Maximum image height after assembling */
#define VFS_MAX_HEIGHT 3000

/* Size of control packets: turn_on, turn_off, next_receive_*  */
#define VFS_CONTROL_PACKET_SIZE 125
/* Size of result of commit */
#define VFS_COMMIT_RESPONSE_SIZE 1106
/* Size of interrupt from EP3 */
#define VFS_INTERRUPT_SIZE 5
/* EP3 endpoint */
#define EP3_IN 0x83

/* Fingerprint horizontal line */
struct vfs_line {
	/* It must be always 0x01 */
	unsigned char _0x01;
	/* It must be always 0xfe */
	unsigned char _0xfe;

	/* line number starting from some number in Little-Endian */
	unsigned short id;

	/* Some hashes which are useful to detect noise */
	unsigned char noise_hash_1;
	unsigned char noise_hash_2;

	/* The first byte of _somedata is always 0x00, the second is strange useless cyclic line number */
	unsigned short _somedata;

	/* Fingerprint image */
	unsigned char data[VFS_IMAGE_WIDTH];

	/* Narrow fingerprint part from the center used for variable speed lines assembling */
	unsigned char next_line_part[VFS_NEXT_LINE_WIDTH];

	/* scan_data is 0xfb except some rare cases, it's skipped */
	unsigned char scan_data[8];
} __attribute__ ((__packed__));

/* The main driver structure */
struct vfs_dev_t {
	/* One if we were asked to read fingerprint, zero otherwise */
	char active;

	/* Control packet parameter for send_control_packet */
	unsigned char *control_packet;

	/* For dev_deactivate to check whether ssm still running or not */
	char ssm_active;

	/* Current async transfer */
	struct libusb_transfer *transfer;

	/* Should we call fpi_imgdev_activate_complete or fpi_imgdev_deactivate_complete */
	char need_report;

	/* Should we wait more for interrupt */
	char wait_interrupt;

	/* Received fingerprint raw lines */
	struct vfs_line *lines_buffer;

	/* Current number of received bytes and current memory used by data */
	int bytes, memory;

	/* USB buffer for fingerprint */
	char *usb_buffer;

	/* Received interrupt data */
	unsigned char interrupt[8];
};

/* SSM states for clear_ep2 */
enum SUBSM1 {
	SUBSM1_COMMAND_04,
	SUBSM1_RETURN_CODE,
	SUBSM1_ABORT_2,

	SUBSM1_STATES,
};

/* SSM states for control */
enum SUBSM2 {
	SUBSM2_SEND_CONTROL,
	SUBSM2_RETURN_CODE,	/* If next_receive, send another control packet */

	SUBSM2_SEND_COMMIT,
	SUBSM2_COMMIT_RESPONSE,
	SUBSM2_READ_EMPTY_INTERRUPT,
	SUBSM2_ABORT_3,
	SUBSM2_CLEAR_EP2,

	SUBSM2_STATES,
};

/* SSM states for activate_ssm */
enum SSM_STATE {
	SSM_INITIAL_ABORT_1,
	SSM_INITIAL_ABORT_2,
	SSM_INITIAL_ABORT_3,
	SSM_CLEAR_EP2,
	SSM_TURN_OFF,

	/* Here the device is turned off; if not active, complete ssm */
	SSM_TURN_ON,

	SSM_ASK_INTERRUPT,
	SSM_WAIT_INTERRUPT,

	SSM_RECEIVE_FINGER,
	SSM_SUBMIT_IMAGE,

	/* If not active, jump to CLEAR_EP2 */
	SSM_NEXT_RECEIVE,
	SSM_WAIT_ANOTHER_SCAN,
	/* Jump to TURN_ON */

	SSM_STATES
};

/* Blocks of data from USB sniffer */

/* Turns on the light */
static unsigned char turn_on[] = {
	0x39, 0x20, 0xBF, 0x02, 0x00, 0xF4, 0x01, 0x00, 0x00, 0x01, 0xD1, 0x00,
	0x20, 0xD1, 0xD1, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF4, 0x01, 0x00,
	0x00, 0x01, 0x00, 0x00,
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xF4, 0x01, 0x00,
	0x00, 0x02, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0xF4, 0x01, 0x00, 0x00, 0x02, 0xD1, 0x00, 0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00,
};

/* Power off */
static unsigned char turn_off[] = {
	0x39, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00,
};

/* Turns on orange light */
static unsigned char next_receive_1[] = {
	0x39, 0xB8, 0x0B, 0x00, 0x00, 0xB8, 0x0B, 0x00, 0x00, 0x01, 0xD1, 0x00,
	0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xD1, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00,
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0xB8, 0x0B, 0x00, 0x00, 0x02, 0xD1, 0x00, 0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00,
};

/* Packet directly after next_receive_1 */
static unsigned char next_receive_2[] = {
	0x39, 0xE8, 0x03, 0x00, 0x00, 0xE8, 0x03, 0x00, 0x00, 0x01, 0xD1, 0x00,
	0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xD1, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00,
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0xE8, 0x03, 0x00, 0x00, 0x02, 0xD1, 0x00, 0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00,
};

/* Commit message */
static unsigned char commit_out[] = {
	0x02, 0x94, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0x2C, 0x03, 0x00,
	0x30, 0x1B, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x08, 0x00, 0x20, 0x03, 0x00, 0x30, 0x3D, 0x10, 0x00,
	0x00, 0x20, 0x00, 0x08,
	0x00, 0x18, 0x03, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08,
	0x00, 0x24, 0x03, 0x00,
	0x30, 0x08, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0x28, 0x03, 0x00,
	0x30, 0x08, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x08, 0x00, 0x30, 0x03, 0x00, 0x30, 0x00, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x08,
	0x00, 0x38, 0x03, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08,
	0x00, 0x3C, 0x03, 0x00,
	0x30, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0x44, 0x03, 0x00,
	0x30, 0x14, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x08, 0x00, 0x48, 0x03, 0x00, 0x30, 0x01, 0x04, 0x02,
	0x00, 0x20, 0x00, 0x08,
	0x00, 0x4C, 0x03, 0x00, 0x30, 0x01, 0x0C, 0x02, 0x00, 0x20, 0x00, 0x08,
	0x00, 0x54, 0x03, 0x00,
	0x30, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0x5C, 0x03, 0x00,
	0x30, 0x90, 0x01, 0x02,
	0x00, 0x20, 0x00, 0x08, 0x00, 0x60, 0x03, 0x00, 0x30, 0x2C, 0x01, 0x19,
	0x00, 0x20, 0x00, 0x08,
	0x00, 0x64, 0x03, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08,
	0x00, 0x6C, 0x03, 0x00,
	0x30, 0x1E, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0x70, 0x03, 0x00,
	0x30, 0x21, 0x80, 0x00,
	0x00, 0x20, 0x00, 0x08, 0x00, 0x78, 0x03, 0x00, 0x30, 0x09, 0x00, 0x02,
	0x00, 0x20, 0x00, 0x08,
	0x00, 0x7C, 0x03, 0x00, 0x30, 0x0B, 0x00, 0x19, 0x00, 0x20, 0x00, 0x08,
	0x00, 0x80, 0x03, 0x00,
	0x30, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0x84, 0x03, 0x00,
	0x30, 0x3A, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x08, 0x00, 0x88, 0x03, 0x00, 0x30, 0x14, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x08,
	0x00, 0x8C, 0x03, 0x00, 0x30, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08,
	0x00, 0x90, 0x03, 0x00,
	0x30, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0x94, 0x03, 0x00,
	0x30, 0x08, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x08, 0x00, 0x98, 0x03, 0x00, 0x30, 0x00, 0x00, 0xA1,
	0x01, 0x20, 0x00, 0x08,
	0x00, 0x9C, 0x03, 0x00, 0x30, 0x00, 0x00, 0xA1, 0x01, 0x20, 0x00, 0x08,
	0x00, 0xA8, 0x03, 0x00,
	0x30, 0x64, 0x01, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0xAC, 0x03, 0x00,
	0x30, 0x64, 0x01, 0x00,
	0x00, 0x20, 0x00, 0x08, 0x00, 0xB0, 0x03, 0x00, 0x30, 0x00, 0x01, 0x00,
	0x00, 0x20, 0x00, 0x08,
	0x00, 0xB4, 0x03, 0x00, 0x30, 0x00, 0x01, 0x00, 0x00, 0x20, 0x00, 0x08,
	0x00, 0xB8, 0x03, 0x00,
	0x30, 0x05, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0xBC, 0x03, 0x00,
	0x30, 0x05, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x08, 0x00, 0xC0, 0x03, 0x00, 0x30, 0x00, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x08,
	0x00, 0x84, 0x03, 0x00, 0x30, 0x3B, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08,
	0x00, 0x08, 0x07, 0x00,
	0x30, 0x03, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0x0C, 0x07, 0x00,
	0x30, 0x00, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x08, 0x00, 0x14, 0x07, 0x00, 0x30, 0x20, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x08,
	0x00, 0x1C, 0x07, 0x00, 0x30, 0x1A, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08,
	0x00, 0x70, 0x0D, 0x00,
	0x30, 0x01, 0x00, 0x00, 0x00, 0x25, 0x00, 0x28, 0x00, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x00, 0x90, 0x00, 0x00, 0x00, 0x2B, 0xFF, 0x2B, 0xFF, 0x2B,
	0xED, 0x00, 0x00, 0x2B,
	0xFB, 0x00, 0x00, 0x2B, 0xC5, 0x00, 0x00, 0x2B, 0x05, 0x80, 0x70, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x24, 0xD3, 0x2E, 0xC0, 0x2C, 0x3B, 0x08, 0xF0, 0x3B, 0x09, 0x24,
	0xBB, 0x3B, 0x0B, 0x24,
	0xAA, 0x3B, 0x1F, 0xF8, 0x00, 0x3B, 0x3F, 0xF0, 0x00, 0x3B, 0x35, 0xC0,
	0x00, 0x38, 0x80, 0x2C,
	0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x38, 0x80, 0x2C, 0x70, 0x00,
	0x00, 0x00, 0x00, 0xC0,
	0x3A, 0x80, 0x2C, 0x70, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3B, 0x0A, 0x80,
	0x2E, 0x83, 0x24, 0xDB,
	0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0xC3, 0x2C, 0x31, 0x83, 0x2C, 0x70,
	0x00, 0x00, 0x00, 0x00,
	0xCB, 0x33, 0x1B, 0x83, 0x2C, 0x70, 0x00, 0x00, 0x00, 0x00, 0xCB, 0x31,
	0x83, 0x2C, 0x70, 0x00,
	0x00, 0x00, 0x00, 0xCB, 0x00, 0x33, 0x1E, 0x83, 0x2E, 0x25, 0xFF, 0xC4,
	0x00, 0x2F, 0x06, 0x84,
	0x2E, 0x00, 0x00, 0x10, 0x20, 0x29, 0x00, 0x04, 0x00, 0x10, 0x00, 0x00,
	0x00, 0x23, 0x00, 0x00,
	0x00, 0x21, 0x00, 0x10, 0x00, 0x48, 0x03, 0x00, 0x30, 0xFF, 0xF0, 0xFF,
	0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x00, 0x00, 0x21, 0x00, 0x10, 0x00, 0x4C, 0x03, 0x00,
	0x30, 0xFF, 0xF0, 0xFF,
	0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x21, 0x00, 0x10,
	0x00, 0x20, 0x03, 0x00,
	0x30, 0x7F, 0x00, 0xFC, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x80, 0x10, 0x00,
	0x00, 0x20, 0x00, 0x08,
	0x00, 0x24, 0x03, 0x00, 0x30, 0x08, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08,
	0x00, 0x1C, 0x07, 0x00,
	0x30, 0x1A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x10, 0x00, 0x20, 0x03, 0x00,
	0x30, 0xC3, 0xFF, 0xFF,
	0xFF, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08,
	0x00, 0x80, 0x03, 0x00,
	0x30, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x84, 0x00, 0x31, 0x65, 0x77,
	0x77, 0x77, 0x78, 0x88,
	0x77, 0x77, 0x76, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x77, 0x67,
	0x66, 0x66, 0x66, 0x66,
	0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x76, 0x67, 0x66, 0x66, 0x66, 0x66,
	0x66, 0x77, 0x66, 0x66,
	0x66, 0x66, 0x67, 0x66, 0x66, 0x66, 0x66, 0x66, 0x76, 0x76, 0x66, 0x56,
	0x66, 0x66, 0x56, 0x55,
	0x65, 0x66, 0x66, 0x66, 0x65, 0x66, 0x66, 0x55, 0x66, 0x66, 0x65, 0x66,
	0x76, 0x76, 0x77, 0x77,
	0x66, 0x66, 0x66, 0x76, 0x67, 0x66, 0x77, 0x67, 0x66, 0x66, 0x66, 0x56,
	0x65, 0x66, 0x65, 0x66,
	0x66, 0x55, 0x55, 0x54, 0x55, 0x65, 0x66, 0x66, 0x66, 0x76, 0x77, 0x87,
	0x88, 0x77, 0x66, 0x66,
	0x66, 0x66, 0x66, 0x66, 0x66, 0x65, 0x66, 0x55, 0x55, 0x65, 0x56, 0x55,
	0x55, 0x55, 0x54, 0x45,
	0x54, 0x55, 0x55, 0x55, 0x66, 0x66, 0x66, 0x66, 0x66, 0x77, 0x77, 0x77,
	0x66, 0x26, 0x00, 0x28,
	0x00, 0xFF, 0x00, 0x0F, 0x00, 0xF0, 0xF0, 0x0F, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x30, 0x01, 0x02,
	0x00, 0x2C, 0x01, 0x28, 0x00, 0x20, 0x80, 0x00, 0x00, 0x0A, 0x00, 0x02,
	0x00, 0x0B, 0x00, 0x19,
	0x00, 0x40, 0x1F, 0x10, 0x27, 0x00, 0x0F, 0x03, 0x00,
};

/* Known interrupts */

static unsigned char empty_interrupt[] = {
	0x00, 0x00, 0x00, 0x00, 0x00,
};

static unsigned char interrupt1[] = {
	0x02, 0x00, 0x0E, 0x00, 0xF0,
};

static unsigned char interrupt2[] = {
	0x02, 0x04, 0x0A, 0x00, 0xF0,
};

static unsigned char interrupt3[] = {
	0x02, 0x00, 0x0A, 0x00, 0xF0,
};
