import os



odl_string = '''
module Test {
  class BigBlob {
    attribute blob data;
  };
};
'''


DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

import sys, test_util
from Ft.Ods import Database
from Ft.Ods.StorageManager.Adapters import Constants

def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('Test'):
            from distutils import dir_util
            dir_util.remove_tree('Test')


def _Test(tester):

    tester.startGroup("Blob Attributes %s Driver" % tester.test_data['driver'])

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        from Test import BigBlob
        reload(BigBlob)
    except:
        tester.error('Error in syntax', 1)


    tester.testDone()


    db = Database.Database()
    db.open(DBNAME)
    try:
        tx = db.new()
        tx.begin()

        tester.startTest("Create and Commit")

        b = BigBlob.new(db)
        tx.commit()

        id = b._4ods_getOid()

        tester.testDone()


        tx = db.new()
        tx.begin()

        tester.startTest("Access empty")

        b = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,id)

        tester.compare("", b.data, "Invalid Empty blob attribute")
        tx.commit()
        tester.testDone()

        tx = db.new()
        tx.begin()

        tester.startTest("Set and access")
        b = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,id)
        b.data = "*"*10000
        tester.compare(10000, len(b.data), "Invalid blob attribute")
        tester.compare("*"*10000, b.data, "Invalid blob attribute")
        tx.commit()

        tester.testDone()

        tx = db.new()
        tx.begin()

        tester.startTest("Load and access")
        b = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,id)
        tester.compare(10000, len(b.data), "Invalid blob attribute")
        tester.compare("*"*10000, b.data, "Invalid blob attribute")

        b.data = "1"

        tx.commit()

        tester.testDone()

        tx = db.new()
        tx.begin()

        tester.startTest("Load and Modify")
        b = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,id)

        tester.compare("1", b.data, "Invalid blob attribute")

        b.data = "="*10000
        tx.commit()


        tester.startTest("Load and Delete")
        tx = db.new()
        tx.begin()
        b = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,id)
        tester.compare(10000, len(b.data), "Invalid blob attribute")
        tester.compare("="*10000, b.data, "Invalid blob attribute")

        b.delete()

        tx.commit()

        tester.testDone()
        tester.groupDone()
    finally:
        db.close()
    return

