########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Fetch/Document.py,v 1.12 2005/03/19 10:41:16 jkloth Exp $
"""
Implementation of '4ss fetch document' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command prints the content of an XML-based document \
(e.g. an XML Document or XSLT Document) in a 4Suite repository. \
Currently, the output is the same as for '4ss fetch rawfile', but it \
may eventually be interpreted as if processed by a repository-aware \
version of '4xml'. If necessary, you will be prompted first for \
credentials and access info to connect to the repository."""

import sys

from Ft.Server.Client.Commands import CommandUtil


def Run(options, args):
    repo = CommandUtil.GetRepository(options, '4ss.fetch.document')
    if repo is not None:
        try:
            doc = repo.fetchResource(args['path'])
            if 'quiet' not in options:
                CommandUtil.WritePreamble("Document %s (%s):" % (doc.getPath(), doc.getImt()))
            content = doc.getContent()
            sys.stdout.write(content)
            sys.stdout.flush()
            if 'quiet' not in options:
                if content[-1] != '\n':
                    sys.stderr.write('\n')
                    sys.stderr.flush()
        finally:
            try:
                repo.txRollback()
            except:
                pass

    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('document',
                          'Print content of an XML-based document in a repository',
                          '/ftss/demos/index.html',
                          __doc__,
                          function=Run,
                          arguments=[Arguments.RequiredArgument('path',
                                                                'the path of the Document',
                                                                str),
                                       ],
                          options=Options.Options([
                              Options.Option('q', 'quiet', "Don't preface output with informational header"),
                              ]),
                          fileName=__file__,
                          )
    return cmd
