<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
  <!ENTITY fschema "http://schemas.4suite.org/4ss">
  <!ENTITY vcard "http://4suite.org/nexus/rdfs/vcard#">
]>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  xmlns:vcard="&vcard;"
  xmlns:fschema="http://schemas.4suite.org/4ss"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">

  <!--

File:  play.xslt

Description:

    Make a Loritaire move

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/

  -->

  <xsl:param name='fres:uri-path'/>
  <xsl:param name='fres:absolute-path'/>
  <xsl:param name='user-name'/>
  <xsl:param name='do'/>
  <xsl:param name='pile'/>
  <xsl:param name='depth'/>

  <xsl:template match="loritaire">

    <!--
    <xsl:message>
      <xsl:value-of select='$do'/>
    </xsl:message>
    -->

    <xsl:choose>
      <xsl:when test='$do = "NEXT"'>
        <!--
             Remove from the stack
             Add to the pile
             Update the cur_hand
             -->
        <fhttp:response-uri uri="{$fres:uri-path}?xslt=../play.xslt&amp;user-name={$user-name}"/>

        <fcore:x-update>
          <xupdate:modifications
            version="1.0"
            xmlns:xupdate="http://www.xmldb.org/xupdate"
            >
            <xupdate:remove select="/loritaire/cards/stack/Card[1]"/>
            <xupdate:append select="/loritaire/cards/pile[{cards/stack/Card[1]/@value-int}]" child="last()">
              <xsl:copy-of select='cards/stack/Card[1]'/>
            </xupdate:append>
            <xupdate:update select="/loritaire/cur-hand"><xsl:value-of select='cards/stack/Card[1]/@value-int'/></xupdate:update>
          </xupdate:modifications>
        </fcore:x-update>

        <fcore:mark-temporary path="{$fres:absolute-path}" time-to-live="900"/>

      </xsl:when>
      <xsl:when test='$do = "UP"'>
        <!--
             Verify
             Remove from the pile
             Update target
             -->
        <xsl:variable name='suite' select='cards/pile[number($pile)]/Card[number($depth)]/@suite'/>
        <xsl:variable name='value-int' select='cards/pile[number($pile)]/Card[number($depth)]/@value-int'/>
        <xsl:variable name='target'>
          <xsl:choose>
            <xsl:when test='$suite = "Heart"'>1</xsl:when>
            <xsl:when test='$suite = "Diamond"'>2</xsl:when>
            <xsl:when test='$suite = "Spade"'>3</xsl:when>
            <xsl:when test='$suite = "Club"'>4</xsl:when>
          </xsl:choose>
        </xsl:variable>

        <!--
        <xsl:message>
          Suite: <xsl:value-of select='$suite'/>
          Target: <xsl:value-of select='$target'/>
          Value Int: <xsl:value-of select='$value-int'/>
          Dest: <xsl:value-of select='cards/target[number($target)]/@value-int'/>
        </xsl:message>
        -->

        <xsl:choose>
          <xsl:when test="$value-int=cards/target[number($target)]/Card[1]/@value-int">
            <xsl:call-template name='error-message'>
              <xsl:with-param name='error-string' select='"An identical card was already played on the upward-counting target stacks.&#10;You must play this card on a downward-counting target stack."'/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test='count(cards/target[number($target)]/Card) = 0 and $value-int != 1'>
            <xsl:call-template name='error-message'>
              <xsl:with-param name='error-string' select='"You must start counting up with an Ace"'/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test='$value-int != 1 and cards/target[number($target)]/Card[1]/@value-int != $value-int - 1'>
            <xsl:call-template name='error-message'>
              <xsl:with-param name='error-string' select='"You must count upwards"'/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <fhttp:response-uri uri="{$fres:uri-path}?xslt=../play.xslt&amp;user-name={$user-name}"/>

            <fcore:x-update>

              <xupdate:modifications
                version="1.0"
                xmlns:xupdate="http://www.xmldb.org/xupdate"
                >
                <xupdate:remove select="/loritaire/cards/pile[{$pile}]/Card[{$depth}]"/>
                <xupdate:append select="/loritaire/cards/target[{$target}]" child="0">
                  <xsl:copy-of select='cards/pile[number($pile)]/Card[number($depth)]'/>
                </xupdate:append>
              </xupdate:modifications>
            </fcore:x-update>

            <fcore:mark-temporary path="{$fres:absolute-path}" time-to-live="900"/>

          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test='$do = "DOWN"'>
        <!--
             Verify
             Remove from the pile
             Update target
             -->
        <xsl:variable name='suite' select='cards/pile[number($pile)]/Card[number($depth)]/@suite'/>
        <xsl:variable name='value-int' select='cards/pile[number($pile)]/Card[number($depth)]/@value-int'/>
        <xsl:variable name='target'>
          <xsl:choose>
            <xsl:when test='$suite = "Heart"'>5</xsl:when>
            <xsl:when test='$suite = "Diamond"'>6</xsl:when>
            <xsl:when test='$suite = "Spade"'>7</xsl:when>
            <xsl:when test='$suite = "Club"'>8</xsl:when>
          </xsl:choose>
        </xsl:variable>

        <!--
        <xsl:message>
          Suite: <xsl:value-of select='$suite'/>
          Target: <xsl:value-of select='$target'/>
          Value Int: <xsl:value-of select='$value-int'/>
          Dest: <xsl:value-of select='cards/target[number($target)]/@value-int'/>
        </xsl:message>
        -->

        <xsl:choose>
          <xsl:when test="$value-int=cards/target[number($target)]/Card[1]/@value-int">
            <xsl:call-template name='error-message'>
              <xsl:with-param name='error-string' select='"An identical card was already played on the downward-counting target stacks.&#10;You must play this card on an upward-counting target stack."'/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test='count(cards/target[number($target)]/Card) = 0 and $value-int != 13'>
            <xsl:call-template name='error-message'>
              <xsl:with-param name='error-string' select='"You must start counting down with a king"'/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test='$value-int != 13 and cards/target[number($target)]/Card[1]/@value-int != $value-int + 1'>
            <xsl:call-template name='error-message'>
              <xsl:with-param name='error-string' select='"You must count downwards"'/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <fhttp:response-uri uri="{$fres:uri-path}?xslt=../play.xslt&amp;user-name={$user-name}"/>

            <fcore:x-update>

              <xupdate:modifications
                version="1.0"
                xmlns:xupdate="http://www.xmldb.org/xupdate"
                >
                <xupdate:remove select="/loritaire/cards/pile[{$pile}]/Card[{$depth}]"/>
                <xupdate:append select="/loritaire/cards/target[{$target}]" child="0">
                  <xsl:copy-of select='cards/pile[number($pile)]/Card[number($depth)]'/>
                </xupdate:append>
              </xupdate:modifications>
            </fcore:x-update>

            <fcore:mark-temporary path="{$fres:absolute-path}" time-to-live="900"/>

          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>

      <xsl:otherwise>
        <html>
          <head>
            <title><xsl:value-of select = "$user-name"/><xsl:text>'s game of Loritaire</xsl:text></title>
          </head>
          <body bgcolor='green'>
            <center>
              <xsl:choose>
                <xsl:when test='count(cards/target/Card) = 104'>
                  <font size='+3'>Congratulations, you win!</font>
                  <BR/>
                  <A href="../start.xslt?xslt=start.xslt&amp;user-name={$user-name}">Would you like to play Again</A>
                </xsl:when>
                <xsl:otherwise>
                  <!--Just display the board -->
                  <xsl:call-template name='display-board'/>
                </xsl:otherwise>
              </xsl:choose>
              <hr/>
              <a href='{$fres:uri-path}?xslt=../decorated-xml.xslt' TARGET='_blank'>View the XML behind the scenes</a>
            </center>
          </body>
        </html>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name='display-board'>
    <xsl:variable name='cur_hand' select='cur-hand'/>
    <xsl:variable name='num_play' select='count(cards/stack/Card)'/>
    <xsl:variable name='hand' select='cards/stack'/>

    <!--
    <xsl:message>
      Cur Hand: <xsl:value-of select='$cur_hand'/>
      Num Play: <xsl:value-of select='$cur_hand'/>
    </xsl:message>
    -->

    <DIV style="border: solid 1px">
      <TABLE>
        <TR>
          <TD valign="top">
            <!--The counting up side-->
            <div align="center">
              <TABLE>
                <TR>
                  <TH>Up</TH>
                </TR>
                <xsl:apply-templates select='cards/target[position()&lt;5]'/>
              </TABLE>
            </div>
          </TD>
          <TD valign="top" style="border: outset 4px">
            <!--The playing table-->
            <div align="center">
              <!-- row 1 -->
              <TABLE WIDTH='100%'>
                <TR>
                  <xsl:call-template name='board-row'>
                    <xsl:with-param name='piles' select='cards/pile[position() &lt; 8]'/>
                    <xsl:with-param name='modifier' select='0'/>
                    <xsl:with-param name='cur_hand' select='$cur_hand'/>
                  </xsl:call-template>
                </TR>
              </TABLE>
              <!-- row 2 -->
              <TABLE WIDTH='100%'>
                <TR>
                  <xsl:call-template name='board-row'>
                    <xsl:with-param name='piles' select='cards/pile[position() > 7]'/>
                    <xsl:with-param name='modifier' select='7'/>
                    <xsl:with-param name='cur_hand' select='$cur_hand'/>
                  </xsl:call-template>
                </TR>
              </TABLE>

              <!-- Display the pile and stats -->
              <hr width="100%"/>

              <TABLE WIDTH='90%'>
                <TR>
                  <TD>
                    <xsl:choose>
                      <xsl:when test='count(cards/stack/Card) = 0'>
                        <font size='+3'>LOSER!!!!</font>
                        <BR/>
                        <A href="../start.xslt?xslt=start.xslt&amp;user-name={$user-name}">Would you like to play again?</A>
                      </xsl:when>
                      <xsl:otherwise>
                        <DIV align='center' style="border: outset 4px">
                          <a href="{$fres:uri-path}?xslt=../play.xslt&amp;do=NEXT&amp;user-name={$user-name}">
                            <IMG src="/images/cards/4SS-Back.png" BORDER="0" ALT='Next Card from Pile'/>
                          </a>
                        </DIV>
                      </xsl:otherwise>
                    </xsl:choose>
                  </TD>
                  <TD ALIGN='LEFT' WIDTH="100%">
                    <font size='+2'>
                      <xsl:value-of select='count(cards/target/Card)'/><xsl:text> completed out of 104 cards</xsl:text>
                      <br/>
                      <xsl:value-of select='$num_play'/><xsl:text> cards remaining in stack</xsl:text>
                    </font>
                  </TD>
                </TR>
              </TABLE>

              <xsl:if test='$cur_hand != -1'>

                <!--
                <xsl:message>
                  Count: <xsl:value-of select='count(cards/pile[number($cur_hand)]/Card)'/>
                </xsl:message>
                -->
                <hr width="100%"/>

                <xsl:call-template name='display-hand'>
                  <xsl:with-param name='cards' select='cards/pile[number($cur_hand)]/Card'/>
                  <xsl:with-param name='cur_hand' select='$cur_hand'/>
                </xsl:call-template>
              </xsl:if>
            </div>
          </TD>
          <TD valign="top">
            <!--The counting down side-->
            <div align="center">
              <TABLE>
                <TR>
                  <TH>Down</TH>
                </TR>
                <xsl:apply-templates select='cards/target[position()>4]'/>
              </TABLE>
            </div>
          </TD>
        </TR>
      </TABLE>
    </DIV>
  </xsl:template>


  <xsl:template name='display-hand'>
    <xsl:param name='cards'/>
    <xsl:param name='cur_hand'/>
    <xsl:param name='offset' select='0'/>

    <table>
      <tr>
        <xsl:apply-templates select='$cards[position() &lt;= 7]' mode='display-moveable-card'>
          <xsl:with-param name='cur_hand' select='$cur_hand'/>
          <xsl:with-param name='offset' select='$offset'/>
        </xsl:apply-templates>
      </tr>
    </table>

    <xsl:if test='count($cards) > 7'>
      <xsl:call-template name='display-hand'>
        <xsl:with-param name='cards' select='$cards[position() > 7]'/>
        <xsl:with-param name='cur_hand' select='$cur_hand'/>
        <xsl:with-param name='offset' select='$offset + 7'/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match='Card' mode='display-moveable-card'>
    <xsl:param name='cur_hand'/>
    <xsl:param name='offset' select='0'/>

    <xsl:variable name='pos' select='position() + $offset'/>
    <td align='right' valign='top'>
      <img src='{@img}'/>
    </td>
    <td align='left' valign='top' nowrap='nowrap'>
      <a href="{$fres:uri-path}?xslt=../play.xslt&amp;do=UP&amp;pile={$cur_hand};depth={$pos}&amp;user-name={$user-name}">
        <img src='/images/cards/Up.png' border='0' alt='Move to up stack'/>
      </a>
      <br/>
      <a href="{$fres:uri-path}?xslt=../play.xslt&amp;do=DOWN&amp;pile={$cur_hand};depth={$pos}&amp;user-name={$user-name}">
        <img src='/images/cards/Down.png' border='0' alt='Move to down stack'/>
      </a>
    </td>
  </xsl:template>


  <xsl:template name='board-row'>
    <xsl:param name='piles'/>
    <xsl:param name='modifier'/>
    <xsl:param name='cur_hand'/>
    <xsl:for-each select="$piles">
      <xsl:variable name='pos' select='position() + $modifier'/>
      <td align='right' valign='top'>
        <xsl:choose>
          <xsl:when test="$pos = $cur_hand">
            <img src='/images/cards/X.png'/>
          </xsl:when>
          <xsl:when test="count(Card) > 0">
            <xsl:variable name='text'>
              <xsl:for-each select='Card'>
                <xsl:value-of select='@formal-name'/>
                <xsl:if test='position() != last()'>
                  <xsl:text>, </xsl:text>
                </xsl:if>
              </xsl:for-each>
            </xsl:variable>
            <img src='{Card[1]/@img}' alt='{$text}'/>
          </xsl:when>
          <xsl:otherwise>
            <img src='/images/cards/O.png'/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <xsl:if test="$cur_hand != -1">
        <td align='left' valign='top' nowrap='nowrap'>
          <xsl:choose>
            <xsl:when test="$pos != $cur_hand and count(Card) > 0">
              <a href="{$fres:uri-path}?xslt=../play.xslt&amp;do=UP&amp;pile={$pos};depth=1&amp;user-name={$user-name}">
                <img src='/images/cards/Up.png' border='0' ALT='Move to up stack'/>
              </a>
              <br/>
              <a href="{$fres:uri-path}?xslt=../play.xslt&amp;do=DOWN&amp;pile={$pos};depth=1&amp;user-name={$user-name}">
                <img src='/images/cards/Down.png' border='0' ALT='Move to down stack'/>
              </a>
            </xsl:when>
            <xsl:otherwise>
              <img src='/images/cards/disabled-arrow-up.png'/>
              <br/>
              <img src='/images/cards/disabled-arrow-down.png'/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="cards/target">
    <TR>
      <TD>
        <div align='center' style='border: outset 4px'>
          <xsl:choose>
            <xsl:when test="count(Card) = 13">
              <IMG src='/images/cards/4SS-Back.png'/>
            </xsl:when>
            <xsl:when test="count(Card) > 0">
              <IMG src='{Card[1]/@img}'/>
            </xsl:when>
            <xsl:otherwise>
              <IMG src='/images/cards/O.png'/>
            </xsl:otherwise>
          </xsl:choose>
        </div>
      </TD>
    </TR>
  </xsl:template>

  <xsl:template name='error-message'>
    <xsl:param name='error-string'/>
    <html>
      <head>
        <title><xsl:value-of select = "$user-name"/><xsl:text> 's game of Lorataire</xsl:text></title>
      </head>
      <body bgcolor='green'>
        <center>
          <h1>Error</h1>
          <pre><xsl:value-of select='$error-string'/></pre>
          <br/>
          <a href='{$fres:uri-path}?xslt=../play.xslt&amp;user-name={$user-name}'>Back to game</a>
        </center>
      </body>
    </html>
  </xsl:template>

</xsl:stylesheet>
