<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    Show the score

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->

  <xsl:import href='draw-screen.xsl'/>

  <xsl:template match="/cribbage">
    <xsl:call-template name='draw-screen'>
      <xsl:with-param name='form-action' select='"../redirect-new-hand.xsl"'/>
      <xsl:with-param name='show-all' select='1'/>
      <xsl:with-param name='show-puter' select='1'/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name='playing-area'>

    <H2><xsl:value-of select='key("players",$initial-dealer)/name'/><xsl:text>'s crib</xsl:text></H2>

    <!-- Play info show the crib-->
    <TABLE BORDER='1'>
      <TR>
        <xsl:for-each select='/cribbage/crib-info/Card'>
          <TD><IMG src='{@img}'/></TD>
        </xsl:for-each>
      </TR>
    </TABLE>
  </xsl:template>

  <xsl:template match='Card' mode='player-hand'>
    <TD><IMG src='{@img}'/></TD>
  </xsl:template>

  <xsl:template match='Card' mode='cut-card'>
    <TR>
      <TD ALIGN='CENTER' COLSPAN='2'>
        <IMG src='{@img}'/>
      </TD>
    </TR>
  </xsl:template>

  <xsl:template name='cur-count'>
    <TR>
      <TD ALIGN='CENTER' COLSPAN='2'>
        Final Count: <xsl:value-of select='sum(/cribbage/game-info/cur-count/score)'/>
      </TD>
    </TR>
  </xsl:template>


  <xsl:template name='player-hand-other'>
    <INPUT TYPE='SUBMIT' VALUE='Redeal'/>
  </xsl:template>

</xsl:stylesheet>
