########################################################################
#
# File Name:            DocumentDefinition.py
#
# Documentation:        http://docs.4suite.org/4SS/DocumentDefinition.py.html
#
"""
4Suite server document definitions: contain system and user metadata for managed documents
WWW: http://4suite.org         e-mail: support@4suite.org

Copyright (c) 2001 Fourthought, Inc. USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import sys
import DocumentDefinitionClient

from Ft.Server.FtRpc import Commands

class XPathDocumentDefinitionClient(DocumentDefinitionClient.DocumentDefinitionClient):


    def getNsMap(self):
        """
        Get the namespace mapping for this document deifnition
        """
        return Commands.RemoteMethodCommand('getNsMap',
                                            self._path,
                                            ()
                                            ).send(self._connection).results

    def getRdfMaps(self):
        """
        Get all of the RDF mappings for this document definition
        """
        return Commands.RemoteMethodCommand('getRdfMaps',
                                            self._path,
                                            ()
                                            ).send(self._connection).results

    def setNsMap(self,newNss):
        """
        Set the namespace mappings of this document definition
        """
        return Commands.RemoteMethodCommand('setNsMap',
                                            self._path,
                                            (newNss,)
                                            ).send(self._connection).results


    def setRdfMaps(self,newMaps):
        """
        Set the RDF mappings for this documetn definition
        """
        return Commands.RemoteMethodCommand('setRdfMaps',
                                            self._path,
                                            (newMaps,)
                                            ).send(self._connection).results

