// progressdialog.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Subclasses of InterViews Dialog class.  The new display() method pops up
// the ProgressDialog centered in whichever Interactor canvas has been passed
// to it, without use of the Event passed to
// Popup(), which is how it would have been done in the original Dialog class.

#ifndef PROGRESSDIALOG_H
#ifdef __GNUG__
#pragma interface
#endif
#define PROGRESSDIALOG_H

#include <InterViews/dialog.h>
#include "localdefs.h"

class ProgressDialog : public Dialog {
	typedef Dialog Super;
public:
	ProgressDialog(const char *message, Interactor* u);
	virtual ~ProgressDialog();
	redefined Interactor* Wrap(Interactor *);
	redefined boolean Popup(Event&, boolean b=false);
	redefined boolean Accept();
	boolean isMapped();
	void appear();
	void disappear();
	int update(double progress);
protected:
	redefined void Reconfig();
	int getAnswer();
	int display();
	void reset();
	boolean eventLoop(Event &);
private:
	boolean isChild(Interactor*);
	const char *	_message;
	Interactor * 	_underlying, *_statusBar;
	Perspective	*	_barPerspective;
	boolean			_madeToAppear;
	boolean			_isDone;
};

#endif

