// optionsetter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifndef OPTIONSETTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define OPTIONSETTER_H

#include "modifier.h"
#include "MyString.h"

void read_mxvrc();
void write_mxvrc();

class GlobalOptionSetter : public Modifier {
	friend class GlobalOptionRequester;
public:
	GlobalOptionSetter();
	redefined int apply();
protected:
	redefined Requester* createRequester();
private:
	ChoiceValue panelOverride;
	ChoiceValue autoPlace;
};

class FileOptionSetter : public Modifier {
	friend class FileOptionRequester;
public:
	FileOptionSetter();
	redefined int apply();
protected:
	redefined Requester* createRequester();
private:
	ChoiceValue readRaw;
	ChoiceValue storePath;
	ChoiceValue showInvisible;
};

class LPCOptionSetter : public Modifier {
	friend class LPCOptionRequester;
public:
	LPCOptionSetter();
	redefined int apply();
protected:
	redefined Requester* createRequester();
private:
	ChoiceValue headerFormat;
	ChoiceValue byteOrder;
};

class EnvelopeOptionSetter : public Modifier {
	friend class EnvelopeOptionRequester;
public:
	EnvelopeOptionSetter();
	redefined int apply();
protected:
	redefined Requester* createRequester();
private:
	ChoiceValue headerFormat;
	ChoiceValue byteOrder;
};

class SoundOptionSetter : public Modifier {
	friend class SoundOptionRequester;
public:
	SoundOptionSetter();
	redefined int apply();
protected:
	redefined Requester* createRequester();
private:
	ChoiceValue sampleFormat;
	ChoiceValue headerFormat;
};

class RawSoundfileOptionSetter : public Modifier {
	friend class RawSoundfileOptionRequester;
public:
	RawSoundfileOptionSetter();
	redefined int apply();
protected:
	redefined Requester* createRequester();
private:
	ChoiceValue sampleFormat;
	int channelCount;
	int sampleRate;
};

class EditorOptionSetter : public Modifier {
	friend class EditorOptionRequester;
public:
	EditorOptionSetter();
	redefined int apply();
protected:
	redefined Requester* createRequester();
private:
	ChoiceValue _clearUndoOnSave;
	int _undoDepth;
};

class MemoryOptionSetter : public Modifier {
	friend class MemoryOptionRequester;
public:
	MemoryOptionSetter() {}
	redefined int apply();
protected:
	redefined Requester* createRequester();
private:
	double maxSingle;
	double maxTotal;
};

class SoundPlaybackOptionSetter : public Modifier {
	friend class SoundPlaybackOptionRequester;
public:
	SoundPlaybackOptionSetter();
	redefined int apply();
protected:
	redefined Requester* createRequester();
private:
	String audioDeviceName;
	String mixerDeviceName;
	float  audioBufferTime;
};

#endif
