=begin
  post-setup.rb

  Copyright (C) 2001-2004 MUTOH Masao <mutoh@highway.ne.jp>
  This program is licenced under the same licence as Ruby. 
=end

require 'fileutils'

ruby = config("ruby-path")
libdir = "-I#{srcdir_root}/lib/ -I#{Dir.pwd}/ext/gettext/"
msgfmt = "./bin/rmsgfmt"

podir = srcdir_root + "/po/"
modir = "data/locale/%s/LC_MESSAGES/"

Dir.glob("#{podir}*/*.po") do |file|
  lang, basename = /\A([\w\.]*)\/(.*)\.po/.match(file[podir.size..-1]).to_a[1,2]
  outdir = modir % lang
  FileUtils.mkdir_p(outdir) unless File.directory?(outdir)
  system("#{ruby} #{libdir} #{msgfmt} #{file} -o #{outdir}#{basename}.mo")
end
