#if   !defined(__ABSTRACTBANKACCOUNT_HPP)
#define __ABSTRACTBANKACCOUNT_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


DECLARE_TYPE( CORELINUX(Real), Amount );
DECLARE_TYPE( CORELINUX(Exception), InvalidAmountException );
DECLARE_TYPE( CORELINUX(Exception), InsufficientFundsException );

DECLARE_CLASS( AbstractBankAccount );

/**
AbstractBankAccount provides the interface for all accounts used
in this application. Common methods such as withdrawing and
depositing funds are made available, as well as retrieving
the balance of the account.
*/

class AbstractBankAccount
{
public:

   //
   // Constructors and destructor
   //

                        /// Default constructor

                        AbstractBankAccount( void )
                        {
                           ;  // do nothing
                        }

                        /// Copy constructor

                        AbstractBankAccount( AbstractBankAccountCref aRef )
                        {
                           ;  // do nothing
                        }

                        /// Virtual Destructor

   virtual              ~AbstractBankAccount( void )
                        {
                           ;  // do nothing
                        }

   //
   // Operator overloads
   //

            /**
            Assignment operator
            @param AbstractBankAccount const reference
            @return AbstractBankAccount reference
            */

            AbstractBankAccountRef operator=( AbstractBankAccountCref aRef )
            {
               return ( *this );
            }

            /**
            Equality operator
            @param AbstractBankAccount const reference
            @return bool - True if same instances
            */

            bool  operator==( AbstractBankAccountCref aRef ) const
            {
               return ( this == &aRef );
            }
   
   //
   // Accessors
   //
            /**
            Retrieve the account balance
            @return Amount const reference to balance
            */

   virtual  AmountCref  getBalance( void ) const  = 0;

   //
   // Mutators
   //
            /**
            Withdraw an amount of funds from the account
            @param Amount - amount to withdraw
            @exception InsufficientFundsException if the
            amount requested to withdraw is not available
            in the account funds
            */
            
   virtual  void  withdrawFunds( Amount ) 
                           throw(InsufficientFundsException) = 0;
   
   
            /**
            Deposit funds into the account
            @param Amount - to deposit
            */
            
   virtual  void  depositFunds( Amount ) 
                           throw(InsufficientFundsException) = 0;



};

#endif // if   !defined(__ABSTRACTBANKACCOUNT_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/02/10 14:32:20 $
   $Locker:  $
*/


