#if   !defined(__PAIR_HPP)
#define  __PAIR_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

// STL includes

#include <utility>

namespace   corelinux
{
   /**
   STL pair template. This macro generates all
   the type references and pointers for the pair.
   @param name The name you want to give the pair
   @param pair1 The first type of the pair
   @param pair2 The second type of the pair
   */
   #define CORELINUX_PAIR(name,pair1,pair2)      \
      typedef struct pair<pair1, pair2> name;    \
      typedef name *       name ## Ptr;          \
      typedef const name * name ## Cptr;         \
      typedef name &       name ## Ref;          \
      typedef const name & name ## Cref;
}

#endif

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/


