#!/bin/sh

apt-get --yes remove `./lscross.sh`
apt-get update
apt-get --yes install binutils gcc-3.4

rm -r /tmp/toolchain-tests
mkdir /tmp/toolchain-tests
cd /tmp/toolchain-tests

echo 'main() {int a,b; return a*b;}' > test1.c
echo '#include <stdio.h>' > test2.c 
echo 'main() {printf("Hello World\n");}' >> test2.c
echo '#include <stream.h>' > test3.cc
echo 'main() {cout << "Hi!\n";}' >> test3.cc

date


#for T in powerpc-linux s390-linux m68k-linux alpha-linux avr; do
for T in arm-linux; do 
#for T in arm-linux powerpc-linux ia64-linux hppa-linux mips-linux sparc-linux mipsel-linux s390-linux m68k-linux alpha-linux i586-pc-msdosdjgpp sh-linux cris-linux ; do
  rm -r $T log.$T
  mkdir $T
  echo > log.$T
  cd $T

  tpkg-install-libc $T 2>&1 | tee -a ../log.$T
  tpkg-make $T 2>&1 | tee -a ../log.$T 

  cd binutils*
  debuild  2>&1 | tee -a ../../log.$T
  debi 2>&1 | tee -a ../../log.$T

  cd ../gcc*
  rm -rf ../binutils*
  debuild  2>&1 | tee -a ../../log.$T
  debi 2>&1 | tee -a ../../log.$T

  cd ../gdb*
  rm -rf ../gcc*
  debuild  2>&1 | tee -a ../../log.$T
  debi 2>&1 | tee -a ../../log.$T

  cd ../..
  $T-gcc -o test1.$T test1.c  2>&1 | tee -a log.$T
  $T-gcc -o test2.$T test2.c  2>&1 | tee -a log.$T
  $T-g++ -o test3.$T test3.cc  2>&1 | tee -a log.$T

  date

done
