from visual import *

# Display extruded text (uppercase only at present)
# By default, display text along x axis, with letters pointing up parallel to y axis
# Bruce Sherwood, Carnegie Mellon University, begun March 2000

# Example with default values:
#  text(pos=(0,0,0), axis=(1,0,0), string='ABC',
#    height=1, depth=0, width=1,
#    color=currentdisplay.foreground, up=(0,1,0.3))
# axis is direction along which text advances
# if width not specified, it is the same as height
# depth is measured forward from pos
# Only numbers and uppercase letters at present: others display as '*'

defaultdir = vector(1.0,0.,0.)
defaultup = vector(0.,1.0,0.)

letters = {' ': [(0.39,0,0)],
            'A': [[(0,0,0), (0.13,0,0), (0.37,1.0,0)],
                [(0.88,0,0), (-0.13,0,0),(-0.37,1.0,0)],
                [(0.2,0.3,0), (0.5,0,0), (0,0.1,0)],
                (1.0,0,0)],
            'B': [[(0,0,0), (0.13,0,0), (0,1.0,0)],
                [(0.1,1.0,0), (0.4,0,0), (0,-0.12,0)],
                [(0.1,0.47,0), (0.4,0,0), (0,0.12,0)],
                [(0.1,0,0), (0.4,0,0), (0,0.12,0)],
                [(0.5,1.0,0), (0.26,-0.1,0), (0,-0.12,0)],
                [(0.76,0.9,0), (-0.13,0,0), (0,-0.3,0)],
                [(0.5,0.47,0), (0.26,0.1,0), (0,0.12,0)],
                [(0.5,0.59,0), (0.26,-0.1,0), (0,-0.12,0)],
                [(0.76,0.42,0), (-0.13,0,0), (0,-0.3,0)],
                [(0.5,0,0), (0.26,0.1,0), (0,0.12,0)],
                (0.88,0,0)],
            'C': [[(0,0.2,0), (0.13,0,0), (0,0.6,0)],
                [(0.26,1.0,0), (0.36,0,0), (0,-0.13,0)],
                [(0.26,0,0), (0.36,0,0), (0,0.13,0)],
                [(0.62,1.0,0), (0.26,-0.2,0), (0,-0.13,0)],
                [(0,0.8,0), (0.26,0.2,0), (0,-0.13,0)],
                [(0,0.2,0), (0.26,-0.2,0), (0,0.13,0)],
                [(0.62,0,0), (0.26,0.2,0), (0,0.13,0)],
                (1.05,0,0)],
            'D': [[(0,0,0), (0.13,0,0), (0,1.0,0)],
                [(0.1,1.0,0), (0.4,0,0), (0,-0.12,0)],
                [(0.1,0,0), (0.4,0,0), (0,0.12,0)],
                [(0.5,1.0,0), (0.26,-0.1,0), (0,-0.12,0)],
                [(0.76,0.9,0), (-0.13,0,0), (0,-0.8,0)],
                [(0.5,0,0), (0.26,0.1,0), (0,0.12,0)],
                (1.01,0,0)],
            'E': [[(0,0,0), (0.13,0,0), (0,1.0,0)],
                [(0.1,1.0,0), (0.63,0,0), (0,-0.12,0)],
                [(0.1,0.46,0), (0.58,0,0), (0,0.11,0)],
                [(0.1,0,0), (0.63,0,0), (0,0.12,0)],
                (0.93,0,0)],
            'F': [[(0,0,0), (0.13,0,0), (0,1.0,0)],
                [(0.1,1.0,0), (0.58,0,0), (0,-0.12,0)],
                [(0.1,0.46,0), (0.52,0,0), (0,0.11,0)],
                (0.8,0,0)],
            'G': [[(0,0.2,0), (0.13,0,0), (0,0.6,0)],
                [(0.26,1.0,0), (0.36,0,0), (0,-0.13,0)],
                [(0.26,0,0), (0.36,0,0), (0,0.13,0)],
                [(0.62,1.0,0), (0.26,-0.2,0), (0,-0.13,0)],
                [(0,0.8,0), (0.26,0.2,0), (0,-0.13,0)],
                [(0,0.2,0), (0.26,-0.2,0), (0,0.13,0)],
                [(0.62,0,0), (0.26,0.2,0), (0,0.13,0)],
                [(0.47,0.35,0), (0.44,0,0), (0,0.12,0)],
                [(0.92,0.47,0), (-0.1,0,0), (0,-0.47,0)],
                (1.05,0,0)],           
            'H': [[(0,0,0), (0.13,0,0), (0,1.0,0)],
                [(0.1,0.47,0), (0.6,0,0), (0,0.12,0)],
                [(0.69,0,0), (0.13,0,0), (0,1.0,0)],
                (1.02,0,0)],
            'I': [[(0,0,0), (0.13,0,0), (0,1.0,0)],
                (0.28,0,0)],
            'J': [[(0.43,1.0,0), (0.13,0,0), (0,-0.78,0)],
                [(0,0.35,0), (0,-0.13,0), (0.12,0,0)],
                [(0.2,0,0), (-0.2,0.22,0), (0,0.13,0)],
                [(0.2,0,0), (0.1,0,0), (0,0.13,0)],
                [(0.3,0,0), (0.26,0.22,0), (0,0.13,0)],
                (0.78,0,0)],
            'K': [[(0,0,0), (0.13,0,0), (0,1.0,0)],
                [(0.13,0.36,0), (0.47,0.44,0), (0,0.16,0)],
                [(0.6,0.8,0), (0.2,0.2,0), (-0.18,0,0)],
                [(0.8,0,0), (-0.18,0,0), (-0.4,0.6,0)],
                (0.92,0,0)],
            'L': [[(0,0,0), (0.13,0,0), (0,1.0,0)],
                [(0,0,0), (0.64,0,0), (0,0.13,0)],
                (0.78,0,0)],
            'M': [[(0,0,0), (0.13,0,0), (0,1.0,0)],
                [(0.07,1.0,0), (0.13,0,0), (0.34,-1.0,0)],
                [(0.85,1.0,0), (-0.13,0,0), (-0.31,-1.0,0)],
                [(0.82,0,0), (0.13,0,0), (0,1.0,0)],
                (1.16,0,0)],
            'N': [[(0,0,0), (0.13,0,0), (0,1.0,0)],
                [(0.01,1.0,0), (0.15,0,0), (0.63,-1.0,0)],
                [(0.66,0,0), (0.13,0,0), (0,1.0,0)],
                (1.0,0,0)],
            'O': [[(0,0.2,0), (0.13,0,0), (0,0.6,0)],
                [(0.26,1.0,0), (0.46,0,0), (0,-0.13,0)],
                [(0.26,0,0), (0.46,0,0), (0,0.13,0)],
                [(0.72,1.0,0), (0.26,-0.2,0), (0,-0.13,0)],
                [(0,0.8,0), (0.26,0.2,0), (0,-0.13,0)],
                [(0,0.2,0), (0.26,-0.2,0), (0,0.13,0)],
                [(0.72,0,0), (0.26,0.2,0), (0,0.13,0)],
                [(0.85,0.2,0), (0,0.6,0), (0.13,0,0)],
                (1.13,0,0)],
            'P': [[(0,0,0), (0.13,0,0), (0,1.0,0)],
                [(0.1,1.0,0), (0.4,0,0), (0,-0.12,0)],
                [(0.1,0.47,0), (0.4,0,0), (0,0.12,0)],
                [(0.5,1.0,0), (0.26,-0.1,0), (0,-0.12,0)],
                [(0.76,0.9,0), (-0.13,0,0), (0,-0.3,0)],
                [(0.5,0.47,0), (0.26,0.1,0), (0,0.12,0)],
                (0.85,0,0)],
            'Q': [[(0,0.2,0), (0.13,0,0), (0,0.6,0)],
                [(0.26,1.0,0), (0.46,0,0), (0,-0.13,0)],
                [(0.26,0,0), (0.46,0,0), (0,0.13,0)],
                [(0.72,1.0,0), (0.26,-0.2,0), (0,-0.13,0)],
                [(0,0.8,0), (0.26,0.2,0), (0,-0.13,0)],
                [(0,0.2,0), (0.26,-0.2,0), (0,0.13,0)],
                [(0.72,0,0), (0.26,0.2,0), (0,0.13,0)],
                [(0.85,0.2,0), (0,0.6,0), (0.13,0,0)],
                [(0.53,0.21,0), (0.07,0.08,0), (0.36,-0.28,0)],
                (1.14,0,0)],
            'R': [[(0,0,0), (0.13,0,0), (0,1.0,0)],
                [(0.1,1.0,0), (0.4,0,0), (0,-0.12,0)],
                [(0.1,0.47,0), (0.4,0,0), (0,0.12,0)],
                [(0.5,1.0,0), (0.26,-0.1,0), (0,-0.12,0)],
                [(0.76,0.9,0), (-0.13,0,0), (0,-0.3,0)],
                [(0.5,0.47,0), (0.26,0.1,0), (0,0.12,0)],
                [(0.5,0.59,0), (0.26,-0.1,0), (0,-0.12,0)],
                [(0.76,0.42,0), (-0.13,0,0), (0,-0.3,0)],
                [(0.76,0.12,0), (-0.13,0,0), (0.05,-.12,0)],
                (0.95,0,0)],
            'S': [[(0,0.33,0), (0.12,0,0), (0,-0.13,0)],
                [(0,0.2,0), (0.12,0,0), (0.2,-0.2,0)],
                [(0.2,0,0), (0,0.12,0), (0.38,0,0)],
                [(0.58,0,0), (-0.12,0,0), (0.2,0.2,0)],
                [(0.78,0.2,0), (-0.12,0,0), (0,0.3,0)],
                [(0.78,0.4,0), (0,0.13,0), (-0.73,0.24,0)],
                [(0.05,0.64,0), (0,0.16,0), (0.13,0,0)],
                [(0.05,0.80,0), (0.13,0,0), (0.2,0.2,0)],
                [(0.25,1.0,0), (0.3,0,0), (0,-0.13,0)],
                [(0.55,1.0,0), (-0.13,0,0), (0.2,-0.2,0)],
                (0.93,0,0)],
            'T': [[(0.34,0,0), (0.13,0,0), (0,1.0,0)],
                [(0,1.0,0), (0.8,0,0), (0,-0.12,0)],
                (0.93,0,0)],
            'U': [[(0,1.0,0), (0.13,0,0), (0,-0.78,0)],
                [(0.65,1.0,0), (0.13,0,0), (0,-0.78,0)],
                [(0,0.22,0), (0.26,-0.22,0), (0,0.13,0)],
                [(0.26,0,0), (0.26,0,0), (0,0.13,0)],
                [(0.52,0,0), (0.26,0.22,0), (0,0.13,0)],
                (0.92,0,0)],
            'V': [[(0,1.0,0), (0.15,0,0), (0.36,-1.0,0)],
                [(0.86,1.0,0), (-0.15,0,0), (-0.36,-1.0,0)],
                (0.92,0,0)],
            'W': [[(0,1.0,0), (0.15,0,0), (0.25,-1.0,0)],
                [(0.71,1.0,0), (-0.15,0,0), (-0.25,-1.0,0)],
                [(0.6,1.0,0), (0.15,0,0), (0.25,-1.0,0)],
                [(1.26,1.0,0), (-0.15,0,0), (-0.25,-1.0,0)],
                (1.3,0,0)],
            'X': [[(0.02,1.0,0), (0.17,0,0), (0.68,-1.0,0)],
                [(0,0,0), (0.17,0,0), (0.69,1.0,0)],
                (0.92,0,0)],
            'Y': [[(0.38,0,0), (0.13,0,0), (0,0.4,0)],
                [(0.15,1.0,0), (0,-0.24,0), (0.30,-0.48,0)],
                [(0,1.0,0), (0.15,0,0), (0.15,-0.24,0)],
                [(0.73,1.0,0), (0,-0.24,0), (-0.28,-0.48,0)],
                [(0.88,1.0,0), (-0.15,0,0), (-0.15,-0.24,0)],
                (0.93,0,0)],
            'Z': [[(0,0,0), (0.78,0,0), (0,0.12,0)],
                [(0.05,1.0,0), (0.73,0,0), (0,-0.12,0)],
                [(0,0.12,0), (0.17,0,0), (0.61,0.76,0)],
                (0.83,0,0)],
            '0': [[(0,0.2,0), (0.13,0,0), (0,0.6,0)],
                [(0.26,1.0,0), (0.14,0,0), (0,-0.13,0)],
                [(0.26,0,0), (0.14,0,0), (0,0.13,0)],
                [(0.40,1.0,0), (0.26,-0.2,0), (0,-0.13,0)],
                [(0,0.8,0), (0.26,0.2,0), (0,-0.13,0)],
                [(0,0.2,0), (0.26,-0.2,0), (0,0.13,0)],
                [(0.40,0,0), (0.26,0.2,0), (0,0.13,0)],
                [(0.53,0.2,0), (0,0.6,0), (0.13,0,0)],
                (0.78,0,0)],
            '1': [[(0.22,0,0), (0.13,0,0), (0,1.0,0)],
                [(0,0.66,0), (0,0.16,0), (0.22,0.18,0)],
                (0.78,0,0)],
            '2': [[(0,0,0), (0.66,0,0), (0,0.12,0)],
                [(0,0.12,0), (0.53,0.64,0), (0.13,0,0)],
                [(0.53,0.76,0), (0.12,0,0), (0,0.10,0)],
                [(0.53,0.86,0), (0.12,0,0), (-0.14,0.14,0)],
                [(0.51,1.0,0), (-0.34,0,0), (0,-0.12,0)],
                [(0.03,0.76,0), (0,0.10,0), (0.12,0,0)],
                [(0.03,0.86,0), (0.12,0,0), (0.14,0.14,0)],
                (0.78,0,0)],
            '3': [[(0,0.33,0), (0.12,0,0), (0,-0.12,0)],
                [(0,0.21,0), (0.12,0,0), (0.14,-0.21,0)],
                [(0.14,0,0), (0.34,0,0), (0,0.12,0)],
                [(0.53,0.21,0), (0.13,0,0), (0,0.18,0)],
                [(0.66,0.21,0), (-0.13,0,0), (-0.14,-0.21,0)],
                [(0.53,0.39,0), (0.13,0,0), (-0.13,0.19,0)],
                [(0.26,0.53,0), (0.24,0,0), (0,0.10,0)],
                [(0.52,0.70,0), (0.12,0,0), (-0.12,-0.12,0)],
                [(0.52,0.86,0), (0.12,0,0), (0,-0.16,0)],
                [(0.52,0.86,0), (0.12,0,0), (-0.14,0.14,0)],
                [(0.50,1.0,0), (-0.33,0,0), (0,-0.12,0)],
                [(0.03,0.76,0), (0,0.10,0), (0.12,0,0)],
                [(0.03,0.86,0), (0.12,0,0), (0.14,0.14,0)],
                (0.78,0,0)],
            '4': [[(0.42,0,0), (0.13,0,0), (0,1.0,0)],
                [(0,0.34,0), (0.69,0,0), (0,0.10,0)],
                [(0,0.34,0), (0.42,0.51,0), (0,0.14,0)],
                (0.78,0,0)],
            '5': [[(0,0.33,0), (0.12,0,0), (0,-0.12,0)],
                [(0,0.21,0), (0.12,0,0), (0.14,-0.21,0)],
                [(0.14,0,0), (0.34,0,0), (0,0.12,0)],
                [(0.53,0.21,0), (0.13,0,0), (0,0.22,0)],
                [(0.66,0.21,0), (-0.13,0,0), (-0.14,-0.21,0)],
                [(0.66,0.43,0), (-0.13,0,0), (-0.13,0.19,0)],
                [(0.20,0.52,0), (0.28,0,0), (0,0.10,0)],
                [(0.04,0.46,0), (0.11,-0.01,0), (0.16,0.16,0)],
                [(0.04,0.46,0), (0.11,-0.01,0), (0.07,0.54,0)],
                [(0.11,1.0,0), (0.50,0,0), (0,-0.11,0)],
                (0.78,0,0)],
            '6': [[(0,0.21,0), (0.13,0,0), (0,0.58,0)],
                [(0,0.21,0), (0.13,0,0), (0.18,-0.21,0)],
                [(0.18,0,0), (0.30,0,0), (0,0.12,0)],
                [(0,0.43,0), (0.13,0,0), (0.18,0.21,0)],
                [(0.53,0.21,0), (0.13,0,0), (0,0.22,0)],
                [(0.66,0.21,0), (-0.13,0,0), (-0.18,-0.21,0)],
                [(0.66,0.43,0), (-0.13,0,0), (-0.18,0.21,0)],
                [(0.20,0.54,0), (0.28,0,0), (0,0.10,0)],
                [(0,0.79,0), (0.18,0.21,0), (0.13,0,0)],
                [(0.18,1.0,0), (0.30,0,0), (0,-0.13,0)],
                [(0.66,0.79,0), (-0.13,0,0), (-0.18,0.21,0)],
                (0.78,0,0)],
            '7': [[(0,1.0,0), (0.66,0,0), (0,-0.12,0)],
                [(0.27,0,0), (-0.14,0,0), (0.39,0.88,0)],
                (0.78,0,0)],
            '8': [[(0,0.21,0), (0.13,0,0), (0,0.22,0)],
                [(0,0.21,0), (0.13,0,0), (0.18,-0.21,0)],
                [(0.18,0,0), (0.30,0,0), (0,0.12,0)],
                [(0,0.43,0), (0.13,0,0), (0.18,0.21,0)],
                [(0.53,0.21,0), (0.13,0,0), (0,0.22,0)],
                [(0.66,0.21,0), (-0.13,0,0), (-0.18,-0.21,0)],
                [(0.66,0.43,0), (-0.13,0,0), (-0.18,0.21,0)],
                [(0.20,0.54,0), (0.28,0,0), (0,0.10,0)],
                [(0.05,0.79,0), (0.18,0.21,0), (0.13,0,0)],
                [(0.23,1.0,0), (0.20,0,0), (0,-0.13,0)],
                [(0.61,0.79,0), (-0.13,0,0), (-0.18,0.21,0)],
                [(0.05,0.79,0), (0.13,0,0), (0,-0.1,0)],
                [(0.61,0.79,0), (-0.13,0,0), (0,-0.1,0)],
                [(0.05,0.69,0), (0.13,0,0), (0.10,-0.1,0)],
                [(0.61,0.69,0), (-0.13,0,0), (-0.10,-0.1,0)],
                (0.78,0,0)],
            '9': [[(0.78, 0.79, 0), (-0.13, 0, 0), (0, -0.58, 0)],
                [(0.78, 0.79, 0), (-0.13, 0, 0), (-0.18, 0.21, 0)],
                [(0.6, 1.0, 0), (-0.3, 0, 0), (0, -0.12, 0)],
                [(0.78, 0.57, 0), (-0.13, 0, 0), (-0.18, -0.21, 0)],
                [(0.25, 0.79, 0), (-0.13, 0, 0), (0, -0.22, 0)],
                [(0.12, 0.79, 0), (0.13, 0, 0), (0.18, 0.21, 0)],
                [(0.12, 0.57, 0), (0.13, 0, 0), (0.18, -0.21, 0)],
                [(0.58, 0.46, 0), (-0.28, 0, 0), (0, -0.1, 0)],
                [(0.78, 0.21, 0), (-0.18, -0.21, 0), (-0.13, 0, 0)],
                [(0.6, 0.0, 0), (-0.3, 0, 0), (0, 0.13, 0)],
                [(0.12, 0.21, 0), (0.13, 0, 0), (0.18, -0.21, 0)],
                (0.78,0,0)],
            '-': [[(0.01,0.34,0), (0,0.13,0), (0.34,0,0)],
                (0.44,0,0)],
            '+': [[(0,0.32,0), (0,0.10,0), (0.70,0,0)],
                [(0.30,0.03,0), (0,0.70,0), (0.10,0,0)],
                (0.81,0,0)],
            '.': [[(0.05,0,0), (0.14,0,0), (0,0.14,0)],
                (0.38,0,0)],
            ':': [[(0.05,0,0), (0.14,0,0), (0,0.14,0)],
                [(0.05,0.58,0), (0.14,0,0), (0,0.14,0)],
                (0.38,0,0)],
            '*': [[(0,0.82,0), (0.025,0.07,0), (0.21,-0.06,0)],
                [(0.43,0.82,0), (-0.025,0.07,0), (-0.22,-0.06,0)],
                [(0.17,0.98,0), (0.08,0,0), (0,-0.20,0)],
                [(0.06,0.64,0), (0.06,-0.05,0), (0.12,0.16,0)],
                [(0.36,0.64,0), (-0.06,-0.05,0), (-0.12,0.16,0)],
                (0.53,0,0)]
                }

def getlength(str):
    dx = 0
    for char in str:
        if letters.has_key(char):
            data = letters[char]
        else:
            data = letters['*']
        # assume that increment in char description is always of form (dx,0,0)
        dx = dx+data[-1][0]
    return dx

class text:
    def __init__(self, pos=(0,0,0), axis=defaultdir, string='', justify='left',
           height=1.0, width=None, depth=0, color=None, up=None, visible=1,
           display=None):
        if display == None:
            display = scene
        self.display = display
        axis = norm(vector(axis))
        pos = vector(pos)
        height = float(height)
        if width == None:
            width = height
        width = float(width)
        depth = float(depth)
        container = frame(pos=pos, axis=axis)
        self.string = string
        self.justify = justify
        self.height = height
        self.width = width
        self.depth = depth
        self.color = color
        container.color = color
        container.visible = visible
        if up <> None:
            container.up = up
        self.frame = container
        self.objects = []
        if justify == 'right':
            origin = vector(-width*getlength(string),0.,0.)
        elif justify == 'center':
            origin = vector(-width*getlength(string)/2.,0.,0.)
        else:
            origin = vector(0.,0.,0.)
        for char in string:
            origin = self.showletter(origin, char, width, height,
                                depth, color, container, visible)
    
    def makeinvisible(self):
        for obj in self.objects:
            obj.visible = 0

    def makeletterbox(self, origin, b, xsize, ysize,
                      thickness, color, container, visible):
        barray = array(b)
        ab = barray*array((xsize,ysize,0.))
        org = origin+ab[0]
        b = convex(display=self.display, color=color, frame=container, visible=visible)
        self.objects.append(b)
        if thickness <> 0:
            for i in range(2):
                for j in range(2):
                    for k in range(2):
                         # print org + i*ab[1] + j*ab[2] + k*vector(0.,0.,xsize*thickness)).__class__
                         b.append(pos=tuple(org + i*ab[1] + j*ab[2] + k*vector(0.,0.,xsize*thickness)))
        else:
            for i in range(2):
                for j in range(2):
                         b.append(pos=tuple(org + i*ab[1] + j*ab[2]))

    def showletter(self, origin, char, xsize, ysize,
                   thickness, color, container, visible):
        if letters.has_key(char):
            data = letters[char]
        else:
            data = letters['*']
        for n in range(len(data)-1):
            self.makeletterbox(origin, data[n], xsize, ysize,
                          thickness, color, container, visible)
        # assume that increment in char description is always of form (dx,0,0)
        dx = data[-1][0]
        return origin+xsize*dx*defaultdir

    def reshape(self, pos=None, height=None, width=None, color=None):
        if pos is not None:
            self.frame.pos = pos
        if height is None:
            height = self.height
        if width is None:
            width = self.width
        if color is None:
            color = self.color
        xratio = width/self.width
        yratio = height/self.height
        # print array((xratio,yratio,0.))
        for obj in self.objects:
            obj.pos = obj.pos*array((xratio,yratio,1.))
            obj.color = color
        self.height = float(height)
        self.width = float(width)
        self.color = color

if __name__ == '__main__':
    scene.title = "3D Text"
    scene.fov = 0.001
    scene.range = 7
    text(pos=(0,3,0), string='ABC', color=color.red, depth=0.3, justify='center')
    text(pos=(0,-3,0), string='DEF', color=color.blue, depth=0.3, justify='center')
    message = text(pos=(0,0,0), string='CLICK TO CHANGE THIS', justify='center',
                   color=color.yellow, axis=(1,0,1),
                    depth=0.3, up=(0,1,-0.3))
    scene.mouse.getclick()
    message.reshape(color=color.cyan, height=2)


