

import test_helper

from Ft.Server.Common import DocumentReference, ResourceTypes

from Ft.Xml.Lib import TreeCompare

def test_get_content(tester):

    sty = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:fcore='http://xmlns.4suite.org/4ss/score'
  extension-element-prefixes="fcore"
  >
  <xsl:output method='text'/>
  <xsl:template match="/">
    <xsl:value-of select='fcore:get-content("rf1")'/>
  </xsl:template>
</xsl:stylesheet>"""

    expected = """RAW1"""

    tester.startTest("XSLT Extension Get Content")

    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('test')
    test_helper.TestXslt(tester,test,sty,expected)
    repo.txCommit()

    tester.testDone()


def test_set_content(tester):

    sty_base = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:fcore='http://xmlns.4suite.org/4ss/score'
  extension-element-prefixes="fcore"
  >
  <xsl:output method='%s'/>
  <xsl:template match="/">
    <xsl:text>Foo</xsl:text>
    <fcore:set-content path='%s' literal-content='yes'>
    %s
    </fcore:set-content>
  </xsl:template>
</xsl:stylesheet>"""


    tester.startTest("XSLT Extension Set Content on raw file")
    expected = """Foo"""
    sty = sty_base % ('text',"rf1","<xsl:text>RAW2</xsl:text>")
    repo = test_helper.GetRepo(tester)

    test = repo.fetchResource('test')
    test_helper.TestXslt(tester,test,sty,expected)
    tester.compare("RAW2",test.fetchResource('rf1').getContent())
    repo.txCommit()
    tester.testDone()


    tester.startTest("XSLT Extension Set Content on xml document")
    repo = test_helper.GetRepo(tester)
    sty = sty_base % ('xml',"doc1","<foo2/>")
    expected = '<?xml version="1.0" encoding="UTF-8"?>\n<foo2/>'
    test = repo.fetchResource('test')
    test_helper.TestXslt(tester,test,sty,"<?xml version='1.0' encoding='UTF-8'?>\nFoo")
    tester.compare(expected,test.fetchResource('doc1').getContent(),func=TreeCompare.TreeCompare)
    repo.txCommit()

    tester.testDone()




def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()

    test = repo.createContainer('test')
    test.createRawFile('rf1','text/plain','RAW1')
    test.createDocument('doc1','<foo/>')
    repo.txCommit()
    tester.testDone()




def Test(tester):

    cleanup(tester)
    test_get_content(tester)
    test_set_content(tester)
