########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Common/MessageSource.py,v 1.1 2004/08/17 18:02:56 mbrown Exp $
"""
Error codes and messages for Ft.Server.Common

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft import TranslateMessage as _

class Error:
    INTERNAL_ERROR = 1

    PASSWDFILE_UNDEFINED = 10


g_errorMessages = {
    Error.INTERNAL_ERROR: _('There is an internal bug in 4Suite. '
        'Please make a post to the 4Suite mailing list to report this error '
        'message to the developers. Include platform details and info about '
        'how to reproduce the error. Info about the mailing list is at '
        'http://lists.fourthought.com/mailman/listinfo/4suite. '
        'The error code to report is: %s'),

    Error.PASSWDFILE_UNDEFINED: _('A suitable location for the password '
        'file could not be found. Please set the appropriate environment '
        'variable.')

}

