import XmlDocumentClient, GroupableObjectMixin
from Ft.Server.FtRpc import Commands

class UserClient(XmlDocumentClient.XmlDocumentClient,GroupableObjectMixin.GroupableObjectMixin):
    """
    A specialized Xml document which represents a sytem user
    """

    def get(self,name,defaultValue = None):
        """
        Implements python dictionary 'get' interface for the user data associated with this user
        """
        ud = self.getUserData()
        return ud.get(name,defaultValue)

    def getPassword(self):
        """
        Get the SHA1 hash of this users password
        """
        return Commands.RemoteMethodCommand(
            'getPassword', self._path,
            ()
            ).send(self._connection).results

    def getUsername(self):
        """
        Get the user name of this user.
        """
        return Commands.RemoteMethodCommand(
            'getUsername', self._path,
            ()
            ).send(self._connection).results

    def getUserData(self):
        """
        Returns a dictionary containing key value pairs of user data
        """
        return Commands.RemoteMethodCommand(
            'getUserData', self._path,
            ()
            ).send(self._connection).results

    def has_key(self,key):
        """
        Implements python dictionary 'has_key' interface
        """
        ud = self.getUserData()
        return ud.has_key(key)

    def items(self):
        """
        Implements python dictionary 'items' interface
        """
        ud = self.getUserData()
        return ud.items()

    def keys(self):
        """
        Implements python dictionary 'keys' interface
        """
        ud = self.getUserData()
        return ud.keys()


    def setPassword(self,newPasswd):
        Commands.RemoteMethodCommand(
            'setPassword', self._path,
            (newPasswd,)
            ).send(self._connection).results


    def setUserData(self,userData):
        """
        Sets the user data using the specified dictionary
        """
        Commands.RemoteMethodCommand(
            'setUserData', self._path,
            (userData,)
            ).send(self._connection).results


    def values(self):
        """
        Implements python dictionary 'values' interface
        """
        ud = self.getUserData()
        return ud.values()

    def __delitem__(self,name):
        """
        Implements python dictionary interface
        """
        ud = self.getUserData()
        del ud[name]
        self.setUserData(ud)

    def __getitem__(self,name):
        """
        Implements python dictionary interface
        """
        ud = self.getUserData()
        return ud[name]

    def __setitem__(self,name,value):
        """
        Implements python dictionary interface
        """
        ud = self.getUserData()
        ud[name] = value
        self.setUserData(ud)

    def _delete(self):

        for group in self.getGroups():
            group.removeMember(self)
        XmlDocumentImp.XmlDocumentImp._delete(self)



