/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mline.cpp,v 1.1 2000/10/09 17:55:51 jeh Exp $
 */
#define _MATH3D_EXPORT
#include <math3d/mline.h>


/*!
 * 
 */
Math3d::MLine::MLine()
  : d_p1(), d_p2() 
{
}


/*!
 * 
 */
Math3d::MLine::MLine(const M3d& p1, const M3d& p2)
  : d_p1(p1), d_p2(p2) 
{
}


/*!
 *
 */
Math3d::MLine::MLine(const MLine& line)
  : d_p1(line.d_p1), d_p2(line.d_p2)
{
}


/*!
 *
 */
const Math3d::MLine&
Math3d::MLine::operator=(const MLine& line)
{
  d_p1=line.d_p1;
  d_p2=line.d_p2;
  return(*this);
}


/*!
 *
 */
void
Math3d::MLine::copy(const MLine& line)
{
  d_p1=line.d_p1;
  d_p2=line.d_p2;
}


/*!
 *
 */
bool 
Math3d::MLine::operator==(const MLine& l) const
{
  return(cmp(l));
}


/*!
 *
 */
bool 
Math3d::MLine::operator!=(const MLine& l) const
{
  return(!cmp(l));
}


/*!
 *
 */
bool 
Math3d::MLine::cmp(const MLine& l, double epsilon) const
{
  return(
    d_p1.cmp(l.d_p1, epsilon) &&
    d_p2.cmp(l.d_p2, epsilon)
  );
}






