// -*- c++ -*-
#ifndef INCLUDED_MATH3D_M3FRAME_H
#define INCLUDED_MATH3D_M3FRAME_H
/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: m3frame.h,v 1.3 2000/10/09 12:17:54 jeh Exp $
 */

#ifndef INCLUDED_MATH3D_M3D_H
#include <math3d/m3d.h>
#endif

namespace Math3d {
  
  class M4x4;

/**
 * Frenet 3-frame.
 */
  class _CCMATH3D M3Frame {
    protected:  
      M3d d_pos;
      M3d d_right;  
      M3d d_dir;
      M3d d_up;  
    public:
      M3Frame();
      M3Frame(const M3d& pos, const M3d& right, const M3d& dir, const M3d& up);
      M3Frame(const M3Frame& fr);
      virtual ~M3Frame();
      
      const M3Frame& operator=(const M3Frame& fr);
      void copy(const M3Frame& fr);
      
      void setPos(const M3d& npos);
      void setView(const M3d& tgt, double roll);
      void setRDU(const M3d& nright, const M3d& ndir, const M3d& nup);
      
      void yaw(double angle);
      void pitch(double angle);
      void roll(double angle);
      void rotate(const MQuat& q);
      void pan(const M3d& delta);
      void setRotMatrix(const M4x4 &M);

      const M3d& getPos() const;
      const M3d& getDir() const;
      const M3d& getUp() const;
      const M3d& getRight() const;
      void getRotMatrix(M4x4 *M) const;
      void getViewMatrix(M4x4 *M) const;

      bool operator==(const M3Frame& fr) const;
      bool operator!=(const M3Frame& fr) const;
      bool cmp(const M3Frame& fr, double epsilon=EPSILON) const;
  };

}
#endif // INCLUDED_MATH3D_M3FRAME_H







