# $Id: junfold.rb,v 1.2 2001/04/13 06:20:49 nobu Exp $

module RD
  module Japanese
    UNFOLD = {
      "iso-2022-jp" => /\e\(B\n\s*\e\$B/n,
      "euc-jp" => /((?>(?:[\x8e\xa1-\xfe][\xa1-\xfe])+))\n\s*([\x8e\xa1-\xfe])/n,
      "shift_jis" => /((?>(?:[\x81-\x9f\xe0-\xfc][\x40-\x7e\x80-\xfc]|[\xa0-\xdf])+))\n\s*([\x81-\xfc])/n
    }

    def unfold(str, charset = @charset)
      if pat = UNFOLD[charset]
	str.gsub(pat, '\1\2')
      else
	str
      end
    end

    FOLD = {
      "iso-2022-jp" => [/\e\$B(?:[\x21-\x7f]{2})*(?:\x21\x23)+(?!$)/n, "\\&\n\e(B"],
      "euc-jp" => [/(?>(?!\xa1\xa3)[\x8e\xa1-\xfe][\xa1-\xfe])+(?:\xa1\xa3)+(?!$)/n],
      "shift_jis" => [/(?>(?!\x81\x42)(?:[\x81-\x9f\xe0-\xfc][\x40-\x7e\x80-\xfc]|[\xa0-\xdf]))+(?:\x81\x42)+(?!$)/n]
    }

    def fold(str, charset = @charset)
      if pat = FOLD[charset]
	pat, rep = pat
	str.gsub(pat, rep || "\\&\n")
      else
	str
      end
    end
  end

  class RD2HTMLVisitor < RDVisitor
    include Japanese

    %w[ItemListItem EnumListItem Footnote TextBlock].each do |el|
      el = "apply_to_#{el}"
      eval %{
	alias _#{el} #{el}
	def #{el}(element, content)
	  _#{el}(element, [fold(unfold(content.join("")))])
	end
      }
    end
  end
end
