#if   !defined(__DICTIONARY_HPP)
#define  __DICTIONARY_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__MAP_HPP)
#include <Map.hpp>
#endif

#if   !defined(__OBJECT_HPP)
#include <Object.hpp>
#endif

#include <string>

CORELINUX_MAP( DwordIdentifier, string, less<DwordIdentifier>, NameMap ) ;

/**
The Dictionary manages the identifier to object name information.
The names must be unique within case
*/

DECLARE_CLASS( Dictionary );

class Dictionary
{
public:

   //
   // Constructors and destructor
   //

                           /// Default constructor

                           Dictionary( void );

                           /// Copy constructor

                           Dictionary( DictionaryCref );

                           /// Virtual destructor

   virtual                 ~Dictionary( void );

            /// Assignment operator

            DictionaryRef  operator=( DictionaryCref );

            /// Equality operator

            bool           operator==( DictionaryCref ) const;

   //
   // Accessors
   //
            /**
            Retrieves the identifier key for a name
            @param string const reference to name
            @return Identifier for object name
            */

            DwordIdentifier  getIdentifierForName( const string & ) const;

            /**
            Retrieves the object name for the identifier key
            @param Identifier const reference to key
            @return string the object name
            */

            string      getNameForIdentifier( DwordIdentifierCref ) const;

            /**
            Retrieves the Identifier to Name map
            @return NameMap const reference
            */

            NameMapCref getMap( void ) const;

   //
   // Mutators
   //
            /// Add a new name with object identifier key

            void     addName( const string &, DwordIdentifierCref );

            /// Change the name of an object. Resolves key internally.

            void     changeName( const string &, const string & );

            /// Change the name of an object given its identifier key

            void     changeName( DwordIdentifierCref , const string & );

            /// Removes the entry from the dictionary

            void     removeName( const string & );

            /// Removes the entry from the dictionary

            void     removeName( DwordIdentifierCref );

protected:

private:

            NameMap  theNameMap;    /// The Identifier to Name map.


};

#endif // if !defined(__DICTIONARY_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.4 $
   $Date: 2000/08/31 22:47:56 $
   $Locker:  $
*/

