/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gnomevfs;

import org.gnu.glib.Flags;

/**
 */
public class VFSFileInfoOptions extends Flags {
    static final private int _DEFAULT = 0;

    static final public VFSFileInfoOptions DEFAULT = new VFSFileInfoOptions(_DEFAULT);

    static final private int _GET_MIME_TYPE = 1 << 0;

    static final public VFSFileInfoOptions GET_MIME_TYPE = new VFSFileInfoOptions(_GET_MIME_TYPE);

    static final private int _FORCE_FAST_MIME_TYPE = 1 << 1;

    static final public VFSFileInfoOptions FORCE_FAST_MIME_TYPE = new VFSFileInfoOptions(_FORCE_FAST_MIME_TYPE);

    static final private int _FORCE_SLOW_MIME_TYPE = 1 << 2;

    static final public VFSFileInfoOptions FORCE_SLOW_MIME_TYPE = new VFSFileInfoOptions(_FORCE_SLOW_MIME_TYPE);

    static final private int _FOLLOW_LINKS = 1 << 3;

    static final public VFSFileInfoOptions FOLLOW_LINKS = new VFSFileInfoOptions(_FOLLOW_LINKS);

    static final private int _GET_ACCESS_RIGHTS = 1 << 4;

    static final public VFSFileInfoOptions GET_ACCESS_RIGHTS = new VFSFileInfoOptions(_GET_ACCESS_RIGHTS);

    static final private VFSFileInfoOptions[] theInterned = new VFSFileInfoOptions[] { 
    		DEFAULT, GET_MIME_TYPE, FORCE_FAST_MIME_TYPE, FORCE_SLOW_MIME_TYPE, FOLLOW_LINKS,  
    		GET_ACCESS_RIGHTS};

    static private java.util.Hashtable theInternedExtras;

    static final private VFSFileInfoOptions theSacrificialOne = new VFSFileInfoOptions(0);

    static public VFSFileInfoOptions intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        VFSFileInfoOptions already = (VFSFileInfoOptions) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new VFSFileInfoOptions(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private VFSFileInfoOptions(int value) {
        value_ = value;
    }

    public VFSFileInfoOptions or(VFSFileInfoOptions other) {
        return intern(value_ | other.value_);
    }

    public VFSFileInfoOptions and(VFSFileInfoOptions other) {
        return intern(value_ & other.value_);
    }

    public VFSFileInfoOptions xor(VFSFileInfoOptions other) {
        return intern(value_ ^ other.value_);
    }

    public boolean test(VFSFileInfoOptions other) {
        return (value_ & other.value_) == other.value_;
    }
}
