/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
    newuser.c: Functions to create a GnomeDruid which guides a new user 
               through the initial settings process (QTH, satlists etc.)


  Copyright (C)  2001-2003  Alexandru Csete.

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/


/********* FIXME: This file needs some major clean-up before adding new stuff! */




#include <sys/stat.h>
#include <gnome.h>
#include <libgnomeui/gnome-window-icon.h>
#include <stdio.h>
#include "defaults.h"
#include "newuser-tle.h"
#include "newuser.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif


GtkWidget *druidwin;
GtkWidget *gstn_name,*gstn_desc;                /* name and descr. entries */
GtkWidget *qth_loc,*latsp,*lonsp,*altsp;        /* location, lat, lon and alt entries */
gboolean USEROK = FALSE;
gchar *path,*listmp;

/* QTH info from Predict - if found */
gchar *pcall,*pdesc,*ploc;
gfloat plat,plon;
gint palt;


GdkColor mainbg,logobg;


extern GtkWidget *app;

/* Function prototypes */
static GtkWidget *qth_name_widget_init (void);
static GtkWidget *qth_loc_widget_init (void);
static void city_cb (GtkWidget *, gpointer);
static void citysel_cb (GtkCList *,gint,gint,GdkEventButton *,gpointer);
static void cityunsel_cb (GtkCList *,gint,gint,GdkEventButton *,gpointer);
static void def_cb (GtkWidget *, gpointer);
static void finish_cb (GnomeDruid *, gpointer);
static void cancel_cb (GnomeDruid *, gpointer);

const gchar desc1[] = {
	N_("On the following page you will be asked to specify your\n"\
	   "default location (QTH). You will have the possibility to\n"\
	   "select from a list or enter your own values.\n\n"\
	   "Please note, that you have to go through this procedure\n"\
	   "in order to be able to run Gnome Predict.\n")
/** FIXME: "You can alway reconfigure...! */
};

const gchar desc2[] = {
	N_("Select a location from the list:")
};

const gchar desc3a[] = {
	N_("Or enter the proper values:")
};

const gchar finish[] = {
	N_("Gnome Predict should now be configured properly.\n"\
	   "You can continue by pressing \"Finish\".\n\n"\
	   "If you have any comments, questions or bugreports\n"\
	   "you can post them using the project pages at SourceForge.\n\n"\
	   "HAPPY TRACKING!")
};



void newuser_init ()
{
	GtkWidget *newdruid;              /* druid and window */
	GtkWidget *pstart,*p1,*pend;      /* druid pages */
	GdkImlibImage *img;               /* logo */
	gchar *path;


	/* initialize colors */
	mainbg.red   = (gushort)0xFFFF;
	mainbg.green = (gushort)0xFFFF;
	mainbg.blue  = (gushort)0xFFFF;
	logobg.red   = (gushort)6425;
	logobg.green = (gushort)6425;
	logobg.blue  = (gushort)28784;

	path = g_strconcat (PACKAGE_PIXMAPS_DIR, G_DIR_SEPARATOR_S,
			    "icons", G_DIR_SEPARATOR_S, "gpredict-icon.png",NULL);
	img = gdk_imlib_load_image (path);

	/* create the druid and add the pages */
	newdruid = gnome_druid_new ();
	gtk_signal_connect (GTK_OBJECT (newdruid), "cancel",
			    GTK_SIGNAL_FUNC (cancel_cb) , NULL );


	/* Create the druid pages */
	/* startpage */
	pstart = gnome_druid_page_start_new_with_vals (_("Welcome to Gnome Predict !"),
						       desc1, img, NULL );
	gnome_druid_page_start_set_logo_bg_color (GNOME_DRUID_PAGE_START (pstart),
						  &logobg );
	/* add page to druid */
	gnome_druid_prepend_page (GNOME_DRUID (newdruid),
				  GNOME_DRUID_PAGE (pstart) );

	/* Ground Station Information */
	/* Check if QTH file exists */
//	if (!g_file_test (gnome_config_get_string (QTH_FILE_PATH), G_FILE_TEST_ISFILE)) {
	p1 = gnome_druid_page_standard_new_with_vals (_("Groundstation Information"), img);
	gnome_druid_page_standard_set_logo_bg_color (GNOME_DRUID_PAGE_STANDARD (p1),
						     &logobg );
	gtk_container_set_border_width( GTK_CONTAINER ((GNOME_DRUID_PAGE_STANDARD (p1))->vbox), 10 );
	/* add contents to the groundstation page */
	gtk_box_pack_start (GTK_BOX ((GNOME_DRUID_PAGE_STANDARD (p1))->vbox ),
			    qth_name_widget_init (), FALSE, FALSE, 10 );
	gtk_box_pack_start (GTK_BOX ((GNOME_DRUID_PAGE_STANDARD (p1))->vbox ),
			    gtk_hseparator_new (), FALSE, FALSE, 0 );
	gtk_box_pack_start (GTK_BOX ((GNOME_DRUID_PAGE_STANDARD (p1))->vbox ),
			    qth_loc_widget_init (), TRUE, TRUE, 10 );
	/* add page to druid */
	gnome_druid_append_page (GNOME_DRUID (newdruid),
				 GNOME_DRUID_PAGE (p1) );

	gnome_druid_append_page (GNOME_DRUID (newdruid),
				 GNOME_DRUID_PAGE (newuser_tle_create ()));

//	}

	/* Check if .tle file already exists: Replace or update? */

	/* Satlist list file */
/*  	if (!g_file_test (gnome_config_get_string (SATLIST_LIST_FILE_PATH), G_FILE_TEST_ISFILE)) { */
/*  	} */

	/* and so on... */

	/* endpage */
	pend = gnome_druid_page_finish_new_with_vals (_("Configuration Complete !"),
						      finish, img, NULL );
	gnome_druid_page_finish_set_logo_bg_color (GNOME_DRUID_PAGE_FINISH (pend),
						   &logobg );
	gtk_signal_connect (GTK_OBJECT (pend), "finish",
			    GTK_SIGNAL_FUNC (finish_cb), NULL );
	/* add page to druid */
	gnome_druid_append_page (GNOME_DRUID (newdruid),
				 GNOME_DRUID_PAGE (pend) );


	/* create a toplevel window to put the druid in */
	druidwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (druidwin),
			      _("Gnome Predict Configuration Druid") );
	gnome_window_icon_set_from_file (GTK_WINDOW (druidwin),
					 path );
	gtk_container_add (GTK_CONTAINER (druidwin),
			   GTK_WIDGET (newdruid) );
	gtk_widget_show_all (druidwin);

	g_free (path);
	gdk_imlib_destroy_image (img);
}


static GtkWidget
*qth_name_widget_init ()
{
        /* This function creates a widget containing entries for   
	   the groundstation name and description. It can be packed
	   into a standard Druid page.
        */ 
	GtkWidget *l1,*l2,*l3,*l4;
	GtkWidget *gstn_table;

	/* labels */
	l1 = gtk_label_new (_("Name/Call"));
	l2 = gtk_label_new (_("Description"));
	l3 = gtk_label_new (_("(optional)"));
	l4 = gtk_label_new (_("(optional)"));

	/* entry boxes */
	gstn_name = gtk_entry_new ();
	gstn_desc = gtk_entry_new ();

	/* table */
	gstn_table = gtk_table_new (3, 2, FALSE);
	gtk_table_attach (GTK_TABLE (gstn_table), GTK_WIDGET (l1),
			  0, 1, 0, 1,
			  GTK_FILL, GTK_SHRINK, 10, 0 );
	gtk_misc_set_alignment (GTK_MISC (l1), 0.0f, 0.0f );
	gtk_table_attach (GTK_TABLE (gstn_table), GTK_WIDGET (l2),
			  0, 1, 1, 2,
			  GTK_FILL, GTK_SHRINK, 10, 0 );
	gtk_misc_set_alignment (GTK_MISC (l2), 0.0f, 0.0f );
	gtk_table_attach (GTK_TABLE (gstn_table), GTK_WIDGET (l3),
			  2, 3, 0, 1,
			  GTK_FILL, GTK_SHRINK, 10, 0 );
	gtk_misc_set_alignment (GTK_MISC (l3), 0.0f, 0.0f );
	gtk_table_attach (GTK_TABLE (gstn_table), GTK_WIDGET (l4),
			  2, 3, 1, 2,
			  GTK_FILL, GTK_SHRINK, 10, 0 );
	gtk_misc_set_alignment (GTK_MISC (l4), 0.0f, 0.0f );
	gtk_table_attach (GTK_TABLE (gstn_table), GTK_WIDGET (gstn_name),
			  1, 2, 0, 1,
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL | GTK_EXPAND,
			  10, 0 );
	gtk_table_attach (GTK_TABLE (gstn_table), GTK_WIDGET (gstn_desc),
			  1, 2, 1, 2,
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL | GTK_EXPAND,
			  10, 0 );
	return gstn_table;
}


static GtkWidget
*qth_loc_widget_init ()
{
	/* This function creates a widget containing entries for
	   the groundstation location. It can be packed into a
	   standard Druid page.
	*/


	FILE *cityfile;	
	GtkWidget *table,*citybut,*defbut,*helpbut,*label;
	GtkObject *latad,*lonad,*altad;
	GtkTooltips *kooltip;
	gchar *tmp,**ptmp;


	table = gtk_table_new (4, 4, FALSE);
	gtk_table_set_col_spacings (GTK_TABLE (table), 10);
	gtk_table_set_row_spacings (GTK_TABLE (table), 10);

	/* Location Entry */
	label = gtk_label_new (_("Location"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (label),
				   0, 1, 0, 1 );
	qth_loc = gtk_entry_new ();
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (qth_loc),
				   1, 3, 0, 1);
	label = gtk_label_new (_("(optional)"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (label),
				   3, 4, 0, 1 );
	
	/* Latitude labels/spinner */
	label = gtk_label_new (_("Latitude"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (label),
				   0, 1, 1, 2 );
	latad = gtk_adjustment_new (0.0, -90, +90, 0.01, 1.0, 0.0);
	latsp = gtk_spin_button_new (GTK_ADJUSTMENT (latad), 0.5, 2);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (latsp), TRUE);
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (latsp),
				   1, 2, 1, 2 );
	label = gtk_label_new (_("dec. deg. NORTH (south=negative)"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (label),
				   2, 3, 1, 2 );
	/* Longitude labels/spinner */
	label = gtk_label_new (_("Longitude"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (label),
				   0, 1, 2, 3 );
	lonad = gtk_adjustment_new (0.0, -180, +180, 0.01, 1.0, 0.0);
	lonsp = gtk_spin_button_new (GTK_ADJUSTMENT (lonad), 0.5, 2);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (lonsp), TRUE);
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (lonsp),
				   1, 2, 2, 3);
	label = gtk_label_new (_("dec. deg. WEST (east=negative)"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (label),
				   2, 3, 2, 3 );
	/* Altitude spinner */
	label = gtk_label_new (_("Altitude"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (label),
				   0, 1, 3, 4 );
	altad = gtk_adjustment_new (0.0, -1000, +10000, 1, 100, 0.0);
	altsp = gtk_spin_button_new (GTK_ADJUSTMENT (altad), 0.5, 0);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (altsp), TRUE);
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (altsp),
				   1, 2, 3, 4);
	label = gtk_label_new (_("meters"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (label),
				   2, 3, 3, 4 );


	/* Check whether we have a ~/.groundstation/default.qth file.
	   If yes read the values and let the user confirm.
	*/
	tmp = g_strconcat (g_get_home_dir () , G_DIR_SEPARATOR_S,
			   ".groundstation", G_DIR_SEPARATOR_S,
			   "default.qth", NULL );
	if ( (cityfile = fopen (tmp, "r")) ) {
		g_free (tmp); /* so we can reuse it */
		/* callsign */
		tmp = g_malloc (80);
		tmp = fgets (tmp, 80, cityfile);
		ptmp = g_strsplit (tmp, "\n", 2);
		pcall = g_strdup (ptmp[0]);
		g_free (tmp);
		g_strfreev (ptmp);
		gtk_entry_set_text (GTK_ENTRY (gstn_name), pcall);
		/* description */
		tmp = g_malloc (80);
		tmp = fgets (tmp, 80, cityfile);
		ptmp = g_strsplit (tmp, "\n", 2);
		pdesc = g_strdup (ptmp[0]);
		g_free (tmp);
		g_strfreev (ptmp);
		gtk_entry_set_text (GTK_ENTRY (gstn_desc), pdesc);
		/* Location */
		tmp = g_malloc (80);
		tmp = fgets (tmp, 80, cityfile);
		ptmp = g_strsplit (tmp, "\n", 2);
		ploc = g_strdup (ptmp[0]);
		g_free (tmp);
		g_strfreev (ptmp);
		gtk_entry_set_text (GTK_ENTRY (qth_loc), ploc);
		
		tmp = g_malloc (20);
		tmp = fgets (tmp, 20, cityfile);    /* lat */
		plat = g_strtod (tmp, NULL);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (latsp), plat);
		tmp = fgets (tmp, 20, cityfile);    /* lon */
		plon = g_strtod (tmp, NULL);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (lonsp), plon);
		tmp = fgets (tmp, 20, cityfile);    /* alt */
		palt = g_strtod (tmp, NULL);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (altsp), palt);
		g_free (tmp);
		
		fclose (cityfile);
	}
	else {
		g_free (tmp);

		/* do we have a predict.qth? */
		tmp = g_strconcat (g_get_home_dir () , G_DIR_SEPARATOR_S,
				   ".predict", G_DIR_SEPARATOR_S,
				   "predict.qth", NULL );
		if ( (cityfile = fopen (tmp, "r")) ) {
			g_free (tmp); /* so we can reuse it */
			tmp = g_malloc (80);
			tmp = fgets (tmp, 80, cityfile); /* callsign */
			ptmp = g_strsplit (tmp, "\n", 2);
			pcall = g_strdup (ptmp[0]);
			g_free (tmp);
			g_strfreev (ptmp);
			gtk_entry_set_text (GTK_ENTRY (gstn_name), pcall);
			tmp = g_malloc (20);
			tmp = fgets (tmp, 20, cityfile);    /* lat */
			plat = g_strtod (tmp, NULL);
			gtk_spin_button_set_value (GTK_SPIN_BUTTON (latsp), plat);
			tmp = fgets (tmp, 20, cityfile);    /* lon */
			plon = g_strtod (tmp, NULL);
			gtk_spin_button_set_value (GTK_SPIN_BUTTON (lonsp), plon);
			tmp = fgets (tmp, 20, cityfile);    /* alt */
			palt = g_strtod (tmp, NULL);
			gtk_spin_button_set_value (GTK_SPIN_BUTTON (altsp), palt);
			g_free (tmp);
			
			fclose (cityfile);
		}
		else { 
			g_free (tmp);
		}
	}

	/* Select city button */
	citybut = gnome_pixmap_button (gnome_stock_pixmap_widget (druidwin, GNOME_STOCK_PIXMAP_INDEX),
				       _("Cities"));
	gtk_signal_connect (GTK_OBJECT (citybut), "clicked",
			    GTK_SIGNAL_FUNC (city_cb), NULL );
	kooltip = gtk_tooltips_new ();
	gtk_tooltips_set_tip (kooltip, citybut, _("Select a city from a list."),
			      "?");
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (citybut),
				   3, 4, 1, 2);

	/* Default location button */
	defbut = gnome_pixmap_button (gnome_stock_pixmap_widget (druidwin, GNOME_STOCK_PIXMAP_COPY),
				       _("Default"));
	gtk_signal_connect (GTK_OBJECT (defbut), "clicked",
			    GTK_SIGNAL_FUNC (def_cb), NULL);
	kooltip = gtk_tooltips_new ();
	gtk_tooltips_set_tip (kooltip, defbut, _("Reset to values from \"predict.qth\" (if found)."),
			      "?" );
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (defbut),
				   3, 4, 2, 3);
	if (!pcall)
		gtk_widget_set_sensitive (GTK_WIDGET (defbut), FALSE);

	/* Help Button */
	helpbut = gnome_pixmap_button (gnome_stock_pixmap_widget (druidwin, GNOME_STOCK_PIXMAP_HELP),
				       _("Help") );
/*	gtk_signal_connect (GTK_OBJECT (helpbut), "clicked",
	GTK_SIGNAL_FUNC (help_cb), NULL);*/
	gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (helpbut),
				   3, 4, 3, 4);
	gtk_widget_set_sensitive (GTK_WIDGET (helpbut), FALSE);

	/* Data file containing locations */
	path = g_strconcat (PACKAGE_DATA_DIR, G_DIR_SEPARATOR_S,
			    "cities.dat", NULL);
	if ( !(cityfile = fopen(path,"r")) ) {
		/* Deactivate city buttin */
		gtk_widget_set_sensitive (GTK_WIDGET (citybut), FALSE);
	} 
	else 
		fclose (cityfile);


	return table;
}


static void
city_cb (GtkWidget *widget, gpointer data)
{
        /* This function is called when the user clicks on the
	   "Cities" button.
	*/
	FILE *cityfile;
	GtkWidget *dialog,*citylist,*swin;
	gchar *line,**val;

	/* create a clist widget to show the cities */
	citylist = gtk_clist_new (4);
	gtk_clist_set_column_title (GTK_CLIST (citylist),
				    0, _("Location"));
	gtk_clist_set_column_justification (GTK_CLIST (citylist),
					    0, GTK_JUSTIFY_LEFT);
	gtk_clist_set_column_title (GTK_CLIST (citylist),
				    1, _("Latitude"));
	gtk_clist_set_column_justification (GTK_CLIST (citylist),
					    1, GTK_JUSTIFY_RIGHT);
	gtk_clist_set_column_title (GTK_CLIST (citylist),
				    2, _("Longitude"));
	gtk_clist_set_column_justification (GTK_CLIST (citylist),
					    2, GTK_JUSTIFY_RIGHT);
	gtk_clist_set_column_title (GTK_CLIST (citylist),
				    3, _("Altitude"));
	gtk_clist_set_column_justification (GTK_CLIST (citylist),
					    3, GTK_JUSTIFY_RIGHT);
	gtk_clist_column_titles_show (GTK_CLIST (citylist));
	gtk_clist_column_titles_passive (GTK_CLIST (citylist));

	gtk_signal_connect (GTK_OBJECT (citylist), "select-row",
			    GTK_SIGNAL_FUNC (citysel_cb), NULL );
	gtk_signal_connect (GTK_OBJECT (citylist), "unselect-row",
			    GTK_SIGNAL_FUNC (cityunsel_cb), NULL );
	
	if ( (cityfile = fopen(path,"r")) ) {
		/* read in the data */
		line = g_malloc (80);
		while ( (line = fgets (line, 80, cityfile)) ) {
			val = g_strsplit (line, ";", 4);
			gtk_clist_append (GTK_CLIST (citylist), val );
			g_strfreev (val);
		}
		fclose (cityfile);
		g_free (line);
	}

	gtk_clist_set_column_width (GTK_CLIST (citylist), 1,
				    gtk_clist_optimal_column_width (GTK_CLIST (citylist),
								    1 ) );
	gtk_clist_set_column_width (GTK_CLIST (citylist), 2,
				    gtk_clist_optimal_column_width (GTK_CLIST (citylist),
								    2 ) );
	gtk_clist_set_column_width (GTK_CLIST (citylist), 3,
				    gtk_clist_optimal_column_width (GTK_CLIST (citylist),
								    3 ) );
	gtk_clist_set_column_width (GTK_CLIST (citylist), 0,
				    gtk_clist_optimal_column_width (GTK_CLIST (citylist),
								    0 ) );
	/* scrolled window to pack the citylist into */
	swin = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
					 GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS );
	gtk_container_add (GTK_CONTAINER (swin), citylist);
	
	/* create the dialog window */
	dialog = gnome_dialog_new (_("City List"), GNOME_STOCK_BUTTON_OK, NULL);
	gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
	gtk_window_set_default_size (GTK_WINDOW (dialog), 450, 500);
	gnome_dialog_set_parent (GNOME_DIALOG (dialog), GTK_WINDOW (druidwin));
	gnome_dialog_set_close (GNOME_DIALOG (dialog), TRUE);
	
	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox),
			    swin, TRUE, TRUE, 0);
	
	gtk_widget_show_all (dialog);
	
}



static void
citysel_cb (GtkCList *list, gint row, gint col,
	    GdkEventButton *event, gpointer data )
{
	/* This function is called when the user
	   selects a city from the list.
	*/
	if ( gtk_clist_get_text (list, row, 0, &listmp) )
		gtk_entry_set_text (GTK_ENTRY (qth_loc), listmp);
	if ( gtk_clist_get_text (list, row, 1, &listmp))
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (latsp),
					   g_strtod (listmp, NULL));
	if ( gtk_clist_get_text (list, row, 2, &listmp))
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (lonsp),
					   g_strtod (listmp, NULL));
	if ( gtk_clist_get_text (list, row, 3, &listmp))
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (altsp),
					   g_strtod (listmp, NULL));
}


static void
cityunsel_cb (GtkCList *list, gint row, gint col,
	      GdkEventButton *event, gpointer data )
{
/* This function is called when the user
   unselects a city from the list.
*/

}


static void
def_cb (GtkWidget *widget, gpointer data)
{
	/* This function is called when the user clicks on the
	   "Default" button.
	*/
	if (pcall) {
		gtk_entry_set_text (GTK_ENTRY (gstn_name), pcall);
		if (ploc)
			gtk_entry_set_text (GTK_ENTRY (qth_loc), ploc);
		if (pdesc)
			gtk_entry_set_text (GTK_ENTRY (gstn_desc), pdesc);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (latsp), plat);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (lonsp), plon);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (altsp), palt);
	}
	else {
		gtk_entry_set_text (GTK_ENTRY (gstn_name), _("SomeStation"));
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (latsp), 0.0);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (lonsp), 0.0);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (altsp), 0.0);

	}
}



static void
finish_cb (GnomeDruid *druid, gpointer data)
{
	/* This function is called if the user clicks on the
	   finish button. This will set the USEROK to TRUE.
	   so the main program can start up after finishing.
	*/
	FILE *qthfile;
	gchar *path;

	USEROK = TRUE;
	
	/* create .gpredict if it doesn't exist */
	path = g_strconcat (g_get_home_dir (), G_DIR_SEPARATOR_S,
			    ".gpredict", NULL);
	if ( !g_file_test (path, G_FILE_TEST_ISDIR))
		mkdir (path, 511);
	g_free (path);

	/* create .groundstation/default.qth  */
	path = g_strconcat (g_get_home_dir (), G_DIR_SEPARATOR_S,
			    ".gpredict", G_DIR_SEPARATOR_S,
			    "default.qth", NULL );
	if ( (qthfile = fopen (path, "w")) ) {
		fprintf (qthfile, "%s \n%s \n%s \n%.2f\n%.2f\n%d\n",
			 gtk_entry_get_text (GTK_ENTRY (gstn_name)),
			 gtk_entry_get_text (GTK_ENTRY (gstn_desc)),
			 gtk_entry_get_text (GTK_ENTRY (qth_loc)),
			 gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (latsp)),
			 gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (lonsp)),
			 gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (altsp)) );

		fclose (qthfile);
		gnome_config_set_string (QTH_FILE_PATH, path);
		gnome_config_sync ();
	}
	else {
		gnome_app_error (GNOME_APP (app), _("There was an error creating the QTH file!"));
		USEROK = FALSE;
	}
	g_free (path);
	gtk_widget_destroy (GTK_WIDGET (druidwin));
	if (pcall)
		g_free (pcall);
	if (ploc)
		g_free (ploc);
	if (pdesc)
		g_free (pdesc);
	gtk_main_quit ();
}



static void
cancel_cb (GnomeDruid *druid, gpointer data)
{
	/* This function is called if the user clicks on the
	   cancel button. This will quit the program, that is
	   leave the USEROK at FALSE.
	*/
	USEROK = FALSE;
	gtk_widget_destroy (GTK_WIDGET (druidwin));
	if (pcall)
		g_free (pcall);
	if (ploc)
		g_free (ploc);
	if (pdesc)
		g_free (pdesc);
	gtk_main_quit ();
}
