# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter options used to start a project in the VCS.
"""

import os

from qt import *

from KdeQt import KQFileDialog

from OptionsForm import SvnOptionsForm
from Config import ConfigSvnProtocols

class SvnOptionsDialog(SvnOptionsForm):
    """
    Class implementing a dialog to enter options used to start a project in the repository.
    """
    def __init__(self, project, parent=None):
        """
        Constructor
        
        @param project reference to the project object
        @param parent parent widget (QWidget)
        """
        SvnOptionsForm.__init__(self, parent, None, 1)
        
        self.project = project
        
        self.protocolCombo.insertStringList(ConfigSvnProtocols)
        
        hd = QDir.convertSeparators(QDir.homeDirPath())
        hd = os.path.join(unicode(hd), 'subversionroot')
        self.vcsDirectoryEdit.setText(hd)
        
    def handleDirectory(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.vcsDirectoryEdit.text(),
            self, None, self.trUtf8("Select Repository-Directory"), 1)
            
        if not directory.isNull():
            self.vcsDirectoryEdit.setText(QDir.convertSeparators(directory))
        
    def handleProtocol(self, protocol):
        """
        Private slot to switch the status of the directory selection button.
        """
        if str(protocol) == "file://":
            self.vcsDirButton.setEnabled(1)
        else:
            self.vcsDirButton.setEnabled(0)
        
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a tuple of 5 strings and one boolean (repository URL,
            archive name (always empty), vendor label (always empty),
            log message, release label (always empty), standard layout).
        """
        return (\
            '%s%s' % (str(self.protocolCombo.currentText()),
                      unicode(self.vcsDirectoryEdit.text())),
            '',
            '',
            unicode(self.vcsLogEdit.text()),
            '',
            self.layoutCheckBox.isChecked()
        )
