/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.util.printf;

import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;

/**
 *
 */
class IntegerFormatter extends DataFormatter {
    protected int radix;
/**
 * IntegerFormatter constructor comment.
 * @param format java.lang.String
 * @exception com.sap.dbtech.util.printf.FormatException The exception description.
 */
protected IntegerFormatter(String format) throws FormatException {
    super(format);
    switch (this.kind) {
        case 'o':
            this.radix = 8;
            break;
        case 'x':
            this.radix = 16;
            break;
        default:
            this.radix = 10;
            break;
    }
}
/**
 * formatObject method comment.
 */
protected String formatObject(Object obj, int kind, int width, int precision, boolean alignRight, char padChar)
        throws PrintfArgumentMismatch
{
    Number number;
    long longVal;
    String stringVal;

    try {
        number = (Number) obj;
    }
    catch (ClassCastException exc) {
        throw new PrintfArgumentMismatch (MessageTranslator.translate(MessageKey.ERROR_FORMAT_NOTANUMBER,
                                                                      obj.toString()));

    }
    if (!alignRight) {
        padChar = ' ';  // left paddding always done using blanks
    }
    longVal = number.longValue ();
    stringVal = Long.toString (longVal, this.radix);;
    return this.formatString (stringVal, kind, width, precision, alignRight, padChar);
}
}
