/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/


package com.sap.dbtech.jdbc;

import java.sql.*;

import com.sap.dbtech.jdbc.packet.*;

/**
 *
 */
public class PeekAndPoke
{
    /**
     * make PeekAndPoke uninstantiable
     */
    private
    PeekAndPoke ()
    {
    }
    /**
     *
     */
    static public byte []
    getParseId (PreparedStatement stmt)
    {
        byte [] result;
        CallableStatementSapDB realStmt;

        realStmt = (CallableStatementSapDB) stmt;
        if (realStmt.parseinfo.getMassParseid() != null) {
            result = realStmt.parseinfo.getMassParseid();
        }
        else {
            result = realStmt.parseinfo.getParseId();
        }
        return result;
    }
    /**
     *
     */
    static public byte []
    getParseIdForMonitor (PreparedStatement stmt)
    {
        byte [] result = getParseId (stmt);

        if (result != null) {
            result [result.length - 2] = 0;
        }
        return result;
    }
    /**
     *
     */
    static public void
    syntaxCheck (
        Connection connArg,
        String sqlCmd)
    throws SQLException
    {
        ConnectionSapDB connection = (ConnectionSapDB) connArg;
        RequestPacket requestPacket = connection.getRequestPacket ();
        requestPacket.initSyntaxOnlyCommand (sqlCmd);
        connection.execute (requestPacket, connection, ConnectionSapDB.GC_ALLOWED);
    }

    static public Parseinfo getParseinfo(PreparedStatement stmt) {
      CallableStatementSapDB realStmt = (CallableStatementSapDB) stmt;
      return realStmt.parseinfo;
    }
}

