/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import java.sql.SQLException;
import java.util.Vector;

public abstract class GarbageCan {
    private Vector garbage;
    private int canTresholdC = 20;
    private boolean objPending = false;
    private boolean currentEmptyRun = false;
    private boolean currentEmptyRun2 = false;

    public GarbageCan() {
        this(20);
    }

    public GarbageCan(int n) {
        this.canTresholdC = n;
        this.garbage = new Vector(n);
    }

    public boolean isPending() {
        this.objPending = this.garbage.size() >= this.canTresholdC;
        return this.objPending;
    }

    public final void throwIntoGarbageCan(Object object) {
        this.garbage.addElement(object);
    }

    public final void forceGarbageCollection() {
        this.objPending = true;
    }

    public final synchronized boolean emptyCan(RequestPacket requestPacket) {
        if (this.currentEmptyRun2) {
            return false;
        }
        this.currentEmptyRun2 = true;
        boolean bl = false;
        int n = this.garbage.size();
        while (n > 0 && !bl) {
            Object e = this.garbage.remove(n - 1);
            boolean bl2 = bl = !this.packetAction(requestPacket, e);
            if (bl) {
                this.garbage.addElement(e);
            }
            --n;
        }
        this.currentEmptyRun2 = false;
        return !bl;
    }

    public final void emptyCan(ConnectionSapDB connectionSapDB) {
        if (this.currentEmptyRun) {
            return;
        }
        this.currentEmptyRun = true;
        this.objPending = false;
        while (this.garbage.size() > 0) {
            try {
                RequestPacket requestPacket = connectionSapDB.getRequestPacket();
                requestPacket.initializePacket((short)Short.MAX_VALUE);
                this.emptyCan(requestPacket);
                connectionSapDB.execute(requestPacket, this, 3);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.currentEmptyRun = false;
    }

    public final void emptyCan() {
        this.garbage.removeAllElements();
    }

    public abstract boolean packetAction(RequestPacket var1, Object var2);
}

