import { FileService } from '@vscode/emmet-helper';
import { CompletionList, Hover, Position, SymbolInformation, Range, WorkspaceEdit, LinkedEditingRanges, CompletionContext, FoldingRange, DocumentHighlight } from 'vscode-languageserver';
import { DocumentManager, Document } from '../../lib/documents';
import { LSConfigManager } from '../../ls-config';
import { HoverProvider, CompletionsProvider, RenameProvider, LinkedEditingRangesProvider, FoldingRangeProvider, DocumentHighlightProvider } from '../interfaces';
export declare class HTMLPlugin implements HoverProvider, CompletionsProvider, RenameProvider, LinkedEditingRangesProvider, FoldingRangeProvider, DocumentHighlightProvider {
    private configManager;
    private fileSystemProvider;
    private workspaceFolders;
    __name: string;
    private lang;
    private documents;
    private styleScriptTemplate;
    private htmlTriggerCharacters;
    private loadedEmmetExtensionsPaths;
    constructor(docManager: DocumentManager, configManager: LSConfigManager, fileSystemProvider: FileService, workspaceFolders: {
        name: string;
        uri: string;
    }[]);
    private reloadEmmetExtensionsIfNeeded;
    doHover(document: Document, position: Position): Hover | null;
    getCompletions(document: Document, position: Position, completionContext?: CompletionContext): Promise<CompletionList | null>;
    /**
     * The HTML language service uses newer types which clash
     * without the stable ones. Transform to the stable types.
     */
    private toCompletionItems;
    private isInComponentTag;
    private getLangCompletions;
    doTagComplete(document: Document, position: Position): string | null;
    private isInsideMoustacheTag;
    getDocumentSymbols(document: Document): SymbolInformation[];
    rename(document: Document, position: Position, newName: string): WorkspaceEdit | null;
    prepareRename(document: Document, position: Position): Range | null;
    getLinkedEditingRanges(document: Document, position: Position): LinkedEditingRanges | null;
    getFoldingRanges(document: Document): FoldingRange[];
    findDocumentHighlight(document: Document, position: Position): DocumentHighlight[] | null;
    /**
     * Returns true if rename happens at the tag name, not anywhere inbetween.
     */
    private isRenameAtTag;
    private getCustomDataProviders;
    private featureEnabled;
}
