/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.ByteStreams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.CDexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBuffer;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.jf.dexlib2.util.DexUtil;
import org.jf.util.AbstractForwardSequentialList;

public class OatFile
extends DexBuffer
implements MultiDexContainer<DexBackedDexFile> {
    private static final byte[] ELF_MAGIC = new byte[]{127, 69, 76, 70};
    private static final byte[] OAT_MAGIC = new byte[]{111, 97, 116, 10};
    private static final int MIN_ELF_HEADER_SIZE = 52;
    private static final int MIN_OAT_VERSION = 56;
    private static final int MAX_OAT_VERSION = 178;
    public static final int UNSUPPORTED = 0;
    public static final int SUPPORTED = 1;
    public static final int UNKNOWN = 2;
    private final boolean is64bit;
    @Nonnull
    private final OatHeader oatHeader;
    @Nonnull
    private final Opcodes opcodes;
    @Nullable
    private final VdexProvider vdexProvider;

    public OatFile(@Nonnull byte[] buf) {
        this(buf, null);
    }

    public OatFile(@Nonnull byte[] buf, @Nullable VdexProvider vdexProvider) {
        super(buf);
        if (buf.length < 52) {
            throw new NotAnOatFileException();
        }
        OatFile.verifyMagic(buf);
        if (buf[4] == 1) {
            this.is64bit = false;
        } else if (buf[4] == 2) {
            this.is64bit = true;
        } else {
            throw new InvalidOatFileException(String.format("Invalid word-size value: %x", buf[5]));
        }
        OatHeader oatHeader = null;
        SymbolTable symbolTable = this.getSymbolTable();
        for (SymbolTable.Symbol symbol : symbolTable.getSymbols()) {
            if (!symbol.getName().equals("oatdata")) continue;
            oatHeader = new OatHeader(symbol.getFileOffset());
            break;
        }
        if (oatHeader == null) {
            throw new InvalidOatFileException("Oat file has no oatdata symbol");
        }
        this.oatHeader = oatHeader;
        if (!oatHeader.isValid()) {
            throw new InvalidOatFileException("Invalid oat magic value");
        }
        this.opcodes = Opcodes.forArtVersion(oatHeader.getVersion());
        this.vdexProvider = vdexProvider;
    }

    private static void verifyMagic(byte[] buf) {
        for (int i = 0; i < ELF_MAGIC.length; ++i) {
            if (buf[i] == ELF_MAGIC[i]) continue;
            throw new NotAnOatFileException();
        }
    }

    public static OatFile fromInputStream(@Nonnull InputStream is) throws IOException {
        return OatFile.fromInputStream(is, null);
    }

    public static OatFile fromInputStream(@Nonnull InputStream is, @Nullable VdexProvider vdexProvider) throws IOException {
        if (!is.markSupported()) {
            throw new IllegalArgumentException("InputStream must support mark");
        }
        is.mark(4);
        byte[] partialHeader = new byte[4];
        try {
            ByteStreams.readFully(is, partialHeader);
        }
        catch (EOFException ex) {
            throw new NotAnOatFileException();
        }
        finally {
            is.reset();
        }
        OatFile.verifyMagic(partialHeader);
        is.reset();
        byte[] buf = ByteStreams.toByteArray(is);
        return new OatFile(buf, vdexProvider);
    }

    public int getOatVersion() {
        return this.oatHeader.getVersion();
    }

    public int isSupportedVersion() {
        int version = this.getOatVersion();
        if (version < 56) {
            return 0;
        }
        if (version <= 178) {
            return 1;
        }
        return 2;
    }

    @Nonnull
    public List<String> getBootClassPath() {
        if (this.getOatVersion() < 75) {
            return ImmutableList.of();
        }
        String bcp = this.oatHeader.getKeyValue("bootclasspath");
        if (bcp == null) {
            return ImmutableList.of();
        }
        return Arrays.asList(bcp.split(":"));
    }

    @Nonnull
    public List<DexBackedDexFile> getDexFiles() {
        return new AbstractForwardSequentialList<DexBackedDexFile>(){

            @Override
            public int size() {
                return Iterators.size(Iterators.filter(new DexEntryIterator(), Objects::nonNull));
            }

            @Override
            @Nonnull
            public Iterator<DexBackedDexFile> iterator() {
                return Iterators.transform(Iterators.filter(new DexEntryIterator(), Objects::nonNull), new Function<OatDexEntry, DexBackedDexFile>(){

                    @Override
                    @Nullable
                    public DexBackedDexFile apply(OatDexEntry dexEntry) {
                        return dexEntry.getDexFile();
                    }
                });
            }
        };
    }

    @Override
    @Nonnull
    public List<String> getDexEntryNames() throws IOException {
        return new AbstractForwardSequentialList<String>(){

            @Override
            public int size() {
                return Iterators.size(Iterators.filter(new DexEntryIterator(), Objects::nonNull));
            }

            @Override
            @Nonnull
            public Iterator<String> iterator() {
                return Iterators.transform(Iterators.filter(new DexEntryIterator(), Objects::nonNull), new Function<OatDexEntry, String>(){

                    @Override
                    @Nullable
                    public String apply(OatDexEntry dexEntry) {
                        return dexEntry.entryName;
                    }
                });
            }
        };
    }

    @Nullable
    public OatDexEntry getEntry(@Nonnull String entryName) throws IOException {
        DexEntryIterator iterator = new DexEntryIterator();
        while (iterator.hasNext()) {
            OatDexEntry entry = iterator.next();
            if (entry == null || !entry.getEntryName().equals(entryName)) continue;
            return entry;
        }
        return null;
    }

    @Nonnull
    private List<SectionHeader> getSections() {
        int entryCount;
        int entrySize;
        int offset;
        if (this.is64bit) {
            offset = this.readLongAsSmallUint(40);
            entrySize = this.readUshort(58);
            entryCount = this.readUshort(60);
        } else {
            offset = this.readSmallUint(32);
            entrySize = this.readUshort(46);
            entryCount = this.readUshort(48);
        }
        if (offset + entrySize * entryCount > this.buf.length) {
            throw new InvalidOatFileException("The ELF section headers extend past the end of the file");
        }
        return new AbstractList<SectionHeader>(){

            @Override
            public SectionHeader get(int index) {
                if (index < 0 || index >= entryCount) {
                    throw new IndexOutOfBoundsException();
                }
                if (OatFile.this.is64bit) {
                    return new SectionHeader64Bit(offset + index * entrySize);
                }
                return new SectionHeader32Bit(offset + index * entrySize);
            }

            @Override
            public int size() {
                return entryCount;
            }
        };
    }

    @Nonnull
    private SymbolTable getSymbolTable() {
        for (SectionHeader header : this.getSections()) {
            if (header.getType() != 11) continue;
            return new SymbolTable(header);
        }
        throw new InvalidOatFileException("Oat file has no symbol table");
    }

    @Nonnull
    private StringTable getSectionNameStringTable() {
        int index = this.readUshort(50);
        if (index == 0) {
            throw new InvalidOatFileException("There is no section name string table");
        }
        try {
            return new StringTable(this.getSections().get(index));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidOatFileException("The section index for the section name string table is invalid");
        }
    }

    public static interface VdexProvider {
        @Nullable
        public byte[] getVdex();
    }

    public static class NotAnOatFileException
    extends RuntimeException {
    }

    public static class InvalidOatFileException
    extends RuntimeException {
        public InvalidOatFileException(String message) {
            super(message);
        }
    }

    private class DexEntryIterator
    implements Iterator<OatDexEntry> {
        int index = 0;
        int offset = OatFile.access$1000(OatFile.this).getDexListStart();

        private DexEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < OatFile.this.oatHeader.getDexFileCount();
        }

        @Override
        public OatDexEntry next() {
            while (this.hasNext()) {
                byte[] buf;
                int filenameLength = OatFile.this.readSmallUint(this.offset);
                this.offset += 4;
                String filename = new String(OatFile.this.buf, this.offset, filenameLength, Charset.forName("US-ASCII"));
                this.offset += filenameLength;
                this.offset += 4;
                int dexOffset = OatFile.this.readSmallUint(this.offset);
                this.offset += 4;
                if (OatFile.this.getOatVersion() >= 87 && OatFile.this.vdexProvider != null && OatFile.this.vdexProvider.getVdex() != null) {
                    buf = OatFile.this.vdexProvider.getVdex();
                } else {
                    buf = OatFile.this.buf;
                    dexOffset += OatFile.this.oatHeader.headerOffset;
                }
                if (OatFile.this.getOatVersion() >= 75) {
                    this.offset += 4;
                }
                if (OatFile.this.getOatVersion() >= 73) {
                    this.offset += 4;
                }
                if (OatFile.this.getOatVersion() >= 131) {
                    this.offset += 4;
                }
                if (OatFile.this.getOatVersion() >= 127) {
                    this.offset += 4;
                }
                if (OatFile.this.getOatVersion() >= 135) {
                    this.offset += 8;
                }
                if (OatFile.this.getOatVersion() < 75) {
                    int classCount = OatFile.this.readSmallUint(dexOffset + 96);
                    this.offset += 4 * classCount;
                }
                ++this.index;
                if (OatFile.this.getOatVersion() >= 138 && dexOffset == 0) continue;
                return new OatDexEntry(filename, buf, dexOffset);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class OatDexEntry
    implements MultiDexContainer.DexEntry<DexBackedDexFile> {
        public final String entryName;
        public final byte[] buf;
        public final int dexOffset;

        public OatDexEntry(String entryName, byte[] buf, int dexOffset) {
            this.entryName = entryName;
            this.buf = buf;
            this.dexOffset = dexOffset;
        }

        @Override
        public DexBackedDexFile getDexFile() {
            if (CDexBackedDexFile.isCdex(this.buf, this.dexOffset)) {
                return new OatCDexFile(this.buf, this.dexOffset);
            }
            try {
                DexUtil.verifyDexHeader(this.buf, this.dexOffset);
            }
            catch (DexBackedDexFile.NotADexFile ex) {
                if (OatFile.this.getOatVersion() >= 87) {
                    throw new DexFileFactory.DexFileNotFoundException(ex, "Could not locate the embedded dex file %s. Is the vdex file missing?", this.entryName);
                }
                throw new DexFileFactory.DexFileNotFoundException(ex, "The embedded dex file %s does not appear to be a valid dex file.", this.entryName);
            }
            return new OatDexFile(this.buf, this.dexOffset);
        }

        @Override
        @Nonnull
        public String getEntryName() {
            return this.entryName;
        }

        @Override
        @Nonnull
        public MultiDexContainer<? extends DexBackedDexFile> getContainer() {
            return OatFile.this;
        }
    }

    private class StringTable {
        private final int offset;
        private final int size;

        public StringTable(SectionHeader header) {
            this.offset = header.getOffset();
            this.size = header.getSize();
            if (this.offset + this.size > OatFile.this.buf.length) {
                throw new InvalidOatFileException("String table extends past end of file");
            }
        }

        @Nonnull
        public String getString(int index) {
            int start;
            if (index >= this.size) {
                throw new InvalidOatFileException("String index is out of bounds");
            }
            int end = start = this.offset + index;
            while (OatFile.this.buf[end] != 0) {
                if (++end < this.offset + this.size) continue;
                throw new InvalidOatFileException("String extends past end of string table");
            }
            return new String(OatFile.this.buf, start, end - start, Charset.forName("US-ASCII"));
        }
    }

    class SymbolTable {
        @Nonnull
        private final StringTable stringTable;
        private final int offset;
        private final int entryCount;
        private final int entrySize;

        public SymbolTable(SectionHeader header) {
            try {
                this.stringTable = new StringTable((SectionHeader)OatFile.this.getSections().get(header.getLink()));
            }
            catch (IndexOutOfBoundsException ex) {
                throw new InvalidOatFileException("String table section index is invalid");
            }
            this.offset = header.getOffset();
            this.entrySize = header.getEntrySize();
            this.entryCount = header.getSize() / this.entrySize;
            if (this.offset + this.entryCount * this.entrySize > OatFile.this.buf.length) {
                throw new InvalidOatFileException("Symbol table extends past end of file");
            }
        }

        @Nonnull
        public List<Symbol> getSymbols() {
            return new AbstractList<Symbol>(){

                @Override
                public Symbol get(int index) {
                    if (index < 0 || index >= SymbolTable.this.entryCount) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (OatFile.this.is64bit) {
                        return new Symbol64(SymbolTable.this.offset + index * SymbolTable.this.entrySize);
                    }
                    return new Symbol32(SymbolTable.this.offset + index * SymbolTable.this.entrySize);
                }

                @Override
                public int size() {
                    return SymbolTable.this.entryCount;
                }
            };
        }

        public class Symbol64
        extends Symbol {
            public Symbol64(int offset) {
                super(offset);
            }

            @Override
            @Nonnull
            public String getName() {
                return SymbolTable.this.stringTable.getString(OatFile.this.readSmallUint(this.offset));
            }

            @Override
            public long getValue() {
                return OatFile.this.readLong(this.offset + 8);
            }

            @Override
            public int getSize() {
                return OatFile.this.readLongAsSmallUint(this.offset + 16);
            }

            @Override
            public int getSectionIndex() {
                return OatFile.this.readUshort(this.offset + 6);
            }
        }

        public class Symbol32
        extends Symbol {
            public Symbol32(int offset) {
                super(offset);
            }

            @Override
            @Nonnull
            public String getName() {
                return SymbolTable.this.stringTable.getString(OatFile.this.readSmallUint(this.offset));
            }

            @Override
            public long getValue() {
                return OatFile.this.readSmallUint(this.offset + 4);
            }

            @Override
            public int getSize() {
                return OatFile.this.readSmallUint(this.offset + 8);
            }

            @Override
            public int getSectionIndex() {
                return OatFile.this.readUshort(this.offset + 14);
            }
        }

        public abstract class Symbol {
            protected final int offset;

            public Symbol(int offset) {
                this.offset = offset;
            }

            @Nonnull
            public abstract String getName();

            public abstract long getValue();

            public abstract int getSize();

            public abstract int getSectionIndex();

            public int getFileOffset() {
                SectionHeader sectionHeader;
                try {
                    sectionHeader = (SectionHeader)OatFile.this.getSections().get(this.getSectionIndex());
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new InvalidOatFileException("Section index for symbol is out of bounds");
                }
                long sectionAddress = sectionHeader.getAddress();
                int sectionOffset = sectionHeader.getOffset();
                int sectionSize = sectionHeader.getSize();
                long symbolAddress = this.getValue();
                if (symbolAddress < sectionAddress || symbolAddress >= sectionAddress + (long)sectionSize) {
                    throw new InvalidOatFileException("symbol address lies outside it's associated section");
                }
                long fileOffset = (long)sectionOffset + (this.getValue() - sectionAddress);
                assert (fileOffset <= Integer.MAX_VALUE);
                return (int)fileOffset;
            }
        }
    }

    private class SectionHeader64Bit
    extends SectionHeader {
        public SectionHeader64Bit(int offset) {
            super(offset);
        }

        @Override
        public long getAddress() {
            return OatFile.this.readLong(this.offset + 16);
        }

        @Override
        public int getOffset() {
            return OatFile.this.readLongAsSmallUint(this.offset + 24);
        }

        @Override
        public int getSize() {
            return OatFile.this.readLongAsSmallUint(this.offset + 32);
        }

        @Override
        public int getLink() {
            return OatFile.this.readSmallUint(this.offset + 40);
        }

        @Override
        public int getEntrySize() {
            return OatFile.this.readLongAsSmallUint(this.offset + 56);
        }
    }

    private class SectionHeader32Bit
    extends SectionHeader {
        public SectionHeader32Bit(int offset) {
            super(offset);
        }

        @Override
        public long getAddress() {
            return (long)OatFile.this.readInt(this.offset + 12) & 0xFFFFFFFFL;
        }

        @Override
        public int getOffset() {
            return OatFile.this.readSmallUint(this.offset + 16);
        }

        @Override
        public int getSize() {
            return OatFile.this.readSmallUint(this.offset + 20);
        }

        @Override
        public int getLink() {
            return OatFile.this.readSmallUint(this.offset + 24);
        }

        @Override
        public int getEntrySize() {
            return OatFile.this.readSmallUint(this.offset + 36);
        }
    }

    private abstract class SectionHeader {
        protected final int offset;
        public static final int TYPE_DYNAMIC_SYMBOL_TABLE = 11;

        public SectionHeader(int offset) {
            this.offset = offset;
        }

        @Nonnull
        public String getName() {
            return OatFile.this.getSectionNameStringTable().getString(OatFile.this.readSmallUint(this.offset));
        }

        public int getType() {
            return OatFile.this.readInt(this.offset + 4);
        }

        public abstract long getAddress();

        public abstract int getOffset();

        public abstract int getSize();

        public abstract int getLink();

        public abstract int getEntrySize();
    }

    private class OatHeader {
        private final int headerOffset;
        private final int keyValueStoreOffset;

        public OatHeader(int offset) {
            this.headerOffset = offset;
            this.keyValueStoreOffset = this.getVersion() >= 170 ? 56 : (this.getVersion() >= 166 ? 64 : (this.getVersion() >= 162 ? 68 : (this.getVersion() >= 127 ? 76 : 72)));
        }

        public boolean isValid() {
            int i;
            for (i = 0; i < OAT_MAGIC.length; ++i) {
                if (OatFile.this.buf[this.headerOffset + i] == OAT_MAGIC[i]) continue;
                return false;
            }
            for (i = 4; i < 7; ++i) {
                if (OatFile.this.buf[this.headerOffset + i] >= 48 && OatFile.this.buf[this.headerOffset + i] <= 57) continue;
                return false;
            }
            return OatFile.this.buf[this.headerOffset + 7] == 0;
        }

        public int getVersion() {
            return Integer.valueOf(new String(OatFile.this.buf, this.headerOffset + 4, 3));
        }

        public int getDexFileCount() {
            return OatFile.this.readSmallUint(this.headerOffset + 20);
        }

        public int getKeyValueStoreSize() {
            if (this.getVersion() < 56) {
                throw new IllegalStateException("Unsupported oat version");
            }
            int fieldOffset = this.keyValueStoreOffset - 4;
            return OatFile.this.readSmallUint(this.headerOffset + fieldOffset);
        }

        public int getHeaderSize() {
            if (this.getVersion() < 56) {
                throw new IllegalStateException("Unsupported oat version");
            }
            return this.keyValueStoreOffset + this.getKeyValueStoreSize();
        }

        @Nullable
        public String getKeyValue(@Nonnull String key) {
            int offset;
            int size = this.getKeyValueStoreSize();
            int endOffset = offset + size;
            for (offset = this.headerOffset + this.keyValueStoreOffset; offset < endOffset; ++offset) {
                int keyEndOffset;
                String k;
                int keyStartOffset = offset;
                while (offset < endOffset && OatFile.this.buf[offset] != 0) {
                    ++offset;
                }
                if (offset >= endOffset) {
                    throw new InvalidOatFileException("Oat file contains truncated key value store");
                }
                if (!(k = new String(OatFile.this.buf, keyStartOffset, (keyEndOffset = offset++) - keyStartOffset)).equals(key)) continue;
                int valueStartOffset = offset;
                while (offset < endOffset && OatFile.this.buf[offset] != 0) {
                    ++offset;
                }
                if (offset >= endOffset) {
                    throw new InvalidOatFileException("Oat file contains truncated key value store");
                }
                int valueEndOffset = offset;
                return new String(OatFile.this.buf, valueStartOffset, valueEndOffset - valueStartOffset);
            }
            return null;
        }

        public int getDexListStart() {
            if (this.getVersion() >= 127) {
                return this.headerOffset + OatFile.this.readSmallUint(this.headerOffset + 24);
            }
            return this.headerOffset + this.getHeaderSize();
        }
    }

    public class OatCDexFile
    extends CDexBackedDexFile {
        public OatCDexFile(byte[] buf, int offset) {
            super(OatFile.this.opcodes, buf, offset);
        }

        @Override
        public boolean supportsOptimizedOpcodes() {
            return true;
        }
    }

    public class OatDexFile
    extends DexBackedDexFile {
        public OatDexFile(byte[] buf, int offset) {
            super(OatFile.this.opcodes, buf, offset);
        }

        @Override
        public boolean supportsOptimizedOpcodes() {
            return true;
        }
    }
}

