let _ = Mltop.add_known_module "rocq-plugin-tutorial.tuto2"

# 61 "doc/plugin_tutorial/tuto2/src/g_tuto2.mlg"
 
  (*** Dependencies from Coq ***)

  (*
   * This lets us take non-terminal arguments to a command (for example,
   * the PassInt command that takes an integer argument needs this
   * this dependency).
   *
   * First used by: PassInt
   *)
  open Stdarg

  (*
   * This is Coq's pretty-printing module. Here, we need it to use some
   * useful syntax for pretty-printing.
   *
   * First use by: Count
   *)
  open Pp

# 25 "doc/plugin_tutorial/tuto2/src/g_tuto2.ml"

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto2") ~command:"NoOp" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal ("Nothing", Vernacextend.TyNil),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 92 "doc/plugin_tutorial/tuto2/src/g_tuto2.mlg"
                     () 
# 34 "doc/plugin_tutorial/tuto2/src/g_tuto2.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto2") ~command:"NoOpTerminal" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Command",
           Vernacextend.TyTerminal
           ("With",
            Vernacextend.TyTerminal
            ("Some",
             Vernacextend.TyTerminal
             ("Terminal",
              Vernacextend.TyTerminal ("Parameters", Vernacextend.TyNil))))),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 180 "doc/plugin_tutorial/tuto2/src/g_tuto2.mlg"
                                                           () 
# 55 "doc/plugin_tutorial/tuto2/src/g_tuto2.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto2") ~command:"PassInt" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Pass",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_int),
           Vernacextend.TyNil)),
          (let coqpp_body i () = Vernactypes.vtdefault (fun () -> 
# 220 "doc/plugin_tutorial/tuto2/src/g_tuto2.mlg"
                         () 
# 71 "doc/plugin_tutorial/tuto2/src/g_tuto2.ml"
) in
            fun i ?loc ~atts () ->
            coqpp_body i (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto2") ~command:"AcceptIntList" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Accept",
           Vernacextend.TyNonTerminal (Extend.TUlist0 (Extend.TUentry (Genarg.get_arg_tag wit_int)),
           Vernacextend.TyNil)),
          (let coqpp_body l () = Vernactypes.vtdefault (fun () -> 
# 314 "doc/plugin_tutorial/tuto2/src/g_tuto2.mlg"
                                () 
# 87 "doc/plugin_tutorial/tuto2/src/g_tuto2.ml"
) in
            fun l ?loc ~atts () ->
            coqpp_body l (Attributes.unsupported_attributes atts)),
          None))]

let (wit_custom, custom) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-plugin-tutorial.tuto2") ~name:"custom" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next (Procq.Rule.stop)
        ((Procq.Symbol.token (Procq.terminal "Bar"))))
       (fun _ loc -> 
# 422 "doc/plugin_tutorial/tuto2/src/g_tuto2.mlg"
                 Custom.Bar 
# 104 "doc/plugin_tutorial/tuto2/src/g_tuto2.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop)
       ((Procq.Symbol.token (Procq.terminal "Foo"))))
      (fun _ loc -> 
# 421 "doc/plugin_tutorial/tuto2/src/g_tuto2.mlg"
                 Custom.Foo 
# 112 "doc/plugin_tutorial/tuto2/src/g_tuto2.ml"
))]);
    Vernacextend.arg_printer = fun env sigma ->
    fun _ -> Pp.str "missing printer";
    }
let _ = (wit_custom, custom)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto2") ~command:"PassCustom" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Foobar",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_custom),
           Vernacextend.TyNil)),
          (let coqpp_body x () = Vernactypes.vtdefault (fun () -> 
# 446 "doc/plugin_tutorial/tuto2/src/g_tuto2.mlg"
                              () 
# 129 "doc/plugin_tutorial/tuto2/src/g_tuto2.ml"
) in
            fun x ?loc ~atts () ->
            coqpp_body x (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto2") ~command:"Awesome" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Is",
           Vernacextend.TyTerminal
           ("Everything",
            Vernacextend.TyTerminal ("Awesome", Vernacextend.TyNil))),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 478 "doc/plugin_tutorial/tuto2/src/g_tuto2.mlg"
    
     Feedback.msg_notice (Pp.str "Everything is awesome!")
   
# 148 "doc/plugin_tutorial/tuto2/src/g_tuto2.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto2") ~command:"Count" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal ("Count", Vernacextend.TyNil),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 526 "doc/plugin_tutorial/tuto2/src/g_tuto2.mlg"
    
     Counter.increment ();
     let v = Counter.value () in
     Feedback.msg_notice (Pp.str "Times Count has been called: " ++ Pp.int v)
   
# 165 "doc/plugin_tutorial/tuto2/src/g_tuto2.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto2") ~command:"CountPersistent" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Count",
           Vernacextend.TyTerminal ("Persistent", Vernacextend.TyNil)),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 596 "doc/plugin_tutorial/tuto2/src/g_tuto2.mlg"
    
     Persistent_counter.increment ();
     let v = Persistent_counter.value () in
     Feedback.msg_notice (Pp.str "Times Count Persistent has been called: " ++ Pp.int v)
   
# 184 "doc/plugin_tutorial/tuto2/src/g_tuto2.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

