/****************************************************************************
**
** Copyright (C) 2019 Alberto Mardegan <mardy@users.sourceforge.net>
** Contact: http://www.qt.io/licensing
**
** This file is part of Qbs.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms and
** conditions see http://www.qt.io/terms-conditions. For further information
** use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file.  Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, The Qt Company gives you certain additional
** rights.  These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
****************************************************************************/

var TextFile = require("qbs.TextFile");

function parseDesktopFile(filePath) {
    var file = new TextFile(filePath);
    var fileValues = {};
    var currentSection = {};
    var sectionRex = /^\[(.+)\]$/g;
    while (!file.atEof()) {
        var line = file.readLine().trim();
        if (line.length == 0) continue;
        if (line[0] == '#') continue;
        var match = sectionRex.exec(line);
        if (match) {
            var currentSectionName = match[1];
            fileValues[currentSectionName] = {};
            currentSection = fileValues[currentSectionName];
            continue;
        }
        var parts = line.split('=', 2);
        currentSection[parts[0]] = parts[1]
    }
    file.close();
    return fileValues
}

function dumpDesktopFile(filePath, keys) {
    var file = new TextFile(filePath, TextFile.WriteOnly);
    for (var sectionName in keys) {
        file.writeLine('[' + sectionName + ']');
        var section = keys[sectionName];
        for (var key in section) {
            var line = key + '=' + section[key];
            file.writeLine(line);
        }
        // Write an empty line between sections (and before EOF)
        file.writeLine('');
    }
    file.close();
}

function generateDesktopFileCommands(project, product, inputs, outputs, input, output,
                                     explicitlyDependsOn)
{
    var cmd = new JavaScriptCommand();
    cmd.description = "generating " + output.fileName + " from " + input.fileName;
    cmd.highlight = "codegen";
    cmd.sourceCode = function() {
        var aggregateDesktopKeys = parseDesktopFile(input.filePath);
        var desktopKeys = ModUtils.moduleProperty(product, "desktopKeys") || {}
        var mainSection = aggregateDesktopKeys['Desktop Entry'];
        for (key in desktopKeys) {
            if (desktopKeys.hasOwnProperty(key)) {
                mainSection[key] = desktopKeys[key];
            }
        }

        var defaultValues = product.freedesktop.defaultDesktopKeys
        for (key in defaultValues) {
            if (!(key in mainSection)) {
                mainSection[key] = defaultValues[key];
            }
        }

        dumpDesktopFile(output.filePath, aggregateDesktopKeys);
    }
    return [cmd];
}
