/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler;

import com.strobel.assembler.ir.Instruction;
import com.strobel.assembler.ir.OpCode;
import com.strobel.assembler.ir.attributes.ModuleAttribute;
import com.strobel.assembler.ir.attributes.ModuleDependency;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.MethodHandleType;
import com.strobel.assembler.metadata.ModuleReference;
import com.strobel.assembler.metadata.PackageReference;
import com.strobel.assembler.metadata.ParameterReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableReference;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.ast.Label;
import com.strobel.decompiler.ast.Variable;
import com.strobel.io.Ansi;
import java.io.StringWriter;
import java.io.Writer;

public class AnsiTextOutput
extends PlainTextOutput {
    private final Ansi _keyword;
    private final Ansi _instruction;
    private final Ansi _label;
    private final Ansi _type;
    private final Ansi _typeVariable;
    private final Ansi _package;
    private final Ansi _module;
    private final Ansi _method;
    private final Ansi _field;
    private final Ansi _local;
    private final Ansi _literal;
    private final Ansi _textLiteral;
    private final Ansi _comment;
    private final Ansi _operator;
    private final Ansi _delimiter;
    private final Ansi _attribute;
    private final Ansi _error;

    public AnsiTextOutput() {
        this(new StringWriter(), ColorScheme.DARK);
    }

    public AnsiTextOutput(ColorScheme colorScheme) {
        this(new StringWriter(), colorScheme);
    }

    public AnsiTextOutput(Writer writer) {
        this(writer, ColorScheme.DARK);
    }

    public AnsiTextOutput(Writer writer, ColorScheme colorScheme) {
        super(writer);
        boolean light = colorScheme == ColorScheme.LIGHT;
        this._keyword = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 21 : 33), null);
        this._instruction = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 91 : 141), null);
        this._label = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 249 : 249), null);
        this._type = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 25 : 45), null);
        this._typeVariable = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 29 : 79), null);
        this._package = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 32 : 111), null);
        this._module = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 38 : 117), null);
        this._method = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 162 : 212), null);
        this._field = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 136 : 222), null);
        this._local = new Ansi(Ansi.Attribute.NORMAL, (Ansi.AnsiColor)null, null);
        this._literal = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 197 : 204), null);
        this._textLiteral = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 28 : 42), null);
        this._comment = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 244 : 244), null);
        this._operator = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 242 : 247), null);
        this._delimiter = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 242 : 252), null);
        this._attribute = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 166 : 214), null);
        this._error = new Ansi(Ansi.Attribute.NORMAL, new Ansi.AnsiColor(light ? 196 : 196), null);
    }

    private String colorize(String value, Ansi ansi) {
        return ansi.colorize(StringUtilities.escape(value, false, this.isUnicodeOutputEnabled()));
    }

    @Override
    public void writeError(String value) {
        this.writeAnsi(value, this.colorize(value, this._error));
    }

    @Override
    public void writeLabel(String value) {
        this.writeAnsi(value, this.colorize(value, this._label));
    }

    protected final void writeAnsi(String originalText, String ansiText) {
        super.writeRaw(ansiText);
        if (originalText != null && ansiText != null) {
            this.column -= ansiText.length() - originalText.length();
        }
    }

    @Override
    public void writeLiteral(Object value) {
        String literal = String.valueOf(value);
        this.writeAnsi(literal, this.colorize(literal, this._literal));
    }

    @Override
    public void writeTextLiteral(Object value) {
        String literal = String.valueOf(value);
        this.writeAnsi(literal, this.colorize(literal, this._textLiteral));
    }

    @Override
    public void writeComment(String value) {
        this.writeAnsi(value, this.colorize(value, this._comment));
    }

    @Override
    public void writeComment(String format, Object ... args) {
        String text = String.format(format, args);
        this.writeAnsi(text, this.colorize(text, this._comment));
    }

    @Override
    public void writeDelimiter(String text) {
        this.writeAnsi(text, this.colorize(text, this._delimiter));
    }

    @Override
    public void writeAttribute(String text) {
        this.writeAnsi(text, this.colorize(text, this._attribute));
    }

    @Override
    public void writeOperator(String text) {
        this.writeAnsi(text, this.colorize(text, this._operator));
    }

    @Override
    public void writeKeyword(String text) {
        this.writeAnsi(text, this.colorize(text, this._keyword));
    }

    @Override
    public void writeDefinition(String text, Object definition, boolean isLocal) {
        if (text == null) {
            super.write(null);
            return;
        }
        String colorizedText = definition instanceof Instruction || definition instanceof OpCode || definition instanceof AstCode ? this.colorize(text, this._instruction) : (definition instanceof TypeReference ? this.colorizeType(text, (TypeReference)definition) : (definition instanceof IMethodSignature ? this.colorize(text, this._method) : (definition instanceof FieldReference ? this.colorize(text, this._field) : (definition instanceof VariableReference || definition instanceof ParameterReference || definition instanceof Variable ? this.colorize(text, this._local) : (definition instanceof PackageReference ? this.colorizePackage(text) : (definition instanceof com.strobel.assembler.metadata.Label || definition instanceof Label ? this.colorize(text, this._label) : text))))));
        this.writeAnsi(text, colorizedText);
    }

    @Override
    public void writeReference(String text, Object reference, boolean isLocal) {
        if (text == null) {
            super.write(null);
            return;
        }
        String colorizedText = reference instanceof Instruction || reference instanceof OpCode || reference instanceof AstCode || reference instanceof MethodHandleType ? this.colorize(text, this._instruction) : (reference instanceof TypeReference ? this.colorizeType(text, (TypeReference)reference) : (reference instanceof IMethodSignature ? this.colorize(text, this._method) : (reference instanceof FieldReference ? this.colorize(text, this._field) : (reference instanceof VariableReference || reference instanceof ParameterReference || reference instanceof Variable ? this.colorize(text, this._local) : (reference instanceof PackageReference ? this.colorizePackage(text) : (reference instanceof ModuleAttribute || reference instanceof ModuleDependency || reference instanceof ModuleReference ? this.colorize(text, this._module) : (reference instanceof com.strobel.assembler.metadata.Label || reference instanceof Label ? this.colorize(text, this._label) : StringUtilities.escape(text, false, this.isUnicodeOutputEnabled()))))))));
        this.writeAnsi(text, colorizedText);
    }

    private String colorizeType(String text, TypeReference type) {
        return this.colorizeTypeCore(new StringBuilder(), text, type).toString();
    }

    private StringBuilder colorizeTypeCore(StringBuilder sb, String text, TypeReference type) {
        String typeName;
        Ansi typeColor;
        int arrayDepth;
        if (type.isPrimitive() && text.length() > 1) {
            return sb.append(this.colorize(text, this._keyword));
        }
        TypeReference elementType = type;
        for (arrayDepth = 0; arrayDepth < text.length() && text.charAt(arrayDepth) == '['; ++arrayDepth) {
            if (!elementType.isArray()) continue;
            elementType = elementType.getElementType();
        }
        if (arrayDepth > 0) {
            this.colorizeTypeCore(sb.append(this.colorize(StringUtilities.repeat('[', arrayDepth), this._delimiter)), text.substring(arrayDepth), elementType);
        }
        String packageName = type.getPackageName();
        TypeDefinition resolvedType = type.resolve();
        String s = text;
        boolean isTypeVariable = s.startsWith("T") && s.endsWith(";");
        boolean isSignature = isTypeVariable || s.startsWith("L") && s.endsWith(";");
        Ansi ansi = typeColor = isTypeVariable || type.isGenericParameter() ? this._typeVariable : this._type;
        if (StringUtilities.isNullOrEmpty(packageName)) {
            if (resolvedType != null && resolvedType.isAnnotation()) {
                return sb.append(this.colorize(s, this._attribute));
            }
            return sb.append(this.colorize(s, typeColor));
        }
        char delimiter = '.';
        String packagePrefix = packageName + delimiter;
        if (isSignature) {
            s = s.substring(1, s.length() - 1);
        }
        if (!StringUtilities.startsWith(s, packagePrefix)) {
            delimiter = '/';
            packagePrefix = packageName.replace('.', delimiter) + delimiter;
        }
        if (isSignature) {
            sb.append(this.colorize(isTypeVariable ? "T" : "L", this._delimiter));
        }
        if (StringUtilities.startsWith(s, packagePrefix)) {
            String[] packageParts = packageName.split("\\.");
            for (int i = 0; i < packageParts.length; ++i) {
                if (i != 0) {
                    sb.append(this.colorize(String.valueOf(delimiter), this._delimiter));
                }
                sb.append(this.colorize(packageParts[i], this._package));
            }
            sb.append(this.colorize(String.valueOf(delimiter), this._delimiter));
            typeName = s.substring(packagePrefix.length());
        } else {
            typeName = s;
        }
        typeColor = resolvedType != null && resolvedType.isAnnotation() ? this._attribute : typeColor;
        this.colorizeDelimitedName(sb, typeName, typeColor);
        if (isSignature) {
            sb.append(this.colorize(";", this._delimiter));
        }
        return sb;
    }

    private StringBuilder colorizeDelimitedName(StringBuilder sb, String typeName, Ansi typeColor) {
        int start;
        int end = typeName.length();
        if (end == 0) {
            return sb;
        }
        for (int i = start = 0; i < end; ++i) {
            char ch = typeName.charAt(i);
            switch (ch) {
                case '$': 
                case '.': 
                case '/': 
                case '[': {
                    sb.append(this.colorize(typeName.substring(start, i), typeColor));
                    sb.append(this.colorize(Delimiters.get(ch), this._delimiter));
                    start = i + 1;
                }
            }
        }
        if (start < end) {
            sb.append(this.colorize(typeName.substring(start, end), typeColor));
        }
        return sb;
    }

    private String colorizePackage(String text) {
        StringBuilder sb = new StringBuilder(text.length() * 2);
        return this.colorizeDelimitedName(sb, text, this._package).toString();
    }

    public static enum ColorScheme {
        DARK,
        LIGHT;

    }

    private static final class Delimiters {
        static final String L = "L";
        static final String T = "T";
        static final String DOLLAR = "$";
        static final String DOT = ".";
        static final String SLASH = "/";
        static final String LEFT_BRACKET = "[";
        static final String SEMICOLON = ";";

        private Delimiters() {
        }

        static String get(char c) {
            switch (c) {
                case 'L': {
                    return L;
                }
                case 'T': {
                    return T;
                }
                case '$': {
                    return DOLLAR;
                }
                case '.': {
                    return DOT;
                }
                case '/': {
                    return SLASH;
                }
                case '[': {
                    return LEFT_BRACKET;
                }
                case ':': {
                    return SEMICOLON;
                }
            }
            return String.valueOf(c);
        }
    }
}

