/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.search_pipeline.ResponseProcessor;
import org.opensearch.client.opensearch.search_pipeline.ResponseProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RenameFieldResponseProcessor
implements ResponseProcessorVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, RenameFieldResponseProcessor> {
    @Nullable
    private final String description;
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean ignoreFailure;
    @Nullable
    private final String tag;
    @Nonnull
    private final String targetField;
    public static final JsonpDeserializer<RenameFieldResponseProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RenameFieldResponseProcessor::setupRenameFieldResponseProcessorDeserializer);

    private RenameFieldResponseProcessor(Builder builder) {
        this.description = builder.description;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreFailure = builder.ignoreFailure;
        this.tag = builder.tag;
        this.targetField = ApiTypeHelper.requireNonNull(builder.targetField, this, "targetField");
    }

    public static RenameFieldResponseProcessor of(Function<Builder, ObjectBuilder<RenameFieldResponseProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ResponseProcessor.Kind _responseProcessorKind() {
        return ResponseProcessor.Kind.RenameField;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    @Nonnull
    public final String targetField() {
        return this.targetField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure.booleanValue());
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
        generator.writeKey("target_field");
        generator.write(this.targetField);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRenameFieldResponseProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure");
        op.add(Builder::tag, JsonpDeserializer.stringDeserializer(), "tag");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreFailure);
        result = 31 * result + Objects.hashCode(this.tag);
        result = 31 * result + this.targetField.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenameFieldResponseProcessor other = (RenameFieldResponseProcessor)o;
        return Objects.equals(this.description, other.description) && this.field.equals(other.field) && Objects.equals(this.ignoreFailure, other.ignoreFailure) && Objects.equals(this.tag, other.tag) && this.targetField.equals(other.targetField);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RenameFieldResponseProcessor> {
        @Nullable
        private String description;
        private String field;
        @Nullable
        private Boolean ignoreFailure;
        @Nullable
        private String tag;
        private String targetField;

        public Builder() {
        }

        private Builder(RenameFieldResponseProcessor o) {
            this.description = o.description;
            this.field = o.field;
            this.ignoreFailure = o.ignoreFailure;
            this.tag = o.tag;
            this.targetField = o.targetField;
        }

        private Builder(Builder o) {
            this.description = o.description;
            this.field = o.field;
            this.ignoreFailure = o.ignoreFailure;
            this.tag = o.tag;
            this.targetField = o.targetField;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return this;
        }

        @Nonnull
        public final Builder tag(@Nullable String value) {
            this.tag = value;
            return this;
        }

        @Nonnull
        public final Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        @Override
        @Nonnull
        public RenameFieldResponseProcessor build() {
            this._checkSingleUse();
            return new RenameFieldResponseProcessor(this);
        }
    }
}

