/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.remote;

import java.io.IOException;
import java.time.Duration;
import java.util.Random;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.remote.RemoteIndexWaiter;
import org.opensearch.knn.plugin.stats.KNNRemoteIndexBuildValue;
import org.opensearch.remoteindexbuild.client.RemoteIndexClient;
import org.opensearch.remoteindexbuild.model.RemoteBuildStatusRequest;
import org.opensearch.remoteindexbuild.model.RemoteBuildStatusResponse;

public class RemoteIndexPoller
implements RemoteIndexWaiter {
    private static final int INITIAL_DELAY_FACTOR = 3;
    private static final double JITTER_LOWER = 0.8;
    private static final double JITTER_UPPER = 1.2;
    public static final String TASK_STATUS = "task_status";
    public static final String FILE_NAME = "file_name";
    public static final String RUNNING_INDEX_BUILD = "RUNNING_INDEX_BUILD";
    public static final String COMPLETED_INDEX_BUILD = "COMPLETED_INDEX_BUILD";
    public static final String FAILED_INDEX_BUILD = "FAILED_INDEX_BUILD";
    private final RemoteIndexClient client;
    private final Random random;
    private long timeout;
    private long pollInterval;

    RemoteIndexPoller(RemoteIndexClient client) {
        this.client = client;
        this.random = new Random();
        this.timeout = KNNSettings.getRemoteBuildClientTimeout().getNanos();
        this.pollInterval = KNNSettings.getRemoteBuildClientPollInterval().getMillis();
    }

    @Override
    public RemoteBuildStatusResponse awaitVectorBuild(RemoteBuildStatusRequest remoteBuildStatusRequest) throws InterruptedException, IOException {
        long startTime = System.nanoTime();
        this.sleepWithJitter(this.pollInterval * 3L);
        block12: while (System.nanoTime() - startTime < this.timeout) {
            RemoteBuildStatusResponse remoteBuildStatusResponse;
            try {
                remoteBuildStatusResponse = this.client.getBuildStatus(remoteBuildStatusRequest);
            }
            catch (IOException e) {
                KNNRemoteIndexBuildValue.STATUS_REQUEST_FAILURE_COUNT.increment();
                throw e;
            }
            KNNRemoteIndexBuildValue.STATUS_REQUEST_SUCCESS_COUNT.increment();
            String taskStatus = remoteBuildStatusResponse.getTaskStatus();
            if (StringUtils.isBlank((CharSequence)taskStatus)) {
                throw new IOException(String.format("Invalid response format, missing %s", TASK_STATUS));
            }
            switch (taskStatus) {
                case "COMPLETED_INDEX_BUILD": {
                    if (StringUtils.isBlank((CharSequence)remoteBuildStatusResponse.getFileName())) {
                        throw new IOException(String.format("Invalid response format, missing %s for %s status", FILE_NAME, taskStatus));
                    }
                    return remoteBuildStatusResponse;
                }
                case "FAILED_INDEX_BUILD": {
                    String errorMessage = remoteBuildStatusResponse.getErrorMessage();
                    Duration d = Duration.ofNanos(System.nanoTime() - startTime);
                    throw new InterruptedException(String.format("Remote index build failed after %d minutes. %s", d.toMinutesPart(), errorMessage));
                }
                case "RUNNING_INDEX_BUILD": {
                    this.sleepWithJitter(this.pollInterval);
                    continue block12;
                }
            }
            throw new IOException(String.format("Server returned invalid task status %s", taskStatus));
        }
        Duration waitedDuration = Duration.ofNanos(System.nanoTime() - startTime);
        Duration timeoutDuration = Duration.ofNanos(this.timeout);
        throw new InterruptedException(String.format("Remote index build timed out after %d minutes, timeout is set to %d minutes. Falling back to CPU build", waitedDuration.toMinutesPart(), timeoutDuration.toMinutesPart()));
    }

    private void sleepWithJitter(long baseInterval) throws InterruptedException {
        long intervalWithJitter = (long)((double)baseInterval * (0.8 + this.random.nextDouble() * 0.3999999999999999));
        Thread.sleep(intervalWithJitter);
    }

    @Generated
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }
}

