/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.mapper.xyshape;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.opensearch.common.Explicit;
import org.opensearch.common.geo.GeometryParser;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.common.geo.builders.ShapeBuilder;
import org.opensearch.geometry.Geometry;
import org.opensearch.geospatial.index.mapper.xyshape.XYShapeIndexableFieldsVisitor;
import org.opensearch.geospatial.index.mapper.xyshape.XYShapeIndexer;
import org.opensearch.geospatial.index.mapper.xyshape.XYShapeQueryable;
import org.opensearch.geospatial.index.mapper.xyshape.XYShapeSupportVisitor;
import org.opensearch.geospatial.index.query.xyshape.XYShapeQueryProcessor;
import org.opensearch.geospatial.index.query.xyshape.XYShapeQueryVisitor;
import org.opensearch.index.mapper.AbstractGeometryFieldMapper;
import org.opensearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.GeoShapeParser;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.query.QueryShardContext;

public class XYShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<Geometry, Geometry> {
    public static final String CONTENT_TYPE = "xy_shape";
    private static final FieldType FIELD_TYPE = new FieldType();

    private XYShapeFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Explicit<ShapeBuilder.Orientation> orientation, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, ignoreMalformed, coerce, ignoreZValue, orientation, multiFields, copyTo);
    }

    public XYShapeFieldType fieldType() {
        return (XYShapeFieldType)super.fieldType();
    }

    protected boolean docValuesByDefault() {
        return false;
    }

    protected void mergeGeoOptions(AbstractShapeGeometryFieldMapper mergeWith, List conflicts) {
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void addStoredFields(ParseContext context, Geometry geometry) {
    }

    protected void addDocValuesFields(String name, Geometry geometry, List<IndexableField> fields, ParseContext context) {
    }

    protected void addMultiFields(ParseContext context, Geometry geometry) {
    }

    public Explicit<Boolean> shouldIgnoreMalformed() {
        return this.ignoreMalformed;
    }

    static {
        FIELD_TYPE.setDimensions(7, 4, 4);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.freeze();
    }

    public static class XYShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType<Geometry, Geometry>
    implements XYShapeQueryable {
        private final XYShapeQueryProcessor queryProcessor;

        public XYShapeFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Map<String, String> meta, XYShapeQueryProcessor processor) {
            super(name, indexed, stored, hasDocValues, false, meta);
            this.queryProcessor = Objects.requireNonNull(processor, "query processor cannot be null");
        }

        public String typeName() {
            return XYShapeFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query shapeQuery(Geometry geometry, String fieldName, ShapeRelation relation, QueryShardContext context) {
            XYShapeQueryVisitor visitor = new XYShapeQueryVisitor(fieldName, context);
            return this.queryProcessor.shapeQuery(geometry, fieldName, relation, visitor, context);
        }
    }

    public static class XYShapeFieldMapperBuilder
    extends AbstractShapeGeometryFieldMapper.Builder<XYShapeFieldMapperBuilder, XYShapeFieldType> {
        public XYShapeFieldMapperBuilder(String fieldName) {
            super(fieldName, FIELD_TYPE);
            this.hasDocValues = false;
        }

        public XYShapeFieldMapper build(Mapper.BuilderContext context) {
            return new XYShapeFieldMapper(this.name, this.fieldType, (MappedFieldType)this.buildShapeFieldType(context), (Explicit<Boolean>)this.ignoreMalformed(context), (Explicit<Boolean>)this.coerce(context), (Explicit<Boolean>)this.ignoreZValue(), (Explicit<ShapeBuilder.Orientation>)this.orientation(), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo);
        }

        private XYShapeFieldType buildShapeFieldType(Mapper.BuilderContext context) {
            XYShapeQueryProcessor processor = new XYShapeQueryProcessor();
            XYShapeFieldType fieldType = new XYShapeFieldType(this.buildFullName(context), this.indexed, this.fieldType.stored(), this.hasDocValues, this.meta, processor);
            GeometryParser geometryParser = new GeometryParser(((ShapeBuilder.Orientation)this.orientation().value()).getAsBoolean(), ((Boolean)this.coerce().value()).booleanValue(), ((Boolean)this.ignoreZValue().value()).booleanValue());
            fieldType.setGeometryParser((AbstractGeometryFieldMapper.Parser)new GeoShapeParser(geometryParser));
            XYShapeIndexableFieldsVisitor xyShapeIndexableVisitor = new XYShapeIndexableFieldsVisitor(fieldType.name());
            XYShapeSupportVisitor xyShapeSupportVisitor = new XYShapeSupportVisitor();
            fieldType.setGeometryIndexer(new XYShapeIndexer(xyShapeSupportVisitor, xyShapeIndexableVisitor));
            fieldType.setOrientation((ShapeBuilder.Orientation)this.orientation().value());
            return fieldType;
        }
    }
}

