/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker;

import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Token;
import org.keycloak.common.VerificationException;
import org.keycloak.cookie.CookieProvider;
import org.keycloak.cookie.CookieType;
import org.keycloak.forms.login.freemarker.DetachedInfoStateCookie;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class DetachedInfoStateChecker {
    private static final Logger logger = Logger.getLogger(DetachedInfoStateChecker.class);
    public static final String STATE_CHECKER_PARAM = "kc_state_checker";
    private final KeycloakSession session;
    private final RealmModel realm;

    public DetachedInfoStateChecker(KeycloakSession session, RealmModel realm) {
        this.session = session;
        this.realm = realm;
    }

    public DetachedInfoStateCookie generateAndSetCookie(String messageKey, String messageType, Integer status, String clientId, Object[] messageParameters) {
        UriInfo uriInfo = this.session.getContext().getHttpRequest().getUri();
        String currentStateCheckerInUrl = (String)uriInfo.getQueryParameters().getFirst((Object)STATE_CHECKER_PARAM);
        String newStateChecker = KeycloakModelUtils.generateId();
        int cookieMaxAge = this.realm.getAccessCodeLifespanUserAction();
        DetachedInfoStateCookie cookie = new DetachedInfoStateCookie();
        cookie.setMessageKey(messageKey);
        cookie.setMessageType(messageType);
        cookie.setStatus(status);
        cookie.setClientUuid(clientId);
        cookie.setCurrentUrlState(currentStateCheckerInUrl);
        cookie.setRenderedUrlState(newStateChecker);
        if (messageParameters != null) {
            List<String> params = Stream.of(messageParameters).map(Object::toString).collect(Collectors.toList());
            cookie.setMessageParameters(params);
        }
        String encoded = this.session.tokens().encode((Token)cookie);
        ((CookieProvider)this.session.getProvider(CookieProvider.class)).set(CookieType.AUTH_DETACHED, encoded, cookieMaxAge);
        return cookie;
    }

    public DetachedInfoStateCookie verifyStateCheckerParameter(String stateCheckerParam) throws VerificationException {
        String cookieVal = ((CookieProvider)this.session.getProvider(CookieProvider.class)).get(CookieType.AUTH_DETACHED);
        if (cookieVal == null || cookieVal.isEmpty()) {
            throw new VerificationException("State checker cookie is empty");
        }
        if (stateCheckerParam == null || stateCheckerParam.isEmpty()) {
            throw new VerificationException("State checker parameter is empty");
        }
        DetachedInfoStateCookie cookie = (DetachedInfoStateCookie)this.session.tokens().decode(cookieVal, DetachedInfoStateCookie.class);
        if (cookie == null) {
            throw new VerificationException("Failed to verify DetachedInfoStateCookie");
        }
        if (stateCheckerParam.equals(cookie.getCurrentUrlState()) || stateCheckerParam.equals(cookie.getRenderedUrlState())) {
            return cookie;
        }
        throw new VerificationException(String.format("Failed to verify state. StateCheckerParameter: %s, cookie current state checker: %s, Cookie rendered state checker: %s", stateCheckerParam, cookie.getCurrentUrlState(), cookie.getRenderedUrlState()));
    }
}

