/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsEntryMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsValueMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.GetKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.GetKeyWithMetadataMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.PutKeyValueMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.RemoveEntryMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.RemoveKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.SizeMultimapOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

@Immutable
public class MultimapOperationsFactory {
    private final ThreadLocal<Integer> flagsMap = new ThreadLocal();
    private final ChannelFactory transportFactory;
    private final byte[] cacheNameBytes;
    private final AtomicReference<ClientTopology> clientTopologyRef;
    private final boolean forceReturnValue;
    private final Configuration cfg;
    private final DataFormat dataFormat;
    private final ClientStatistics clientStatistics;

    public MultimapOperationsFactory(ChannelFactory channelFactory, String cacheName, Configuration cfg, DataFormat dataFormat, ClientStatistics clientStatistics) {
        AtomicReference<ClientTopology> atomicReference;
        this.transportFactory = channelFactory;
        byte[] byArray = this.cacheNameBytes = cacheName == null ? null : RemoteCacheManager.cacheNameBytes(cacheName);
        if (channelFactory != null) {
            atomicReference = channelFactory.createTopologyId(this.cacheNameBytes);
        } else {
            AtomicReference<ClientTopology> atomicReference2;
            atomicReference = atomicReference2;
            super(new ClientTopology(-1, cfg.clientIntelligence()));
        }
        this.clientTopologyRef = atomicReference;
        this.forceReturnValue = cfg.forceReturnValues();
        this.cfg = cfg;
        this.dataFormat = dataFormat;
        this.clientStatistics = clientStatistics;
    }

    public <K, V> GetKeyMultimapOperation<V> newGetKeyMultimapOperation(K key, byte[] keyBytes, boolean supportsDuplicates) {
        return new GetKeyMultimapOperation(this.transportFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, this.dataFormat, this.clientStatistics, supportsDuplicates);
    }

    public <K, V> GetKeyWithMetadataMultimapOperation<V> newGetKeyWithMetadataMultimapOperation(K key, byte[] keyBytes, boolean supportsDuplicates) {
        return new GetKeyWithMetadataMultimapOperation(this.transportFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, this.dataFormat, this.clientStatistics, supportsDuplicates);
    }

    public <K> PutKeyValueMultimapOperation newPutKeyValueOperation(K key, byte[] keyBytes, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, boolean supportsDuplicates) {
        return new PutKeyValueMultimapOperation(this.transportFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(lifespan, maxIdle), this.cfg, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, null, this.clientStatistics, supportsDuplicates);
    }

    public <K> RemoveKeyMultimapOperation newRemoveKeyOperation(K key, byte[] keyBytes, boolean supportsDuplicates) {
        return new RemoveKeyMultimapOperation(this.transportFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, this.clientStatistics, supportsDuplicates);
    }

    public <K> RemoveEntryMultimapOperation newRemoveEntryOperation(K key, byte[] keyBytes, byte[] value, boolean supportsDuplicates) {
        return new RemoveEntryMultimapOperation(this.transportFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, value, this.clientStatistics, supportsDuplicates);
    }

    public <K> ContainsEntryMultimapOperation newContainsEntryOperation(K key, byte[] keyBytes, byte[] value, boolean supportsDuplicates) {
        return new ContainsEntryMultimapOperation(this.transportFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, value, this.clientStatistics, supportsDuplicates);
    }

    public <K> ContainsKeyMultimapOperation newContainsKeyOperation(K key, byte[] keyBytes, boolean supportsDuplicates) {
        return new ContainsKeyMultimapOperation(this.transportFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, this.clientStatistics, supportsDuplicates);
    }

    public ContainsValueMultimapOperation newContainsValueOperation(byte[] value, boolean supportsDuplicates) {
        return new ContainsValueMultimapOperation(this.transportFactory.getNegotiatedCodec(), this.transportFactory, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, value, -1L, TimeUnit.MILLISECONDS, -1L, TimeUnit.MILLISECONDS, supportsDuplicates);
    }

    public SizeMultimapOperation newSizeOperation(boolean supportsDuplicates) {
        return new SizeMultimapOperation(this.transportFactory.getNegotiatedCodec(), this.transportFactory, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, supportsDuplicates);
    }

    public int flags() {
        Integer threadLocalFlags = this.flagsMap.get();
        this.flagsMap.remove();
        int intFlags = 0;
        if (threadLocalFlags != null) {
            intFlags |= threadLocalFlags.intValue();
        }
        if (this.forceReturnValue) {
            intFlags |= Flag.FORCE_RETURN_VALUE.getFlagInt();
        }
        return intFlags;
    }

    private int flags(long lifespan, long maxIdle) {
        int intFlags = this.flags();
        if (lifespan == 0L) {
            intFlags |= Flag.DEFAULT_LIFESPAN.getFlagInt();
        }
        if (maxIdle == 0L) {
            intFlags |= Flag.DEFAULT_MAXIDLE.getFlagInt();
        }
        return intFlags;
    }
}

