/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.noise;

import org.jvnet.substance.painter.noise.BaseNoiseFilter;
import org.jvnet.substance.painter.noise.NoiseFilter;

public class MarbleFilter
extends BaseNoiseFilter {
    public MarbleFilter(double xFactor, double yFactor, double zFactor, NoiseFilter.TrigKind trigKind) {
        super(xFactor, yFactor, zFactor, 1.0, trigKind);
    }

    public static MarbleFilter getXFilter(double xFactor, NoiseFilter.TrigKind trigKind) {
        return new MarbleFilter(xFactor, 0.0, 0.0, trigKind);
    }

    public static MarbleFilter getYFilter(double yFactor, NoiseFilter.TrigKind trigKind) {
        return new MarbleFilter(0.0, yFactor, 0.0, trigKind);
    }

    public static MarbleFilter getZFilter(double zFactor, NoiseFilter.TrigKind trigKind) {
        return new MarbleFilter(0.0, 0.0, zFactor, trigKind);
    }

    @Override
    public double apply(double x, double y, double z, double origValue) {
        double trans = this.xFactor * x + this.yFactor * y + this.zFactor * z + origValue;
        double trig = this.trigKind == NoiseFilter.TrigKind.COSINE ? Math.cos(trans) : Math.sin(trans);
        return 0.5 + 0.5 * trig;
    }
}

