/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import tim.prune.App;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.function.compress.MarkAndDeleteFunction;

public class MarkPointsInRectangleFunction
extends MarkAndDeleteFunction {
    private double _minLat = 0.0;
    private double _maxLat = 0.0;
    private double _minLon = 0.0;
    private double _maxLon = 0.0;
    private final boolean _markInside;

    public MarkPointsInRectangleFunction(App app, boolean bl) {
        super(app);
        this._markInside = bl;
    }

    @Override
    public String getNameKey() {
        return this._markInside ? "menu.track.markinsiderectangle" : "menu.track.markoutsiderectangle";
    }

    public void setRectCoords(double d, double d2, double d3, double d4) {
        if (d == d3 || d2 == d4) {
            this._maxLon = 0.0;
            this._minLon = 0.0;
            this._maxLat = 0.0;
            this._minLat = 0.0;
        } else {
            this._minLon = Math.min(d, d3);
            this._maxLon = Math.max(d, d3);
            this._minLat = Math.min(d2, d4);
            this._maxLat = Math.max(d2, d4);
        }
    }

    @Override
    public void begin() {
        if (this._maxLon == this._minLon || this._maxLat == this._minLat) {
            return;
        }
        int n = this._app.getTrackInfo().getTrack().getNumPoints();
        int n2 = 0;
        int n3 = 0;
        this._app.getTrackInfo().clearAllMarkers();
        int n4 = 0;
        while (n4 < n) {
            boolean bl;
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n4);
            double d = dataPoint.getLongitude().getDouble();
            double d2 = dataPoint.getLatitude().getDouble();
            boolean bl2 = bl = d >= this._minLon && d <= this._maxLon && d2 >= this._minLat && d2 <= this._maxLat;
            if (bl == this._markInside) {
                this._app.getTrackInfo().markPointForDeletion(n4);
                ++n2;
            } else {
                ++n3;
            }
            ++n4;
        }
        UpdateMessageBroker.informSubscribers();
        if (n2 > 0 && n3 > 0) {
            this.optionallyDeleteMarkedPoints(n2);
        }
    }

    @Override
    protected boolean getShouldSplitSegments() {
        return true;
    }
}

