/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.MarkingData;
import tim.prune.data.Track;
import tim.prune.function.compress.CompressionDialog;
import tim.prune.function.compress.CompressionMethodType;
import tim.prune.function.compress.MarkAndDeleteFunction;
import tim.prune.function.compress.MethodList;
import tim.prune.function.compress.PanelController;
import tim.prune.function.compress.ParameterValues;
import tim.prune.function.compress.SummaryLabel;
import tim.prune.function.compress.methods.CompressionMethod;
import tim.prune.function.compress.methods.DouglasPeuckerMethod;
import tim.prune.function.compress.methods.DuplicatesMethod;
import tim.prune.function.compress.methods.NearbyFactorMethod;
import tim.prune.function.compress.methods.SingletonsMethod;
import tim.prune.function.compress.methods.WackyPointsMethod;

public class CompressTrackFunction
extends MarkAndDeleteFunction
implements CompressionDialog {
    private final Track _track;
    private JDialog _dialog = null;
    private JButton _okButton = null;
    private PanelController _panelController = null;
    private SummaryLabel _summaryLabel = null;
    private JScrollPane _scrollPane = null;

    public CompressTrackFunction(App app) {
        super(app);
        this._track = app.getTrackInfo().getTrack();
    }

    @Override
    public String getNameKey() {
        return "function.compress";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.initDialogFromConfig();
        this._scrollPane.getViewport().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this._dialog.setVisible(true);
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(new JLabel(I18nManager.getText("dialog.compress.desc")));
        jPanel3.add(Box.createRigidArea(new Dimension(0, 2)));
        JButton jButton = new JButton(I18nManager.getText(I18nManager.getText("button.addnew")));
        jButton.addActionListener(actionEvent -> this._panelController.addMethod(this.getConfig()));
        jPanel3.add(jButton);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 2)));
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel();
        this._panelController = new PanelController(this._track, this, jPanel4);
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this._panelController.addDummyPanels();
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jPanel4, "North");
        this._scrollPane = new JScrollPane(jPanel5);
        jPanel2.add((Component)this._scrollPane, "Center");
        JPanel jPanel6 = new JPanel();
        this._summaryLabel = new SummaryLabel(this._track);
        jPanel6.add(this._summaryLabel);
        jPanel2.add((Component)jPanel6, "South");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.setEnabled(false);
        this._okButton.addActionListener(actionEvent -> this.finish());
        jPanel7.add(this._okButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel7.add(jButton2);
        jPanel.add((Component)jPanel7, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void finish() {
        MarkingData markingData = this._panelController.recalculateAll();
        this._app.getTrackInfo().clearAllMarkers();
        int n = 0;
        int n2 = this._app.getTrackInfo().getTrack().getNumPoints();
        int n3 = 0;
        while (n3 < n2) {
            DataPoint dataPoint = this._track.getPoint(n3);
            if (!dataPoint.isWaypoint()) {
                boolean bl = markingData.isPointMarkedForDeletion(n3) && !dataPoint.hasMedia();
                boolean bl2 = bl && markingData.isPointMarkedForSegmentBreak(n3);
                this._app.getTrackInfo().markPointForDeletion(n3, bl, bl2);
                if (bl) {
                    ++n;
                }
            }
            ++n3;
        }
        String string = this._panelController.getMethodList().toConfigString();
        this.getConfig().setConfigString("prune.compressionmethods", string);
        this.getConfig().setConfigString("prune.compression", "");
        UpdateMessageBroker.informSubscribers();
        this._dialog.dispose();
        if (n > 0) {
            this.optionallyDeleteMarkedPoints(n);
        } else {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.compress.confirmnone"), this.getName(), 1);
        }
    }

    private void initDialogFromConfig() {
        this._panelController.deleteAllPanels();
        Config config = this.getConfig();
        ParameterValues parameterValues = new ParameterValues();
        String string = config.getConfigString("prune.compressionmethods");
        parameterValues.applyNewStyleConfig(string);
        MethodList methodList = MethodList.fromConfigString(string);
        if (methodList.isEmpty()) {
            Object object = config.getConfigString("prune.compression");
            parameterValues.applyOldStyleConfig((String)object);
            methodList.add(0, new DuplicatesMethod());
            methodList.add(1, new NearbyFactorMethod(parameterValues.getValue(CompressionMethodType.NEARBY_WITH_FACTOR)));
            methodList.add(2, new WackyPointsMethod(parameterValues.getValue(CompressionMethodType.WACKY_POINTS)));
            methodList.add(3, new SingletonsMethod(parameterValues.getValue(CompressionMethodType.SINGLETONS)));
            methodList.add(4, new DouglasPeuckerMethod(parameterValues.getValue(CompressionMethodType.DOUGLAS_PEUCKER)));
        }
        this._panelController.setParameterValues(parameterValues);
        for (Object object : methodList) {
            this._panelController.addMethod((CompressionMethod)object, this.getConfig());
        }
        if (this._panelController.getNumPanels() == 0) {
            this._panelController.addMethod(this.getConfig());
        }
        this._panelController.refresh();
    }

    @Override
    public void informNumPointsDeleted(int n) {
        this._summaryLabel.setValue(n);
        this._okButton.setEnabled(n > 0);
    }
}

