/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.List;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.FileInfo;
import tim.prune.data.MarkingData;
import tim.prune.data.MediaList;
import tim.prune.data.Photo;
import tim.prune.data.Selection;
import tim.prune.data.Track;

public class TrackInfo {
    private final Track _track;
    private final Selection _selection;
    private FileInfo _fileInfo = null;
    private final MediaList<Photo> _photoList = new MediaList();
    private final MediaList<AudioClip> _audioList = new MediaList();
    private MarkingData _markingData = null;

    public TrackInfo(Track track) {
        this._track = track;
        this._selection = new Selection(this._track);
    }

    public Track getTrack() {
        return this._track;
    }

    public Selection getSelection() {
        return this._selection;
    }

    public FileInfo getFileInfo() {
        if (this._fileInfo == null) {
            this._fileInfo = new FileInfo();
            int n = 0;
            while (n < this._track.getNumPoints()) {
                this._fileInfo.addSource(this._track.getPoint(n).getSourceInfo());
                ++n;
            }
        }
        return this._fileInfo;
    }

    public void clearFileInfo() {
        this._fileInfo = null;
    }

    public MediaList<Photo> getPhotoList() {
        return this._photoList;
    }

    public MediaList<AudioClip> getAudioList() {
        return this._audioList;
    }

    public DataPoint getCurrentPoint() {
        return this._track.getPoint(this._selection.getCurrentPointIndex());
    }

    public Photo getCurrentPhoto() {
        return this._photoList.get(this._selection.getCurrentPhotoIndex());
    }

    public AudioClip getCurrentAudio() {
        return this._audioList.get(this._selection.getCurrentAudioIndex());
    }

    public boolean deletePoint(int n) {
        if (this._track.deletePoint(n)) {
            this._selection.modifyPointDeleted(n);
            return true;
        }
        return false;
    }

    public void selectPoint(DataPoint dataPoint) {
        this.selectPoint(this._track.getPointIndex(dataPoint));
    }

    public void incrementPointIndex(int n) {
        int n2 = this._selection.getCurrentPointIndex() + n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this._track.getNumPoints()) {
            n2 = this._track.getNumPoints() - 1;
        }
        this.selectPoint(n2);
    }

    public void selectPoint(int n) {
        boolean bl;
        boolean bl2;
        if (this._selection.getCurrentPointIndex() == n || n >= this._track.getNumPoints()) {
            return;
        }
        DataPoint dataPoint = this._track.getPoint(n);
        int n2 = this._selection.getCurrentPhotoIndex();
        boolean bl3 = bl2 = n >= 0 && dataPoint.getPhoto() != null;
        if (bl2) {
            n2 = this._photoList.getIndexOf(dataPoint.getPhoto());
        } else {
            Photo photo = this._photoList.get(n2);
            if (photo == null || photo.isConnected()) {
                n2 = -1;
            }
        }
        int n3 = this._selection.getCurrentAudioIndex();
        boolean bl4 = bl = n >= 0 && dataPoint.getAudio() != null;
        if (bl) {
            n3 = this._audioList.getIndexOf(dataPoint.getAudio());
        } else {
            AudioClip audioClip = this._audioList.get(n3);
            if (audioClip == null || audioClip.isConnected()) {
                n3 = -1;
            }
        }
        this._selection.selectPointPhotoAudio(n, n2, n3);
    }

    public void selectPhoto(int n) {
        if (this._selection.getCurrentPhotoIndex() == n) {
            return;
        }
        Photo photo = this._photoList.get(n);
        int n2 = this._selection.getCurrentPointIndex();
        DataPoint dataPoint = this.getCurrentPoint();
        if (photo != null) {
            if (photo.isConnected()) {
                n2 = this._track.getPointIndex(photo.getDataPoint());
            } else if (n2 >= 0 && this._track.getPoint(n2).getPhoto() != null) {
                n2 = -1;
            }
        } else if (dataPoint != null && dataPoint.getPhoto() != null) {
            n2 = -1;
        }
        DataPoint dataPoint2 = this._track.getPoint(n2);
        int n3 = this._selection.getCurrentAudioIndex();
        if (dataPoint2 != null && dataPoint2.getAudio() != null) {
            n3 = this._audioList.getIndexOf(dataPoint2.getAudio());
        } else if (dataPoint != null && dataPoint2 != dataPoint && dataPoint.getAudio() != null) {
            n3 = -1;
        }
        this._selection.selectPointPhotoAudio(n2, n, n3);
    }

    public void selectAudio(int n) {
        if (this._selection.getCurrentAudioIndex() == n) {
            return;
        }
        AudioClip audioClip = this._audioList.get(n);
        int n2 = this._selection.getCurrentPointIndex();
        DataPoint dataPoint = this.getCurrentPoint();
        if (audioClip != null) {
            if (audioClip.isConnected()) {
                n2 = this._track.getPointIndex(audioClip.getDataPoint());
            } else if (n2 >= 0 && this._track.getPoint(n2).getAudio() != null) {
                n2 = -1;
            }
        } else if (dataPoint != null && dataPoint.getAudio() != null) {
            n2 = -1;
        }
        DataPoint dataPoint2 = this._track.getPoint(n2);
        int n3 = this._selection.getCurrentPhotoIndex();
        if (dataPoint2 != null && dataPoint2.getPhoto() != null) {
            n3 = this._photoList.getIndexOf(dataPoint2.getPhoto());
        } else if (dataPoint != null && dataPoint2 != dataPoint && dataPoint.getPhoto() != null) {
            n3 = -1;
        }
        this._selection.selectPointPhotoAudio(n2, n3, n);
    }

    public void extendSelection(int n) {
        int n2 = this._selection.getStart();
        if (n2 < 0 || this._selection.getCurrentPointIndex() != this._selection.getEnd()) {
            n2 = this._selection.getCurrentPointIndex();
        }
        this.selectPoint(n);
        if (n2 < n) {
            this._selection.selectRange(n2, n);
        }
    }

    public boolean appendRange(List<DataPoint> list) {
        int n = this.getTrack().getNumPoints();
        if (this.getTrack().appendRange(list)) {
            this.selectPoint(n);
            return true;
        }
        return false;
    }

    public boolean hasPointsMarkedForDeletion() {
        return this._markingData != null && this._markingData.hasMarkedPoints();
    }

    public boolean isPointMarkedForDeletion(int n) {
        return this._markingData != null && this._markingData.isPointMarkedForDeletion(n);
    }

    public boolean isPointMarkedForSegmentBreak(int n) {
        return this._markingData != null && this._markingData.isPointMarkedForSegmentBreak(n);
    }

    public void markPointForDeletion(int n) {
        this.markPointForDeletion(n, true);
    }

    public void markPointForDeletion(int n, boolean bl) {
        this.markPointForDeletion(n, bl, false);
    }

    public void markPointForDeletion(int n, boolean bl, boolean bl2) {
        if (this._markingData == null) {
            this._markingData = new MarkingData(this.getTrack());
        }
        this._markingData.markPointForDeletion(n, bl, bl2);
    }

    public void clearAllMarkers() {
        if (this._markingData != null) {
            this._markingData.clear();
        }
    }
}

