/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.I18nManager;

public class TimeDifference {
    private final long _totalSeconds;
    private final int _seconds;
    private final int _minutes;
    private final int _hours;
    private String _description = null;

    public TimeDifference(long l) {
        this._totalSeconds = l;
        if (l < 0L) {
            l = -l;
        }
        this._hours = (int)(l / 60L / 60L);
        this._minutes = (int)(l / 60L - (long)this._hours * 60L);
        this._seconds = (int)(l % 60L);
    }

    public TimeDifference(int n, int n2, int n3, boolean bl) {
        this._hours = n;
        this._minutes = n2;
        this._seconds = n3;
        long l = (long)n * 3600L + (long)n2 * 60L + (long)n3;
        this._totalSeconds = bl ? l : -l;
    }

    public long getTotalSeconds() {
        return this._totalSeconds;
    }

    public int getNumHours() {
        return this._hours;
    }

    public int getNumMinutes() {
        return this._minutes;
    }

    public int getNumSeconds() {
        return this._seconds;
    }

    public boolean getIsPositive() {
        return this._totalSeconds >= 0L;
    }

    public String getDescription() {
        if (this._description != null) {
            return this._description;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this._hours > 0) {
            stringBuilder.append(this._hours).append(' ').append(I18nManager.getText("display.range.time.hours"));
            bl = true;
        }
        if (this._minutes > 0) {
            if (bl) {
                stringBuilder.append(", ");
            } else {
                bl = true;
            }
            stringBuilder.append(this._minutes).append(' ').append(I18nManager.getText("display.range.time.mins"));
        }
        if (this._seconds > 0 || !bl) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this._seconds).append(' ').append(I18nManager.getText("display.range.time.secs"));
        }
        this._description = stringBuilder.toString();
        return this._description;
    }
}

