/*
 * Decompiled with CFR 0.152.
 */
package com.lizardworks.tiff;

import com.lizardworks.tiff.IFD;
import com.lizardworks.tiff.RawImage;
import com.lizardworks.tiff.T4Code;
import com.lizardworks.tiff.T4Node;
import com.lizardworks.tiff.T4Tables;
import com.lizardworks.util.Converter;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

class CCITTG4Image
extends RawImage {
    byte[] WhiteRun;
    byte[] BlackRun;
    byte[] bytesArray;
    byte[] rawImage;
    boolean whiteRun = true;
    int lines = 0;
    int nPixels = 0;
    int longHoriztonalRun = 0;
    boolean hiloBitOrder = false;
    int i;
    int j;
    int shift;
    int count;
    int a0;
    int b1;
    int[] ref;
    int[] cur;
    int refIndex;
    int curIndex;
    int runLength;
    byte b;
    byte[] tmp;
    long start;
    long stop;
    T4Node WhiteTree;
    T4Node BlackTree;
    T4Node ModeTree;
    T4Node node;
    T4Code code;
    public static final int P = 0;
    public static final int H = 1;
    public static final int V0 = 2;
    public static final int VR1 = 3;
    public static final int VR2 = 4;
    public static final int VR3 = 5;
    public static final int VL1 = 6;
    public static final int VL2 = 7;
    public static final int VL3 = 8;
    public static final int EXT2D = 9;
    public static final int EXT1D = 10;
    public static final int[][] ModeCodes;

    static {
        int[][] nArrayArray = new int[12][];
        int[] nArray = new int[3];
        nArray[0] = 4;
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{3, 1, 1};
        nArrayArray[2] = new int[]{1, 1, 2};
        nArrayArray[3] = new int[]{3, 3, 3};
        nArrayArray[4] = new int[]{6, 3, 4};
        nArrayArray[5] = new int[]{7, 3, 5};
        nArrayArray[6] = new int[]{3, 2, 6};
        nArrayArray[7] = new int[]{6, 2, 7};
        nArrayArray[8] = new int[]{7, 2, 8};
        nArrayArray[9] = new int[]{10, 15, 9};
        nArrayArray[10] = new int[]{12, 15, 10};
        nArrayArray[11] = new int[]{12, 1, -1};
        ModeCodes = nArrayArray;
    }

    public CCITTG4Image(IFD ifd) {
        super(ifd);
        this.hiloBitOrder = ifd.GetFieldValue(266) == 2;
        this.init();
    }

    public CCITTG4Image(int imageWidth, int imageHeight, byte[] bytesArray, boolean hiloBitOrder) {
        super(new IFD());
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.imageBytes = bytesArray;
        this.hiloBitOrder = hiloBitOrder;
        this.init();
    }

    void init() {
        this.WhiteTree = new T4Node();
        this.BlackTree = new T4Node();
        this.ModeTree = new T4Node();
        if (this.hiloBitOrder) {
            int lo;
            this.i = 0;
            while (this.i < ModeCodes.length) {
                this.code = new T4Code(ModeCodes[this.i]);
                if (this.code.bitLength <= 8) {
                    lo = Converter.reverseByte(Converter.getLoByte(this.code.codeWord));
                    this.code.codeWord = lo >>> 8 - this.code.bitLength;
                } else {
                    this.code.codeWord = Converter.reverseInt(this.code.codeWord) >>> 16 - this.code.bitLength;
                }
                this.ModeTree.ReversedAdd(0, this.code);
                ++this.i;
            }
            this.i = 0;
            while (this.i < T4Tables.WhiteCodes.length) {
                this.code = new T4Code(T4Tables.WhiteCodes[this.i]);
                if (this.code.bitLength <= 8) {
                    lo = Converter.reverseByte(Converter.getLoByte(this.code.codeWord));
                    this.code.codeWord = lo >>> 8 - this.code.bitLength;
                } else {
                    this.code.codeWord = Converter.reverseInt(this.code.codeWord) >>> 16 - this.code.bitLength;
                }
                this.WhiteTree.ReversedAdd(0, this.code);
                ++this.i;
            }
            this.i = 0;
            while (this.i < T4Tables.BlackCodes.length) {
                this.code = new T4Code(T4Tables.BlackCodes[this.i]);
                if (this.code.bitLength <= 8) {
                    lo = Converter.reverseByte(Converter.getLoByte(this.code.codeWord));
                    this.code.codeWord = lo >>> 8 - this.code.bitLength;
                } else {
                    this.code.codeWord = Converter.reverseInt(this.code.codeWord) >>> 16 - this.code.bitLength;
                }
                this.BlackTree.ReversedAdd(0, this.code);
                ++this.i;
            }
        } else {
            this.i = 0;
            while (this.i < ModeCodes.length) {
                this.code = new T4Code(ModeCodes[this.i]);
                this.ModeTree.Add(0, this.code);
                ++this.i;
            }
            this.i = 0;
            while (this.i < T4Tables.WhiteCodes.length) {
                this.code = new T4Code(T4Tables.WhiteCodes[this.i]);
                this.WhiteTree.Add(0, this.code);
                ++this.i;
            }
            this.i = 0;
            while (this.i < T4Tables.BlackCodes.length) {
                this.code = new T4Code(T4Tables.BlackCodes[this.i]);
                this.BlackTree.Add(0, this.code);
                ++this.i;
            }
        }
        this.WhiteRun = new byte[this.imageWidth + 2];
        this.BlackRun = new byte[this.imageWidth + 2];
        this.i = 0;
        while (this.i < this.imageWidth + 1) {
            this.WhiteRun[this.i] = -1;
            this.BlackRun[this.i] = 0;
            ++this.i;
        }
    }

    @Override
    public Object getImageProducer() {
        byte[] rawImage = this.getRawImage();
        if (this.bitsPerSample == 8 && rawImage != null) {
            ColorModel cm = this.makeColorModel();
            return new MemoryImageSource(this.imageWidth, this.imageHeight, cm, this.imageBytes, 0, this.imageWidth);
        }
        return null;
    }

    public byte[] getRawImage() {
        if (this.imageBytes == null && this.imageStrips != null) {
            int rowsPerStrip = this.ifd.GetFieldValue(278);
            this.imageBytes = new byte[this.imageWidth * this.imageHeight];
            int i = 0;
            int n = 0;
            int rows = 0;
            int lastRow = this.imageStrips.length - 1;
            while (i < this.imageStrips.length) {
                byte[] rawStrip = this.DecodeImageStrip(this.imageStrips[i], i == lastRow ? this.imageHeight - rows : rowsPerStrip);
                System.arraycopy(rawStrip, 0, this.imageBytes, n, this.nPixels);
                n += this.nPixels;
                this.nPixels = 0;
                ++i;
                rows += rowsPerStrip;
            }
            this.imageStrips = null;
        } else if (this.imageBytes != null) {
            this.imageBytes = this.DecodeImage();
        } else {
            return null;
        }
        return this.imageBytes;
    }

    byte[] DecodeImage() {
        return this.DecodeImageStrip(this.imageBytes, this.imageHeight);
    }

    /*
     * Enabled aggressive block sorting
     */
    byte[] DecodeImageStrip(byte[] imageStrip, int maxLines) {
        this.bytesArray = imageStrip;
        int expectedCount = this.imageWidth * maxLines;
        this.rawImage = new byte[expectedCount + 1];
        this.tmp = new byte[2];
        this.ref = new int[this.imageWidth + 1];
        this.cur = new int[this.imageWidth + 1];
        this.ref[0] = this.imageWidth;
        this.ref[1] = 0;
        this.runLength = 0;
        this.a0 = 0;
        this.b1 = this.ref[0];
        this.refIndex = 1;
        this.curIndex = 0;
        this.nPixels = 0;
        this.lines = 0;
        this.longHoriztonalRun = 0;
        this.whiteRun = true;
        this.code = new T4Code();
        this.i = 0;
        this.lines = 1;
        this.count = this.bytesArray.length * 8;
        block13: while (this.lines <= maxLines && this.i < this.count) {
            this.i = this.readMode(this.i);
            switch (this.code.runLength) {
                case 0: {
                    this.decodePass();
                    continue block13;
                }
                case 1: {
                    this.i = this.decodeHorizontal(this.tmp, this.i);
                    this.i = this.decodeHorizontal(this.tmp, this.i);
                    this.detectB1();
                    break;
                }
                case 2: {
                    this.detectB1();
                    this.addRun(this.b1 - this.a0);
                    this.whiteRun = !this.whiteRun;
                    this.b1 += this.ref[this.refIndex++];
                    break;
                }
                case 3: {
                    this.detectB1();
                    this.addRun(this.b1 - this.a0 + 1);
                    this.whiteRun = !this.whiteRun;
                    this.b1 += this.ref[this.refIndex++];
                    break;
                }
                case 4: {
                    this.detectB1();
                    this.addRun(this.b1 - this.a0 + 2);
                    this.whiteRun = !this.whiteRun;
                    this.b1 += this.ref[this.refIndex++];
                    break;
                }
                case 5: {
                    this.detectB1();
                    this.addRun(this.b1 - this.a0 + 3);
                    this.whiteRun = !this.whiteRun;
                    this.b1 += this.ref[this.refIndex++];
                    break;
                }
                case 6: {
                    this.detectB1();
                    this.addRun(this.b1 - this.a0 - 1);
                    boolean bl = this.whiteRun = !this.whiteRun;
                    if (this.refIndex <= 0) break;
                    this.b1 -= this.ref[--this.refIndex];
                    break;
                }
                case 7: {
                    this.detectB1();
                    this.addRun(this.b1 - this.a0 - 2);
                    boolean bl = this.whiteRun = !this.whiteRun;
                    if (this.refIndex <= 0) break;
                    this.b1 -= this.ref[--this.refIndex];
                    break;
                }
                case 8: {
                    this.detectB1();
                    this.addRun(this.b1 - this.a0 - 3);
                    boolean bl = this.whiteRun = !this.whiteRun;
                    if (this.refIndex <= 0) break;
                    this.b1 -= this.ref[--this.refIndex];
                    break;
                }
                case 9: 
                case 10: {
                    System.out.println("NO NO I WON'T DO UNCOMPRESSED!");
                    return null;
                }
                case -1: {
                    System.out.println("End of the line");
                    ++this.lines;
                    this.whiteRun = true;
                    this.resetRuns();
                }
            }
            if (this.runLength < 0) {
                System.out.println("negative runLength=" + this.runLength);
                return null;
            }
            if (this.a0 < this.imageWidth) continue;
            ++this.lines;
            this.whiteRun = true;
            this.resetRuns();
        }
        this.bitsPerSample = 8;
        return this.rawImage;
    }

    public int readMode(int i) {
        int j = i / 8;
        int shift = i % 8;
        this.copyBits(this.bytesArray, this.tmp, j, shift);
        this.node = this.ModeTree.Find(Converter.bytesToInt(this.tmp));
        if (this.node != null) {
            this.code = this.node.code;
        }
        return i += this.code.bitLength;
    }

    public void detectB1() {
        if (this.curIndex != 0) {
            while (this.b1 <= this.a0 && this.b1 < this.imageWidth) {
                int r = this.ref[this.refIndex] + this.ref[this.refIndex + 1];
                if (r == 0) {
                    this.b1 = this.imageWidth;
                }
                this.b1 += r;
                if (this.refIndex + 2 < this.ref.length) {
                    this.refIndex += 2;
                    continue;
                }
                System.out.println("ERROR in detectB1, refIndex=" + this.refIndex + ", ref.length=" + this.ref.length);
            }
        }
    }

    public void copyBits(byte[] bytesArray, byte[] tmp, int j, int shift) {
        byte b3;
        byte b1 = bytesArray[j];
        byte b2 = j + 1 < bytesArray.length ? bytesArray[j + 1] : (byte)0;
        byte by = b3 = j + 2 < bytesArray.length ? bytesArray[j + 2] : (byte)0;
        if (shift > 0) {
            if (this.hiloBitOrder) {
                tmp[1] = (byte)(((b1 & 0xFF) >>> shift) + ((b2 & 255 >>> 8 - shift) << 8 - shift));
                tmp[0] = (byte)(((b2 & 0xFF) >>> shift) + ((b3 & 255 >>> 8 - shift) << 8 - shift));
            } else {
                tmp[0] = (byte)(((b1 & 0xFF) << shift) + ((b2 & 0xFF) >> 8 - shift));
                tmp[1] = (byte)(((b2 & 0xFF) << shift) + ((b3 & 0xFF) >> 8 - shift));
            }
        } else if (this.hiloBitOrder) {
            tmp[1] = b1;
            tmp[0] = b2;
        } else {
            tmp[0] = b1;
            tmp[1] = b2;
        }
    }

    public void decodePass() {
        this.detectB1();
        this.b1 += this.ref[this.refIndex++];
        this.runLength += this.b1 - this.a0;
        this.a0 = this.b1;
        this.b1 += this.ref[this.refIndex++];
    }

    public int decodeHorizontal(byte[] tmp, int i) {
        do {
            int j = i / 8;
            int shift = i % 8;
            this.copyBits(this.bytesArray, tmp, j, shift);
            this.node = this.whiteRun ? this.WhiteTree.Find(Converter.bytesToInt(tmp)) : this.BlackTree.Find(Converter.bytesToInt(tmp));
            if (this.node != null) {
                this.code = this.node.code;
            }
            if (this.code.runLength >= 0) {
                if (this.code.runLength < 64) {
                    this.addRun(this.code.runLength + this.longHoriztonalRun);
                    this.whiteRun = !this.whiteRun;
                    this.longHoriztonalRun = 0;
                } else {
                    this.longHoriztonalRun += this.code.runLength;
                }
            } else {
                if (this.code.runLength == -3) {
                    --this.lines;
                    System.out.print("---" + this.code);
                    return -3;
                }
                this.addRun(this.code.runLength);
                System.out.print(this.code + "~~");
                System.out.print(String.valueOf(this.whiteRun ? "W" : "B") + this.code.runLength);
                System.out.print("~~");
            }
            i += this.code.bitLength;
            if (this.nPixels <= 0 || this.code.runLength != -1) continue;
            this.whiteRun = true;
            ++this.lines;
            this.resetRuns();
        } while (this.code.runLength >= 64);
        return i;
    }

    public void addRun(int x) {
        this.runLength += x;
        if (this.runLength < 0 || this.curIndex + 1 >= this.cur.length || this.nPixels + this.runLength >= this.rawImage.length || this.runLength >= this.WhiteRun.length) {
            System.out.println("x=" + x + ", runLength=" + this.runLength + ", curIndex=" + this.curIndex + ", nPixels=" + this.nPixels);
            System.out.println("cur.length=" + this.cur.length + ", rawImage.length=" + this.rawImage.length + ", WhiteRun.length=" + this.WhiteRun.length);
            System.out.flush();
            return;
        }
        this.cur[this.curIndex++] = this.runLength;
        this.a0 += x;
        if (this.runLength > 0) {
            System.arraycopy(this.whiteRun ? this.WhiteRun : this.BlackRun, 0, this.rawImage, this.nPixels, this.runLength);
            this.nPixels += this.runLength;
        }
        this.runLength = 0;
    }

    public void resetRuns() {
        this.addRun(0);
        if (this.a0 != this.imageWidth) {
            System.out.println(this.a0 < this.imageWidth ? "Premature EOL" : "Line length mismatch");
            while (this.a0 > this.imageWidth) {
                this.a0 -= this.cur[--this.curIndex];
            }
            if (this.a0 < this.imageWidth) {
                if (this.a0 < 0) {
                    this.a0 = 0;
                }
                if ((this.curIndex & 1) != 0) {
                    this.addRun(0);
                }
                this.addRun(this.imageWidth - this.a0);
            } else if (this.a0 > this.imageWidth) {
                this.addRun(this.imageWidth);
                this.addRun(0);
            }
        }
        int[] tmp = this.ref;
        this.ref = this.cur;
        this.cur = tmp;
        int i = this.curIndex;
        while (i < this.imageWidth) {
            this.ref[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.imageWidth) {
            this.cur[i] = 0;
            ++i;
        }
        this.runLength = 0;
        this.a0 = 0;
        this.b1 = this.ref[0];
        this.refIndex = 1;
        this.curIndex = 0;
    }
}

