/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.util.CollectionUtils;

public class UnitTypeOption
extends AbstractOption<UnitType> {
    private static final Logger logger = Logger.getLogger(UnitTypeOption.class.getName());
    public static final String TAG = "unitTypeOption";
    private UnitType value;
    private boolean addNone;
    private TypeSelector selector = TypeSelector.UNITS;
    private final List<UnitType> choices = new ArrayList<UnitType>();
    private static final String ADD_NONE_TAG = "addNone";
    private static final String CHOICE_TAG = "choice";
    private static final String GENERATE_TAG = "generate";

    public UnitTypeOption(Specification specification) {
        super(specification);
    }

    public UnitTypeOption(String id, Specification specification) {
        super(id, specification);
    }

    public final boolean addNone() {
        return this.addNone;
    }

    public final List<UnitType> getChoices() {
        return this.choices;
    }

    public final TypeSelector getSelector() {
        return this.selector;
    }

    @Override
    public UnitTypeOption cloneOption() {
        UnitTypeOption ret = new UnitTypeOption(this.getId(), this.getSpecification());
        ret.value = this.value;
        ret.addNone = this.addNone;
        ret.selector = this.selector;
        ret.choices.clear();
        ret.choices.addAll(this.choices);
        return ret;
    }

    @Override
    public UnitType getValue() {
        return this.value;
    }

    @Override
    public void setValue(UnitType value) {
        UnitType oldValue = this.value;
        this.value = value;
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        if (valueString != null) {
            this.setValue(this.getSpecification().getUnitType(valueString));
        } else if (defaultValueString != null) {
            this.setValue(this.getSpecification().getUnitType(defaultValueString));
        } else {
            this.setValue(null);
        }
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    public void generateChoices() {
        if (this.selector == null) {
            UnitType val = this.getValue();
            if (val != null && this.choices.isEmpty()) {
                this.choices.add(val);
            }
        } else {
            List<UnitType> unitTypeList = this.getSpecification().getUnitTypeList();
            this.choices.clear();
            switch (this.selector) {
                case UNITS: {
                    this.choices.addAll(unitTypeList);
                    break;
                }
                case IMMIGRANTS: {
                    this.choices.addAll(CollectionUtils.transform(unitTypeList, UnitType::isRecruitable));
                    break;
                }
                case NAVAL_UNITS: {
                    this.choices.addAll(CollectionUtils.transform(unitTypeList, UnitType::isNaval));
                    break;
                }
                case LAND_UNITS: {
                    this.choices.addAll(CollectionUtils.transform(unitTypeList, ut -> !ut.isNaval()));
                }
            }
            if (this.addNone) {
                this.choices.add(0, null);
            }
        }
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.value != null) {
            xw.writeAttribute("value", this.value);
        }
        if (this.selector != null) {
            xw.writeAttribute(GENERATE_TAG, this.selector);
        }
        if (this.addNone) {
            xw.writeAttribute(ADD_NONE_TAG, this.addNone);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.choices != null && !this.choices.isEmpty()) {
            for (UnitType choice : this.choices) {
                xw.writeStartElement(CHOICE_TAG);
                xw.writeAttribute("value", choice);
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.selector = xr.getAttribute(GENERATE_TAG, TypeSelector.class, null);
        this.addNone = xr.getAttribute(ADD_NONE_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.choices.clear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (CHOICE_TAG.equals(tag)) {
            this.choices.add(xr.getType(spec, "value", UnitType.class, null));
            xr.closeTag(CHOICE_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[').append(this.getId()).append(" value=").append(this.value).append(" addNone=").append(this.addNone).append(" selector=").append((Object)this.selector).append(" choices=[");
        for (UnitType choice : this.choices) {
            sb.append(' ').append(choice);
        }
        sb.append(" ]]");
        return sb.toString();
    }

    public static enum TypeSelector {
        UNITS,
        IMMIGRANTS,
        LAND_UNITS,
        NAVAL_UNITS;

    }
}

