﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/payment-cryptography-data/PaymentCryptographyData_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace PaymentCryptographyData {
namespace Model {
class EncryptDataResult {
 public:
  AWS_PAYMENTCRYPTOGRAPHYDATA_API EncryptDataResult() = default;
  AWS_PAYMENTCRYPTOGRAPHYDATA_API EncryptDataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PAYMENTCRYPTOGRAPHYDATA_API EncryptDataResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The <code>keyARN</code> of the encryption key that Amazon Web Services
   * Payment Cryptography uses for plaintext encryption.</p>
   */
  inline const Aws::String& GetKeyArn() const { return m_keyArn; }
  template <typename KeyArnT = Aws::String>
  void SetKeyArn(KeyArnT&& value) {
    m_keyArnHasBeenSet = true;
    m_keyArn = std::forward<KeyArnT>(value);
  }
  template <typename KeyArnT = Aws::String>
  EncryptDataResult& WithKeyArn(KeyArnT&& value) {
    SetKeyArn(std::forward<KeyArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The key check value (KCV) of the encryption key. The KCV is used to check if
   * all parties holding a given key have the same key or to detect that a key has
   * changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV
   * according to the CMAC specification.</p>
   */
  inline const Aws::String& GetKeyCheckValue() const { return m_keyCheckValue; }
  template <typename KeyCheckValueT = Aws::String>
  void SetKeyCheckValue(KeyCheckValueT&& value) {
    m_keyCheckValueHasBeenSet = true;
    m_keyCheckValue = std::forward<KeyCheckValueT>(value);
  }
  template <typename KeyCheckValueT = Aws::String>
  EncryptDataResult& WithKeyCheckValue(KeyCheckValueT&& value) {
    SetKeyCheckValue(std::forward<KeyCheckValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The encrypted ciphertext.</p>
   */
  inline const Aws::String& GetCipherText() const { return m_cipherText; }
  template <typename CipherTextT = Aws::String>
  void SetCipherText(CipherTextT&& value) {
    m_cipherTextHasBeenSet = true;
    m_cipherText = std::forward<CipherTextT>(value);
  }
  template <typename CipherTextT = Aws::String>
  EncryptDataResult& WithCipherText(CipherTextT&& value) {
    SetCipherText(std::forward<CipherTextT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  EncryptDataResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_keyArn;

  Aws::String m_keyCheckValue;

  Aws::String m_cipherText;

  Aws::String m_requestId;
  bool m_keyArnHasBeenSet = false;
  bool m_keyCheckValueHasBeenSet = false;
  bool m_cipherTextHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace PaymentCryptographyData
}  // namespace Aws
